/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.call.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.call.dto.resp.CallTaskRespDto;
import com.kuaike.scrm.call.enums.ApiTypeEnum;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.call.dto.CallRecordQueryParams;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.call.entity.CallStatistic;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class CallRecordReqDto {
    private Long id;
    private String num;
    private String userId;
    private Long callUserId;
    private Set<Long> userIds;
    private String nodeId;
    private String phone;
    private List<String> phones;
    private String name;
    private Long detailId;
    private Date startTime;
    private Date endTime;
    private Integer status;
    private Integer type;
    private Integer userType;
    private Integer apiType;
    private PageDto pageDto;
    private String batchId;
    private String voiceUrl;
    private String callType;
    private String sessionId;
    private String customerPhone;
    private String middlePhone;
    private Long callDurationMin;
    private Long callDurationMax;

    private void validateBaseParams(CurrentUserInfo currentUserInfo) {
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateListParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateCallParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.batchId) || StringUtils.isNotBlank((CharSequence)this.phone) || !ObjectUtils.isEmpty((Object)this.detailId) ? 1 : 0) != 0, (Object)"\u88ab\u53eb\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateIdParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!ObjectUtils.isEmpty((Object)this.id) || StringUtils.isNotBlank((CharSequence)this.voiceUrl) ? 1 : 0) != 0, (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void validateCalledParams(CurrentUserInfo currentUserInfo) {
        this.validateBaseParams(currentUserInfo);
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this.phones) ? 1 : 0) != 0, (Object)"\u624b\u673a\u53f7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public CallRecordQueryParams to(Long bizId) {
        CallRecordQueryParams queryParams = new CallRecordQueryParams();
        queryParams.setBizId(bizId);
        queryParams.setStartDate(this.startTime);
        queryParams.setPhones(this.phones);
        queryParams.setEndDate(this.endTime);
        queryParams.setStatus(this.status);
        queryParams.setPageDto(this.pageDto);
        queryParams.setDetailId(this.detailId);
        queryParams.setUserId(this.callUserId);
        queryParams.setUserType(this.userType);
        queryParams.setMemberUserId(this.userId);
        queryParams.setCustomerPhone(this.customerPhone);
        queryParams.setMiddlePhone(this.middlePhone);
        queryParams.setUserIds(this.userIds);
        queryParams.setCallDurationMin(this.callDurationMin);
        queryParams.setCallDurationMax(this.callDurationMax);
        return queryParams;
    }

    public CallRecord backward(CurrentUserInfo currentUser, String num, String phone, String name, String userPhone, String apiCallId, String defaultExtenType) {
        return CallRecord.builder().num(num).bizId(currentUser.getBizId()).corpId(currentUser.getCorpId()).customerName(StringUtils.isNotBlank((CharSequence)name) && name.length() > 20 ? name.substring(0, 20) : name).customerPhone(phone).userType(Integer.valueOf(this.userType == null ? 0 : this.userType)).apiType(Integer.valueOf(ApiTypeEnum.ofValue(defaultExtenType))).callTaskDetailId(this.detailId).apiCallId(apiCallId).userId(currentUser.getId()).userPhone(userPhone).type(Integer.valueOf(this.type == null ? 0 : this.type)).status(Integer.valueOf(this.status == null ? 0 : this.status)).canceled(Integer.valueOf(0)).isOpenapi(Integer.valueOf(0)).nodeId(Long.valueOf(Objects.isNull(currentUser.getUserNodeId()) ? -1L : currentUser.getUserNodeId())).createTime(new Date()).createBy(currentUser.getId()).updateTime(new Date()).updateBy(currentUser.getId()).build();
    }

    public Long getId() {
        return this.id;
    }

    public String getNum() {
        return this.num;
    }

    public String getUserId() {
        return this.userId;
    }

    public Long getCallUserId() {
        return this.callUserId;
    }

    public Set<Long> getUserIds() {
        return this.userIds;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getPhone() {
        return this.phone;
    }

    public List<String> getPhones() {
        return this.phones;
    }

    public String getName() {
        return this.name;
    }

    public Long getDetailId() {
        return this.detailId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public Integer getApiType() {
        return this.apiType;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getVoiceUrl() {
        return this.voiceUrl;
    }

    public String getCallType() {
        return this.callType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public String getMiddlePhone() {
        return this.middlePhone;
    }

    public Long getCallDurationMin() {
        return this.callDurationMin;
    }

    public Long getCallDurationMax() {
        return this.callDurationMax;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setCallUserId(Long callUserId) {
        this.callUserId = callUserId;
    }

    public void setUserIds(Set<Long> userIds) {
        this.userIds = userIds;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setPhones(List<String> phones) {
        this.phones = phones;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public void setApiType(Integer apiType) {
        this.apiType = apiType;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setVoiceUrl(String voiceUrl) {
        this.voiceUrl = voiceUrl;
    }

    public void setCallType(String callType) {
        this.callType = callType;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public void setMiddlePhone(String middlePhone) {
        this.middlePhone = middlePhone;
    }

    public void setCallDurationMin(Long callDurationMin) {
        this.callDurationMin = callDurationMin;
    }

    public void setCallDurationMax(Long callDurationMax) {
        this.callDurationMax = callDurationMax;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallRecordReqDto)) {
            return false;
        }
        CallRecordReqDto other = (CallRecordReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$callUserId = this.getCallUserId();
        Long other$callUserId = other.getCallUserId();
        if (this$callUserId == null ? other$callUserId != null : !((Object)this$callUserId).equals(other$callUserId)) {
            return false;
        }
        Long this$detailId = this.getDetailId();
        Long other$detailId = other.getDetailId();
        if (this$detailId == null ? other$detailId != null : !((Object)this$detailId).equals(other$detailId)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$userType = this.getUserType();
        Integer other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        Integer this$apiType = this.getApiType();
        Integer other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !((Object)this$apiType).equals(other$apiType)) {
            return false;
        }
        Long this$callDurationMin = this.getCallDurationMin();
        Long other$callDurationMin = other.getCallDurationMin();
        if (this$callDurationMin == null ? other$callDurationMin != null : !((Object)this$callDurationMin).equals(other$callDurationMin)) {
            return false;
        }
        Long this$callDurationMax = this.getCallDurationMax();
        Long other$callDurationMax = other.getCallDurationMax();
        if (this$callDurationMax == null ? other$callDurationMax != null : !((Object)this$callDurationMax).equals(other$callDurationMax)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Set<Long> this$userIds = this.getUserIds();
        Set<Long> other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
            return false;
        }
        String this$nodeId = this.getNodeId();
        String other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !this$nodeId.equals(other$nodeId)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        List<String> this$phones = this.getPhones();
        List<String> other$phones = other.getPhones();
        if (this$phones == null ? other$phones != null : !((Object)this$phones).equals(other$phones)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$batchId = this.getBatchId();
        String other$batchId = other.getBatchId();
        if (this$batchId == null ? other$batchId != null : !this$batchId.equals(other$batchId)) {
            return false;
        }
        String this$voiceUrl = this.getVoiceUrl();
        String other$voiceUrl = other.getVoiceUrl();
        if (this$voiceUrl == null ? other$voiceUrl != null : !this$voiceUrl.equals(other$voiceUrl)) {
            return false;
        }
        String this$callType = this.getCallType();
        String other$callType = other.getCallType();
        if (this$callType == null ? other$callType != null : !this$callType.equals(other$callType)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        String this$middlePhone = this.getMiddlePhone();
        String other$middlePhone = other.getMiddlePhone();
        return !(this$middlePhone == null ? other$middlePhone != null : !this$middlePhone.equals(other$middlePhone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallRecordReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $callUserId = this.getCallUserId();
        result = result * 59 + ($callUserId == null ? 43 : ((Object)$callUserId).hashCode());
        Long $detailId = this.getDetailId();
        result = result * 59 + ($detailId == null ? 43 : ((Object)$detailId).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        Integer $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : ((Object)$apiType).hashCode());
        Long $callDurationMin = this.getCallDurationMin();
        result = result * 59 + ($callDurationMin == null ? 43 : ((Object)$callDurationMin).hashCode());
        Long $callDurationMax = this.getCallDurationMax();
        result = result * 59 + ($callDurationMax == null ? 43 : ((Object)$callDurationMax).hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Set<Long> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        String $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : $nodeId.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        List<String> $phones = this.getPhones();
        result = result * 59 + ($phones == null ? 43 : ((Object)$phones).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $batchId = this.getBatchId();
        result = result * 59 + ($batchId == null ? 43 : $batchId.hashCode());
        String $voiceUrl = this.getVoiceUrl();
        result = result * 59 + ($voiceUrl == null ? 43 : $voiceUrl.hashCode());
        String $callType = this.getCallType();
        result = result * 59 + ($callType == null ? 43 : $callType.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        String $middlePhone = this.getMiddlePhone();
        result = result * 59 + ($middlePhone == null ? 43 : $middlePhone.hashCode());
        return result;
    }

    public String toString() {
        return "CallRecordReqDto(id=" + this.getId() + ", num=" + this.getNum() + ", userId=" + this.getUserId() + ", callUserId=" + this.getCallUserId() + ", userIds=" + this.getUserIds() + ", nodeId=" + this.getNodeId() + ", phone=" + this.getPhone() + ", phones=" + this.getPhones() + ", name=" + this.getName() + ", detailId=" + this.getDetailId() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", userType=" + this.getUserType() + ", apiType=" + this.getApiType() + ", pageDto=" + this.getPageDto() + ", batchId=" + this.getBatchId() + ", voiceUrl=" + this.getVoiceUrl() + ", callType=" + this.getCallType() + ", sessionId=" + this.getSessionId() + ", customerPhone=" + this.getCustomerPhone() + ", middlePhone=" + this.getMiddlePhone() + ", callDurationMin=" + this.getCallDurationMin() + ", callDurationMax=" + this.getCallDurationMax() + ")";
    }

    public static class CallTaskDetailStatisticRespDto {
        private Long callTaskId;
        private List<CallTaskRespDto> users;
        private Integer customerCount;
        private Integer calledSuccessCount;
        private Integer calledCount;
        private Double callProgress;
        private Integer notSupportVoisCount;
        private Integer startVoisCount;
        private Integer nobodyVoisCount;
        private Integer notSendVoisCount;
        private Integer timeoutVoisCount;

        public CallTaskDetailStatisticRespDto() {
        }

        CallTaskDetailStatisticRespDto(Long callTaskId, List<CallTaskRespDto> users, Integer customerCount, Integer calledSuccessCount, Integer calledCount, Double callProgress, Integer notSupportVoisCount, Integer startVoisCount, Integer nobodyVoisCount, Integer notSendVoisCount, Integer timeoutVoisCount) {
            this.callTaskId = callTaskId;
            this.users = users;
            this.customerCount = customerCount;
            this.calledSuccessCount = calledSuccessCount;
            this.calledCount = calledCount;
            this.callProgress = callProgress;
            this.notSupportVoisCount = notSupportVoisCount;
            this.startVoisCount = startVoisCount;
            this.nobodyVoisCount = nobodyVoisCount;
            this.notSendVoisCount = notSendVoisCount;
            this.timeoutVoisCount = timeoutVoisCount;
        }

        public static CallTaskDetailStatisticRespDtoBuilder builder() {
            return new CallTaskDetailStatisticRespDtoBuilder();
        }

        public Long getCallTaskId() {
            return this.callTaskId;
        }

        public List<CallTaskRespDto> getUsers() {
            return this.users;
        }

        public Integer getCustomerCount() {
            return this.customerCount;
        }

        public Integer getCalledSuccessCount() {
            return this.calledSuccessCount;
        }

        public Integer getCalledCount() {
            return this.calledCount;
        }

        public Double getCallProgress() {
            return this.callProgress;
        }

        public Integer getNotSupportVoisCount() {
            return this.notSupportVoisCount;
        }

        public Integer getStartVoisCount() {
            return this.startVoisCount;
        }

        public Integer getNobodyVoisCount() {
            return this.nobodyVoisCount;
        }

        public Integer getNotSendVoisCount() {
            return this.notSendVoisCount;
        }

        public Integer getTimeoutVoisCount() {
            return this.timeoutVoisCount;
        }

        public void setCallTaskId(Long callTaskId) {
            this.callTaskId = callTaskId;
        }

        public void setUsers(List<CallTaskRespDto> users) {
            this.users = users;
        }

        public void setCustomerCount(Integer customerCount) {
            this.customerCount = customerCount;
        }

        public void setCalledSuccessCount(Integer calledSuccessCount) {
            this.calledSuccessCount = calledSuccessCount;
        }

        public void setCalledCount(Integer calledCount) {
            this.calledCount = calledCount;
        }

        public void setCallProgress(Double callProgress) {
            this.callProgress = callProgress;
        }

        public void setNotSupportVoisCount(Integer notSupportVoisCount) {
            this.notSupportVoisCount = notSupportVoisCount;
        }

        public void setStartVoisCount(Integer startVoisCount) {
            this.startVoisCount = startVoisCount;
        }

        public void setNobodyVoisCount(Integer nobodyVoisCount) {
            this.nobodyVoisCount = nobodyVoisCount;
        }

        public void setNotSendVoisCount(Integer notSendVoisCount) {
            this.notSendVoisCount = notSendVoisCount;
        }

        public void setTimeoutVoisCount(Integer timeoutVoisCount) {
            this.timeoutVoisCount = timeoutVoisCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallTaskDetailStatisticRespDto)) {
                return false;
            }
            CallTaskDetailStatisticRespDto other = (CallTaskDetailStatisticRespDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$callTaskId = this.getCallTaskId();
            Long other$callTaskId = other.getCallTaskId();
            if (this$callTaskId == null ? other$callTaskId != null : !((Object)this$callTaskId).equals(other$callTaskId)) {
                return false;
            }
            Integer this$customerCount = this.getCustomerCount();
            Integer other$customerCount = other.getCustomerCount();
            if (this$customerCount == null ? other$customerCount != null : !((Object)this$customerCount).equals(other$customerCount)) {
                return false;
            }
            Integer this$calledSuccessCount = this.getCalledSuccessCount();
            Integer other$calledSuccessCount = other.getCalledSuccessCount();
            if (this$calledSuccessCount == null ? other$calledSuccessCount != null : !((Object)this$calledSuccessCount).equals(other$calledSuccessCount)) {
                return false;
            }
            Integer this$calledCount = this.getCalledCount();
            Integer other$calledCount = other.getCalledCount();
            if (this$calledCount == null ? other$calledCount != null : !((Object)this$calledCount).equals(other$calledCount)) {
                return false;
            }
            Double this$callProgress = this.getCallProgress();
            Double other$callProgress = other.getCallProgress();
            if (this$callProgress == null ? other$callProgress != null : !((Object)this$callProgress).equals(other$callProgress)) {
                return false;
            }
            Integer this$notSupportVoisCount = this.getNotSupportVoisCount();
            Integer other$notSupportVoisCount = other.getNotSupportVoisCount();
            if (this$notSupportVoisCount == null ? other$notSupportVoisCount != null : !((Object)this$notSupportVoisCount).equals(other$notSupportVoisCount)) {
                return false;
            }
            Integer this$startVoisCount = this.getStartVoisCount();
            Integer other$startVoisCount = other.getStartVoisCount();
            if (this$startVoisCount == null ? other$startVoisCount != null : !((Object)this$startVoisCount).equals(other$startVoisCount)) {
                return false;
            }
            Integer this$nobodyVoisCount = this.getNobodyVoisCount();
            Integer other$nobodyVoisCount = other.getNobodyVoisCount();
            if (this$nobodyVoisCount == null ? other$nobodyVoisCount != null : !((Object)this$nobodyVoisCount).equals(other$nobodyVoisCount)) {
                return false;
            }
            Integer this$notSendVoisCount = this.getNotSendVoisCount();
            Integer other$notSendVoisCount = other.getNotSendVoisCount();
            if (this$notSendVoisCount == null ? other$notSendVoisCount != null : !((Object)this$notSendVoisCount).equals(other$notSendVoisCount)) {
                return false;
            }
            Integer this$timeoutVoisCount = this.getTimeoutVoisCount();
            Integer other$timeoutVoisCount = other.getTimeoutVoisCount();
            if (this$timeoutVoisCount == null ? other$timeoutVoisCount != null : !((Object)this$timeoutVoisCount).equals(other$timeoutVoisCount)) {
                return false;
            }
            List<CallTaskRespDto> this$users = this.getUsers();
            List<CallTaskRespDto> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallTaskDetailStatisticRespDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $callTaskId = this.getCallTaskId();
            result = result * 59 + ($callTaskId == null ? 43 : ((Object)$callTaskId).hashCode());
            Integer $customerCount = this.getCustomerCount();
            result = result * 59 + ($customerCount == null ? 43 : ((Object)$customerCount).hashCode());
            Integer $calledSuccessCount = this.getCalledSuccessCount();
            result = result * 59 + ($calledSuccessCount == null ? 43 : ((Object)$calledSuccessCount).hashCode());
            Integer $calledCount = this.getCalledCount();
            result = result * 59 + ($calledCount == null ? 43 : ((Object)$calledCount).hashCode());
            Double $callProgress = this.getCallProgress();
            result = result * 59 + ($callProgress == null ? 43 : ((Object)$callProgress).hashCode());
            Integer $notSupportVoisCount = this.getNotSupportVoisCount();
            result = result * 59 + ($notSupportVoisCount == null ? 43 : ((Object)$notSupportVoisCount).hashCode());
            Integer $startVoisCount = this.getStartVoisCount();
            result = result * 59 + ($startVoisCount == null ? 43 : ((Object)$startVoisCount).hashCode());
            Integer $nobodyVoisCount = this.getNobodyVoisCount();
            result = result * 59 + ($nobodyVoisCount == null ? 43 : ((Object)$nobodyVoisCount).hashCode());
            Integer $notSendVoisCount = this.getNotSendVoisCount();
            result = result * 59 + ($notSendVoisCount == null ? 43 : ((Object)$notSendVoisCount).hashCode());
            Integer $timeoutVoisCount = this.getTimeoutVoisCount();
            result = result * 59 + ($timeoutVoisCount == null ? 43 : ((Object)$timeoutVoisCount).hashCode());
            List<CallTaskRespDto> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        public String toString() {
            return "CallRecordReqDto.CallTaskDetailStatisticRespDto(callTaskId=" + this.getCallTaskId() + ", users=" + this.getUsers() + ", customerCount=" + this.getCustomerCount() + ", calledSuccessCount=" + this.getCalledSuccessCount() + ", calledCount=" + this.getCalledCount() + ", callProgress=" + this.getCallProgress() + ", notSupportVoisCount=" + this.getNotSupportVoisCount() + ", startVoisCount=" + this.getStartVoisCount() + ", nobodyVoisCount=" + this.getNobodyVoisCount() + ", notSendVoisCount=" + this.getNotSendVoisCount() + ", timeoutVoisCount=" + this.getTimeoutVoisCount() + ")";
        }

        public static class CallTaskDetailStatisticRespDtoBuilder {
            private Long callTaskId;
            private List<CallTaskRespDto> users;
            private Integer customerCount;
            private Integer calledSuccessCount;
            private Integer calledCount;
            private Double callProgress;
            private Integer notSupportVoisCount;
            private Integer startVoisCount;
            private Integer nobodyVoisCount;
            private Integer notSendVoisCount;
            private Integer timeoutVoisCount;

            CallTaskDetailStatisticRespDtoBuilder() {
            }

            public CallTaskDetailStatisticRespDtoBuilder callTaskId(Long callTaskId) {
                this.callTaskId = callTaskId;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder users(List<CallTaskRespDto> users) {
                this.users = users;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder customerCount(Integer customerCount) {
                this.customerCount = customerCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder calledSuccessCount(Integer calledSuccessCount) {
                this.calledSuccessCount = calledSuccessCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder calledCount(Integer calledCount) {
                this.calledCount = calledCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder callProgress(Double callProgress) {
                this.callProgress = callProgress;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder notSupportVoisCount(Integer notSupportVoisCount) {
                this.notSupportVoisCount = notSupportVoisCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder startVoisCount(Integer startVoisCount) {
                this.startVoisCount = startVoisCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder nobodyVoisCount(Integer nobodyVoisCount) {
                this.nobodyVoisCount = nobodyVoisCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder notSendVoisCount(Integer notSendVoisCount) {
                this.notSendVoisCount = notSendVoisCount;
                return this;
            }

            public CallTaskDetailStatisticRespDtoBuilder timeoutVoisCount(Integer timeoutVoisCount) {
                this.timeoutVoisCount = timeoutVoisCount;
                return this;
            }

            public CallTaskDetailStatisticRespDto build() {
                return new CallTaskDetailStatisticRespDto(this.callTaskId, this.users, this.customerCount, this.calledSuccessCount, this.calledCount, this.callProgress, this.notSupportVoisCount, this.startVoisCount, this.nobodyVoisCount, this.notSendVoisCount, this.timeoutVoisCount);
            }

            public String toString() {
                return "CallRecordReqDto.CallTaskDetailStatisticRespDto.CallTaskDetailStatisticRespDtoBuilder(callTaskId=" + this.callTaskId + ", users=" + this.users + ", customerCount=" + this.customerCount + ", calledSuccessCount=" + this.calledSuccessCount + ", calledCount=" + this.calledCount + ", callProgress=" + this.callProgress + ", notSupportVoisCount=" + this.notSupportVoisCount + ", startVoisCount=" + this.startVoisCount + ", nobodyVoisCount=" + this.nobodyVoisCount + ", notSendVoisCount=" + this.notSendVoisCount + ", timeoutVoisCount=" + this.timeoutVoisCount + ")";
            }
        }
    }

    public static class CallStatisticRespDto {
        private String x;
        private Integer successCount = 0;
        private Integer emptyCount = 0;
        private Integer downCount = 0;
        private Integer busyCount = 0;
        private Integer nobodyCount = 0;
        private Integer hangCount = 0;
        private Integer closeCount = 0;
        private Integer notSupportCount = 0;
        private Integer callDuration = 0;
        private Integer billCallDuration = 0;

        public static CallStatisticRespDto from(CallStatistic callStatistic, Integer mode) {
            String x = 1 == mode ? callStatistic.getDate() : (2 == mode ? callStatistic.getUserName() : "");
            return CallStatisticRespDto.builder().x(x).successCount(callStatistic.getSuccessCount()).callDuration(callStatistic.getCallDuration()).billCallDuration(callStatistic.getBillCallDuration()).emptyCount(callStatistic.getEmptyCount()).downCount(callStatistic.getDownCount()).busyCount(callStatistic.getBusyCount()).nobodyCount(callStatistic.getNobodyCount()).hangCount(callStatistic.getHangCount()).closeCount(callStatistic.getCloseCount()).notSupportCount(callStatistic.getNotSupportCount()).build();
        }

        public CallStatisticRespDto() {
        }

        CallStatisticRespDto(String x, Integer successCount, Integer emptyCount, Integer downCount, Integer busyCount, Integer nobodyCount, Integer hangCount, Integer closeCount, Integer notSupportCount, Integer callDuration, Integer billCallDuration) {
            this.x = x;
            this.successCount = successCount;
            this.emptyCount = emptyCount;
            this.downCount = downCount;
            this.busyCount = busyCount;
            this.nobodyCount = nobodyCount;
            this.hangCount = hangCount;
            this.closeCount = closeCount;
            this.notSupportCount = notSupportCount;
            this.callDuration = callDuration;
            this.billCallDuration = billCallDuration;
        }

        public static CallStatisticRespDtoBuilder builder() {
            return new CallStatisticRespDtoBuilder();
        }

        public String getX() {
            return this.x;
        }

        public Integer getSuccessCount() {
            return this.successCount;
        }

        public Integer getEmptyCount() {
            return this.emptyCount;
        }

        public Integer getDownCount() {
            return this.downCount;
        }

        public Integer getBusyCount() {
            return this.busyCount;
        }

        public Integer getNobodyCount() {
            return this.nobodyCount;
        }

        public Integer getHangCount() {
            return this.hangCount;
        }

        public Integer getCloseCount() {
            return this.closeCount;
        }

        public Integer getNotSupportCount() {
            return this.notSupportCount;
        }

        public Integer getCallDuration() {
            return this.callDuration;
        }

        public Integer getBillCallDuration() {
            return this.billCallDuration;
        }

        public void setX(String x) {
            this.x = x;
        }

        public void setSuccessCount(Integer successCount) {
            this.successCount = successCount;
        }

        public void setEmptyCount(Integer emptyCount) {
            this.emptyCount = emptyCount;
        }

        public void setDownCount(Integer downCount) {
            this.downCount = downCount;
        }

        public void setBusyCount(Integer busyCount) {
            this.busyCount = busyCount;
        }

        public void setNobodyCount(Integer nobodyCount) {
            this.nobodyCount = nobodyCount;
        }

        public void setHangCount(Integer hangCount) {
            this.hangCount = hangCount;
        }

        public void setCloseCount(Integer closeCount) {
            this.closeCount = closeCount;
        }

        public void setNotSupportCount(Integer notSupportCount) {
            this.notSupportCount = notSupportCount;
        }

        public void setCallDuration(Integer callDuration) {
            this.callDuration = callDuration;
        }

        public void setBillCallDuration(Integer billCallDuration) {
            this.billCallDuration = billCallDuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallStatisticRespDto)) {
                return false;
            }
            CallStatisticRespDto other = (CallStatisticRespDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$successCount = this.getSuccessCount();
            Integer other$successCount = other.getSuccessCount();
            if (this$successCount == null ? other$successCount != null : !((Object)this$successCount).equals(other$successCount)) {
                return false;
            }
            Integer this$emptyCount = this.getEmptyCount();
            Integer other$emptyCount = other.getEmptyCount();
            if (this$emptyCount == null ? other$emptyCount != null : !((Object)this$emptyCount).equals(other$emptyCount)) {
                return false;
            }
            Integer this$downCount = this.getDownCount();
            Integer other$downCount = other.getDownCount();
            if (this$downCount == null ? other$downCount != null : !((Object)this$downCount).equals(other$downCount)) {
                return false;
            }
            Integer this$busyCount = this.getBusyCount();
            Integer other$busyCount = other.getBusyCount();
            if (this$busyCount == null ? other$busyCount != null : !((Object)this$busyCount).equals(other$busyCount)) {
                return false;
            }
            Integer this$nobodyCount = this.getNobodyCount();
            Integer other$nobodyCount = other.getNobodyCount();
            if (this$nobodyCount == null ? other$nobodyCount != null : !((Object)this$nobodyCount).equals(other$nobodyCount)) {
                return false;
            }
            Integer this$hangCount = this.getHangCount();
            Integer other$hangCount = other.getHangCount();
            if (this$hangCount == null ? other$hangCount != null : !((Object)this$hangCount).equals(other$hangCount)) {
                return false;
            }
            Integer this$closeCount = this.getCloseCount();
            Integer other$closeCount = other.getCloseCount();
            if (this$closeCount == null ? other$closeCount != null : !((Object)this$closeCount).equals(other$closeCount)) {
                return false;
            }
            Integer this$notSupportCount = this.getNotSupportCount();
            Integer other$notSupportCount = other.getNotSupportCount();
            if (this$notSupportCount == null ? other$notSupportCount != null : !((Object)this$notSupportCount).equals(other$notSupportCount)) {
                return false;
            }
            Integer this$callDuration = this.getCallDuration();
            Integer other$callDuration = other.getCallDuration();
            if (this$callDuration == null ? other$callDuration != null : !((Object)this$callDuration).equals(other$callDuration)) {
                return false;
            }
            Integer this$billCallDuration = this.getBillCallDuration();
            Integer other$billCallDuration = other.getBillCallDuration();
            if (this$billCallDuration == null ? other$billCallDuration != null : !((Object)this$billCallDuration).equals(other$billCallDuration)) {
                return false;
            }
            String this$x = this.getX();
            String other$x = other.getX();
            return !(this$x == null ? other$x != null : !this$x.equals(other$x));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallStatisticRespDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $successCount = this.getSuccessCount();
            result = result * 59 + ($successCount == null ? 43 : ((Object)$successCount).hashCode());
            Integer $emptyCount = this.getEmptyCount();
            result = result * 59 + ($emptyCount == null ? 43 : ((Object)$emptyCount).hashCode());
            Integer $downCount = this.getDownCount();
            result = result * 59 + ($downCount == null ? 43 : ((Object)$downCount).hashCode());
            Integer $busyCount = this.getBusyCount();
            result = result * 59 + ($busyCount == null ? 43 : ((Object)$busyCount).hashCode());
            Integer $nobodyCount = this.getNobodyCount();
            result = result * 59 + ($nobodyCount == null ? 43 : ((Object)$nobodyCount).hashCode());
            Integer $hangCount = this.getHangCount();
            result = result * 59 + ($hangCount == null ? 43 : ((Object)$hangCount).hashCode());
            Integer $closeCount = this.getCloseCount();
            result = result * 59 + ($closeCount == null ? 43 : ((Object)$closeCount).hashCode());
            Integer $notSupportCount = this.getNotSupportCount();
            result = result * 59 + ($notSupportCount == null ? 43 : ((Object)$notSupportCount).hashCode());
            Integer $callDuration = this.getCallDuration();
            result = result * 59 + ($callDuration == null ? 43 : ((Object)$callDuration).hashCode());
            Integer $billCallDuration = this.getBillCallDuration();
            result = result * 59 + ($billCallDuration == null ? 43 : ((Object)$billCallDuration).hashCode());
            String $x = this.getX();
            result = result * 59 + ($x == null ? 43 : $x.hashCode());
            return result;
        }

        public String toString() {
            return "CallRecordReqDto.CallStatisticRespDto(x=" + this.getX() + ", successCount=" + this.getSuccessCount() + ", emptyCount=" + this.getEmptyCount() + ", downCount=" + this.getDownCount() + ", busyCount=" + this.getBusyCount() + ", nobodyCount=" + this.getNobodyCount() + ", hangCount=" + this.getHangCount() + ", closeCount=" + this.getCloseCount() + ", notSupportCount=" + this.getNotSupportCount() + ", callDuration=" + this.getCallDuration() + ", billCallDuration=" + this.getBillCallDuration() + ")";
        }

        public static class CallStatisticRespDtoBuilder {
            private String x;
            private Integer successCount;
            private Integer emptyCount;
            private Integer downCount;
            private Integer busyCount;
            private Integer nobodyCount;
            private Integer hangCount;
            private Integer closeCount;
            private Integer notSupportCount;
            private Integer callDuration;
            private Integer billCallDuration;

            CallStatisticRespDtoBuilder() {
            }

            public CallStatisticRespDtoBuilder x(String x) {
                this.x = x;
                return this;
            }

            public CallStatisticRespDtoBuilder successCount(Integer successCount) {
                this.successCount = successCount;
                return this;
            }

            public CallStatisticRespDtoBuilder emptyCount(Integer emptyCount) {
                this.emptyCount = emptyCount;
                return this;
            }

            public CallStatisticRespDtoBuilder downCount(Integer downCount) {
                this.downCount = downCount;
                return this;
            }

            public CallStatisticRespDtoBuilder busyCount(Integer busyCount) {
                this.busyCount = busyCount;
                return this;
            }

            public CallStatisticRespDtoBuilder nobodyCount(Integer nobodyCount) {
                this.nobodyCount = nobodyCount;
                return this;
            }

            public CallStatisticRespDtoBuilder hangCount(Integer hangCount) {
                this.hangCount = hangCount;
                return this;
            }

            public CallStatisticRespDtoBuilder closeCount(Integer closeCount) {
                this.closeCount = closeCount;
                return this;
            }

            public CallStatisticRespDtoBuilder notSupportCount(Integer notSupportCount) {
                this.notSupportCount = notSupportCount;
                return this;
            }

            public CallStatisticRespDtoBuilder callDuration(Integer callDuration) {
                this.callDuration = callDuration;
                return this;
            }

            public CallStatisticRespDtoBuilder billCallDuration(Integer billCallDuration) {
                this.billCallDuration = billCallDuration;
                return this;
            }

            public CallStatisticRespDto build() {
                return new CallStatisticRespDto(this.x, this.successCount, this.emptyCount, this.downCount, this.busyCount, this.nobodyCount, this.hangCount, this.closeCount, this.notSupportCount, this.callDuration, this.billCallDuration);
            }

            public String toString() {
                return "CallRecordReqDto.CallStatisticRespDto.CallStatisticRespDtoBuilder(x=" + this.x + ", successCount=" + this.successCount + ", emptyCount=" + this.emptyCount + ", downCount=" + this.downCount + ", busyCount=" + this.busyCount + ", nobodyCount=" + this.nobodyCount + ", hangCount=" + this.hangCount + ", closeCount=" + this.closeCount + ", notSupportCount=" + this.notSupportCount + ", callDuration=" + this.callDuration + ", billCallDuration=" + this.billCallDuration + ")";
            }
        }
    }
}

