/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.biz.service.impl;

import cn.kinyun.ad.common.req.AdConfigInitReq;
import cn.kinyun.ad.common.service.AdConfigInitService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.app.center.dto.req.AppBindReqDto;
import com.kuaike.scrm.app.center.dto.req.AppReviewReqDto;
import com.kuaike.scrm.app.center.service.AppCenterService;
import com.kuaike.scrm.biz.dto.request.BizEditReqDto;
import com.kuaike.scrm.biz.dto.request.BizReqDto;
import com.kuaike.scrm.biz.dto.request.BizUnableReqDto;
import com.kuaike.scrm.biz.dto.request.PartnerReqDto;
import com.kuaike.scrm.biz.dto.response.BizCustomerRespDto;
import com.kuaike.scrm.biz.dto.response.PartnerInfoRespDto;
import com.kuaike.scrm.biz.service.BizService;
import com.kuaike.scrm.bjy.sdk.service.BjyPartnerService;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.app.entity.App;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.app.mapper.AppMapper;
import com.kuaike.scrm.dal.biz.dto.BizListDto;
import com.kuaike.scrm.dal.biz.dto.BizModDto;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.sms.entity.PartnerInfo;
import com.kuaike.scrm.dal.sms.mapper.PartnerInfoMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.roc.dto.Staff;
import com.kuaike.scrm.roc.service.StaffService;
import com.kuaike.scrm.sms.dto.SmsConfig;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.dto.resp.CustomizedConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class BizServiceImpl
implements BizService {
    private static final Logger log = LoggerFactory.getLogger(BizServiceImpl.class);
    @Value(value="${scrm.biz.numCount}")
    private Integer numCount;
    @Value(value="${scrm.init.trade}")
    private String tradeUrl;
    @Value(value="${scrm.init.crm}")
    private String crmUrl;
    @Value(value="${permission.token}")
    private String token;
    @Value(value="${app.sms.appCode}")
    private String smsAppCode;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Value(value="${scrm.domain.scrm-manager}")
    private String domain;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}/clientHome?corpId=")
    private String homePageUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}/clientSide?corpId=")
    private String sidePageUrl;
    @Value(value="${scrm.callback.protocol}${scrm.domain.scrm-callback}/customized/")
    private String callbackUrl;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${aliyun.sms.scrm.signName}")
    private String signName;
    @Value(value="${aliyun.sms.verificationCode.templateCode.ad}")
    private String adTemplateCode;
    @Value(value="${app.account.isPhoneExistUrl}")
    private String isPhoneExistUrl;
    @Value(value="${app.sms.createAccountUrl}")
    private String createAccountUrl;
    @Value(value="${app.account.bindAccountUrl}")
    private String bindAccountUrl;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private StaffService staffService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private PackageMapper packageMapper;
    @Autowired
    private AppBindingsMapper appBindingsMapper;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private AppCenterService appCenterService;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private AdConfigInitService adConfigInitService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Autowired
    private PartnerInfoMapper partnerInfoMapper;
    @Autowired
    private IdGen idGen;
    private Random random = new Random();
    private static final String CODE_KEY = "SCRM_BJY_PARTNER_CODE_KEY_%s";
    private static final int CODE_CACHE_EXPIRE = 15;
    private static final int[] digit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    @Override
    public void updateStatusById(BizUnableReqDto reqDto) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("enable biz get staff AccountName: {}, name : {}", (Object)staff.getSAMAccountName(), (Object)staff.getName());
        reqDto.validate();
        log.info("\u66f4\u65b0\u5546\u6237\u72b6\u6001,status:{}, bizId:{}", (Object)reqDto.getStatus(), (Object)reqDto.getId());
        this.businessCustomerMapper.updateStatusById(reqDto.getStatus(), reqDto.getId());
    }

    @Override
    public List<BizCustomerRespDto> getBizList(BizReqDto reqDto) {
        BizListDto dto;
        List customerList;
        Staff staff = this.staffService.getRocLoginUserInfo();
        log.info("biz list get staff:{}", (Object)staff);
        reqDto.validate();
        String sortField = "";
        if (Objects.nonNull(reqDto.getSortField())) {
            if (reqDto.getSortField().equals("expireDate")) {
                sortField = "a.expire_date";
            }
            if (reqDto.getSortField().equals("createTime")) {
                sortField = "a.create_time";
            }
        }
        if (CollectionUtils.isEmpty((Collection)(customerList = this.businessCustomerMapper.getBizList(dto = new BizListDto(reqDto.getName(), reqDto.getStatus(), reqDto.getType(), reqDto.getSortMode(), sortField), reqDto.getPageDto())))) {
            log.warn("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)dto);
            return Collections.emptyList();
        }
        Integer count = this.businessCustomerMapper.getCountByBizList(dto);
        reqDto.getPageDto().setCount(count);
        List corpIds = customerList.stream().map(BusinessCustomer::getCorpId).collect(Collectors.toList());
        List appBindings = this.appBindingsMapper.queryAppListByCorps(corpIds);
        Map<Object, Object> appBindingMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)appBindings)) {
            appBindingMap = appBindings.stream().collect(Collectors.groupingBy(AppBindings::getCorpId));
        }
        List appList = this.appMapper.queryAllApp();
        Map<Long, String> appMaps = appList.stream().collect(Collectors.toMap(App::getId, App::getName));
        List tokens = this.corpCustomizedTokenMapper.getByCorpIds(corpIds, this.customizedId);
        Map<Object, Object> corpCustomizedTokenMap = Collections.emptyMap();
        if (CollectionUtils.isNotEmpty((Collection)tokens)) {
            corpCustomizedTokenMap = tokens.stream().collect(Collectors.toMap(CorpCustomizedToken::getCorpId, Function.identity()));
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (BusinessCustomer customer : customerList) {
            BizCustomerRespDto respDto = BizCustomerRespDto.getRespDto(customer);
            respDto.setNumCount(customer.getNumCount());
            respDto.setMoney(customer.getMoney());
            respDto.setConvCount(customer.getConvCount());
            respDto.setFollower(customer.getFollower());
            respDto.setAvatar(customer.getAvatar());
            List bindingsList = (List)appBindingMap.get(customer.getCorpId());
            if (CollectionUtils.isNotEmpty((Collection)bindingsList)) {
                List smsBingList = bindingsList.stream().filter(a -> a.getAppCode().equals(this.smsAppCode)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(smsBingList)) {
                    AppBindings smsBinds = smsBingList.stream().findFirst().orElse(null);
                    SmsConfig smsConfig = new SmsConfig();
                    if (!ObjectUtils.isEmpty((Object)smsBinds)) {
                        try {
                            log.info("getBizList getConfigJson : {}", (Object)smsBinds.getConfigJson());
                            if (StringUtils.isNotBlank((CharSequence)smsBinds.getConfigJson())) {
                                smsConfig = (SmsConfig)JacksonUtil.str2Obj((String)smsBinds.getConfigJson(), SmsConfig.class);
                            }
                        }
                        catch (IOException e) {
                            log.error("configJson to SmsConfig error", (Throwable)e);
                        }
                    }
                    respDto.setSmsPrice(smsConfig.getUnitPrice());
                    respDto.setSignature(smsConfig.getSignature());
                }
                List appIds = bindingsList.stream().map(AppBindings::getAppId).collect(Collectors.toList());
                ArrayList appNames = Lists.newArrayList();
                for (Long appId : appIds) {
                    String appName = appMaps.get(appId);
                    if (!StringUtils.isNotBlank((CharSequence)appName)) continue;
                    appNames.add(appName);
                }
                respDto.setAppNames(appNames);
            }
            CorpCustomizedToken token = (CorpCustomizedToken)corpCustomizedTokenMap.get(customer.getCorpId());
            respDto.setCustomizedConfig(this.getDevConfig(token));
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    private CustomizedConfig getDevConfig(CorpCustomizedToken record) {
        CustomizedConfig config = new CustomizedConfig();
        if (record == null) {
            config.setDevStatus(Integer.valueOf(-1));
            return config;
        }
        if (record.getIsAuth() == null || record.getIsAuth() == 0) {
            config.setDevStatus(Integer.valueOf(-1));
            return config;
        }
        config.setHomePageUrl(this.homePageUrl + record.getCorpId());
        config.setSidePageUrl(this.sidePageUrl + record.getCorpId());
        config.setDomain(this.domain);
        config.setCallbackUrl(this.callbackUrl + record.getNum());
        config.setToken(record.getToken());
        config.setAesKey(record.getAesKey());
        config.setDevStatus(record.getDevStatus());
        config.setAuthTime(record.getAuthTime());
        return config;
    }

    @Override
    public void editBiz(BizEditReqDto reqDto) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("mod biz get staff AccountName: {}, name : {}\uff0c reqDto:{} ", new Object[]{staff.getSAMAccountName(), staff.getName(), reqDto});
        reqDto.validate();
        BizModDto dto = new BizModDto();
        BeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[]{"pkgIds"});
        BusinessCustomer customer = this.businessCustomerMapper.queryInitPkgIds(reqDto.getId());
        String initPkgIds = customer.getInitPkgIds();
        List<Object> initPkgIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)initPkgIds)) {
            if (initPkgIds.contains(",")) {
                for (String s : initPkgIds.split(",")) {
                    Long parseLong = Long.parseLong(s);
                    initPkgIdList.add(parseLong);
                }
            } else {
                initPkgIdList.add(Long.parseLong(initPkgIds));
            }
        }
        log.info("editBiz get old initPkgIdList : {}", (Object)initPkgIdList);
        List<Object> addInitIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(reqDto.getPkgIds())) {
            String pkgIdS = Joiner.on((String)",").join(reqDto.getPkgIds());
            dto.setPkgIds(pkgIdS);
            if (CollectionUtils.isEmpty((Collection)initPkgIdList)) {
                initPkgIdList = reqDto.getPkgIds();
                addInitIds = reqDto.getPkgIds();
            } else {
                for (Long pid : reqDto.getPkgIds()) {
                    if (initPkgIdList.contains(pid)) continue;
                    addInitIds.add(pid);
                    initPkgIdList.add(pid);
                }
            }
            String initPkgIdStr = Joiner.on((String)",").join((Iterable)initPkgIdList);
            dto.setInitPkgIds(initPkgIdStr);
        }
        log.info("editBiz get new initPkgIdList : {}", (Object)initPkgIdList);
        log.info("editBiz  init PkgIdList : {}", (Object)addInitIds);
        if (CollectionUtils.isNotEmpty((Collection)addInitIds)) {
            this.initPackageList((List<Long>)addInitIds, customer.getId(), customer.getCorpId());
        }
        if (NumberUtils.INTEGER_ONE.equals(dto.getType()) && (Objects.isNull(dto.getNumCount()) || dto.getNumCount() <= 0)) {
            dto.setNumCount(this.numCount);
        }
        if (NumberUtils.INTEGER_TWO.equals(dto.getType()) && !customer.getType().equals(dto.getType())) {
            String adminUserId = this.weworkUserMapper.queryWeworkUserIdApplyId(customer.getId(), customer.getApplyWeworkUserId());
            log.info("editBiz: \u6e05\u9664\u5546\u6237\u5f00\u901a\u6807\u5fd7: bizId:{}, adminUserId:{}", (Object)customer.getId(), (Object)adminUserId);
            this.userMapper.clearOpenStatusByBizId(dto.getId(), adminUserId);
        }
        if (reqDto.getExpireDate().before(DateUtil.getDate())) {
            dto.setStatus(Integer.valueOf(3));
        } else {
            dto.setStatus(Integer.valueOf(1));
        }
        log.info("editBiz: expireTime before now: {}", (Object)reqDto.getExpireDate().before(DateUtil.getDate()));
        this.businessCustomerMapper.editBizCustomer(dto, staff.getSAMAccountName());
    }

    private void initPackageList(List<Long> pkgIds, Long bizId, String corpId) {
        if (CollectionUtils.isEmpty(pkgIds)) {
            return;
        }
        List systemIds = this.packageMapper.querySystemIds(pkgIds);
        log.info("initPackageList systemIds: {}", (Object)systemIds);
        for (Long id : systemIds) {
            log.info("initPackageList sid: {}", (Object)id);
            if (id.intValue() == SystemTypeEnum.TRADE.getValue()) {
                this.initTrade(bizId, corpId);
                continue;
            }
            if (id.intValue() == SystemTypeEnum.CRM.getValue()) {
                this.initCrm(bizId);
                continue;
            }
            if (id.intValue() != SystemTypeEnum.AD.getValue()) continue;
            this.initAd(bizId, corpId);
        }
    }

    private void initAd(Long bizId, String corpId) {
        AdConfigInitReq req = new AdConfigInitReq();
        req.setBizId(bizId);
        req.setCropId(corpId);
        this.adConfigInitService.adConfigInit(req);
    }

    private void initCrm(Long bizId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", bizId);
        params.put("token", this.token);
        String paramUrl = this.crmUrl;
        try {
            String resultJson = HttpClientUtils.doJsonPost((String)paramUrl, params, (String)StandardCharsets.UTF_8.toString());
            log.info("initPackageList url: {},  result : {}", (Object)paramUrl, (Object)resultJson);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521d\u59cb\u5316CRM\u8ba2\u5355\u7cfb\u7edf\u9519\u8bef :" + e);
        }
    }

    private void initTrade(Long bizId, String corpId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizId", bizId);
        params.put("corpId", corpId);
        params.put("token", this.token);
        String paramUrl = this.tradeUrl;
        try {
            String resultJson = HttpClientUtils.doJsonPost((String)paramUrl, params, (String)StandardCharsets.UTF_8.toString());
            log.info("initPackageList url: {},  result : {}", (Object)paramUrl, (Object)resultJson);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521d\u59cb\u5316\u5546\u54c1\u8ba2\u5355\u7cfb\u7edf\u9519\u8bef :" + e);
        }
    }

    @Override
    public void queryExpireBizStatus() {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("queryExpireBizStatus get staff AccountName: {}, name : {}", (Object)staff.getSAMAccountName(), (Object)staff.getName());
        List customerList = this.businessCustomerMapper.getExpireBizList(new Date());
        List bizIds = customerList.stream().map(BusinessCustomer::getId).collect(Collectors.toList());
        log.info("queryExpireBizStatus expire bizIds: {}", bizIds);
        if (bizIds.size() > 0) {
            int update = this.businessCustomerMapper.updateStatusByIds(bizIds, new Date(), staff.getSAMAccountName());
            log.info("queryExpireBizStatus update: {}", (Object)update);
        }
    }

    @Override
    public void appBinding(AppBindReqDto reqDto) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("queryExpireBizStatus get staff AccountName: {}, name : {}", (Object)staff.getSAMAccountName(), (Object)staff.getName());
        this.appCenterService.appBinding(reqDto, staff.getName());
    }

    @Override
    public void appReview(AppReviewReqDto reqDto) {
        Staff staff = this.staffService.getRocLoginUserInfo();
        if (Objects.isNull(staff)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u767b\u5f55\u8d85\u65f6, \u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u767b\u5f55");
        }
        log.info("queryExpireBizStatus get staff AccountName: {}, name : {}", (Object)staff.getSAMAccountName(), (Object)staff.getName());
        this.appCenterService.appReview(reqDto, staff.getName());
    }

    @Override
    public void enableCustomizedApp(IdDto req) {
        log.info("enable customized app, id={}", (Object)req);
        Preconditions.checkArgument((req != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((req.getId() != null ? 1 : 0) != 0, (Object)"id is null");
        CorpCustomizedToken record = this.corpCustomizedTokenMapper.getByBizId(req.getId(), this.customizedId);
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        Preconditions.checkArgument((record.getIsAuth() != null && record.getIsAuth() == 1 ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u672a\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528");
        if (record.getDevStatus() != 2) {
            record.setDevStatus(Integer.valueOf(2));
            record.setUpdateTime(new Date());
            this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)record);
            log.info("enable corp customized token, corpId={}", (Object)record.getCorpId());
        }
        Long bizId = record.getBizId();
        String corpId = record.getCorpId();
        this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_TAG, Long.valueOf(-1L));
        this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_CHAT, Long.valueOf(-1L));
        this.syncTaskService.start(bizId, corpId, SyncTaskType.EXTERNAL_CONTACT, Long.valueOf(-1L));
    }

    @Override
    public PartnerInfoRespDto partnerInfo(PartnerReqDto reqDto) {
        PartnerInfo partner;
        log.info("partnerInfo reqDto:{}", (Object)reqDto);
        Long bizId = reqDto.getBizId();
        if (!ObjectUtils.isEmpty((Object)bizId) && (partner = this.bjyPartnerService.getPartner(bizId)) != null) {
            PartnerInfoRespDto respDto = PartnerInfoRespDto.getRespDto(partner);
            respDto.setExist(1);
            respDto.setBind(1);
            return respDto;
        }
        String phone = reqDto.getPhone();
        if (StringUtils.isBlank((CharSequence)phone)) {
            return new PartnerInfoRespDto();
        }
        Map<String, String> params = this.getParams(phone);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(this.isPhoneExistUrl, params, (Map)Maps.newHashMap());
        Integer exist = jsonObject.getJSONObject("data").getInteger("exist");
        Integer bind = jsonObject.getJSONObject("data").getInteger("bind");
        String mobile = jsonObject.getJSONObject("data").getString("phone");
        PartnerInfoRespDto partnerInfoRespDto = new PartnerInfoRespDto();
        partnerInfoRespDto.setExist(exist);
        partnerInfoRespDto.setBind(bind);
        partnerInfoRespDto.setMobile(mobile);
        return partnerInfoRespDto;
    }

    @Override
    public PartnerInfoRespDto bindAccount(PartnerReqDto reqDto) {
        log.info("bindAccount reqDto:{}", (Object)reqDto);
        reqDto.validate();
        PartnerInfo partner = this.bjyPartnerService.getPartner(reqDto.getBizId());
        if (partner != null) {
            PartnerInfoRespDto respDto = PartnerInfoRespDto.getRespDto(partner);
            respDto.setExist(1);
            respDto.setBind(1);
            return respDto;
        }
        Map<String, String> params = this.getBindAccountParam(reqDto.getCorpId(), reqDto.getName(), reqDto.getPhone());
        JSONObject account = this.bjyPartnerService.bjyPost(this.bindAccountUrl, params, (Map)Maps.newHashMap()).getJSONObject("data");
        PartnerInfo partnerInfo = PartnerInfo.builder().bizId(reqDto.getBizId()).corpId(reqDto.getCorpId()).num(this.idGen.getNum()).partnerId(account.getString("partner_id")).partnerKey(account.getString("partner_key")).secretKey(account.getString("secret_key")).email(account.getString("email")).mobile(account.getString("mobile")).partnerName(account.getString("partner_name")).url(account.getString("private_domain_url")).updateTime(new Date()).createTime(new Date()).createBy(Long.valueOf(-1L)).updateBy(Long.valueOf(-1L)).build();
        this.partnerInfoMapper.insert((Object)partnerInfo);
        return PartnerInfoRespDto.getRespDto(partnerInfo);
    }

    private String getVerifyCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int j = this.random.nextInt(10);
            if (i == 0 && j == 0) {
                j = 1;
            }
            stringBuilder.append(digit[j]);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> getParams(String phone) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        return result;
    }

    private Map<String, String> getCreateAccountParam(String corpId, String corpName, String phone, String password) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("corp_id", corpId);
        result.put("corp_name", corpName);
        result.put("phone", phone);
        result.put("password", password);
        return result;
    }

    private Map<String, String> getBindAccountParam(String corpId, String corpName, String phone) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("corp_id", corpId);
        result.put("corp_name", corpName);
        result.put("phone", phone);
        return result;
    }
}

