/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.approval.dto;

import cn.kinyun.wework.sdk.api.req.Content;
import cn.kinyun.wework.sdk.entity.oa.Control;
import cn.kinyun.wework.sdk.entity.oa.TemplateDetailResp;
import cn.kinyun.wework.sdk.entity.oa.TemplateProperty;
import cn.kinyun.wework.sdk.entity.oa.TextLang;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.YnEnum;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StartApprovalReqWrapper
implements Serializable {
    private Long bizId;
    private String templateId;
    private String creatorUserId;
    private Set<String> nodeApprover;
    private List<String> notifyer;
    private List<Content> contents;
    private String formTemplate;

    public void setAndValidate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.templateId), (Object)"\u6d41\u7a0b\u6a21\u677fid \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.formTemplate), (Object)"\u6d41\u7a0b\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.creatorUserId), (Object)"\u6d41\u7a0b\u521b\u5efa\u8005\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.nodeApprover), (Object)"\u6d41\u7a0b\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contents), (Object)"\u5ba1\u6279\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        TemplateDetailResp detailResp = (TemplateDetailResp)JSON.parseObject((String)this.formTemplate, TemplateDetailResp.class);
        Preconditions.checkArgument((boolean)Objects.nonNull(detailResp), (Object)"\u6d41\u7a0b\u6a21\u677f\u4fe1\u606f\u89e3\u6790\u9519\u8bef");
        List controls = detailResp.getTemplateContent().getControls();
        Map flowValueMap = this.contents.stream().collect(Collectors.toMap(Content::getName, Function.identity()));
        for (Control control : controls) {
            TemplateProperty property = control.getProperty();
            String text = ((TextLang)property.getTitle().get(0)).getText();
            Content content = (Content)flowValueMap.get(text);
            if (YnEnum.YES.getValue().equals(property.getRequire())) {
                Preconditions.checkArgument((boolean)Objects.nonNull(content), (Object)(text + "\u4e3a\u5fc5\u586b\u5b57\u6bb5,\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if (!Objects.nonNull(content)) continue;
            content.setControl(property.getControl());
            content.setRequire(property.getRequire());
            content.setId(property.getId());
            content.validate();
        }
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public Set<String> getNodeApprover() {
        return this.nodeApprover;
    }

    public List<String> getNotifyer() {
        return this.notifyer;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public String getFormTemplate() {
        return this.formTemplate;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public void setNodeApprover(Set<String> nodeApprover) {
        this.nodeApprover = nodeApprover;
    }

    public void setNotifyer(List<String> notifyer) {
        this.notifyer = notifyer;
    }

    public void setContents(List<Content> contents) {
        this.contents = contents;
    }

    public void setFormTemplate(String formTemplate) {
        this.formTemplate = formTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartApprovalReqWrapper)) {
            return false;
        }
        StartApprovalReqWrapper other = (StartApprovalReqWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$creatorUserId = this.getCreatorUserId();
        String other$creatorUserId = other.getCreatorUserId();
        if (this$creatorUserId == null ? other$creatorUserId != null : !this$creatorUserId.equals(other$creatorUserId)) {
            return false;
        }
        Set<String> this$nodeApprover = this.getNodeApprover();
        Set<String> other$nodeApprover = other.getNodeApprover();
        if (this$nodeApprover == null ? other$nodeApprover != null : !((Object)this$nodeApprover).equals(other$nodeApprover)) {
            return false;
        }
        List<String> this$notifyer = this.getNotifyer();
        List<String> other$notifyer = other.getNotifyer();
        if (this$notifyer == null ? other$notifyer != null : !((Object)this$notifyer).equals(other$notifyer)) {
            return false;
        }
        List<Content> this$contents = this.getContents();
        List<Content> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        String this$formTemplate = this.getFormTemplate();
        String other$formTemplate = other.getFormTemplate();
        return !(this$formTemplate == null ? other$formTemplate != null : !this$formTemplate.equals(other$formTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StartApprovalReqWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $creatorUserId = this.getCreatorUserId();
        result = result * 59 + ($creatorUserId == null ? 43 : $creatorUserId.hashCode());
        Set<String> $nodeApprover = this.getNodeApprover();
        result = result * 59 + ($nodeApprover == null ? 43 : ((Object)$nodeApprover).hashCode());
        List<String> $notifyer = this.getNotifyer();
        result = result * 59 + ($notifyer == null ? 43 : ((Object)$notifyer).hashCode());
        List<Content> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        String $formTemplate = this.getFormTemplate();
        result = result * 59 + ($formTemplate == null ? 43 : $formTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "StartApprovalReqWrapper(bizId=" + this.getBizId() + ", templateId=" + this.getTemplateId() + ", creatorUserId=" + this.getCreatorUserId() + ", nodeApprover=" + this.getNodeApprover() + ", notifyer=" + this.getNotifyer() + ", contents=" + this.getContents() + ", formTemplate=" + this.getFormTemplate() + ")";
    }
}

