/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.material.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.enums.QrcodeConfigEnum;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChannelStaffDto {
    private List<String> channelIds;
    private Set<String> userIds;
    private Set<String> partTimeJobPerson;
    private String deptId;
    private String allocRuleId;

    public void validateParams(Integer qrcodeConfig) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.channelIds), (Object)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(this.partTimeJobPerson)) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.deptId), (Object)"\u517c\u804c\u96b6\u5c5e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            this.deptId = "";
        }
        if (QrcodeConfigEnum.ALLOC_RULE.getValue() == qrcodeConfig.intValue()) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.allocRuleId), (Object)"\u5206\u914d\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isBlank((CharSequence)this.allocRuleId), (Object)"\u8be5\u8d44\u6599\u65e0\u9700\u9009\u62e9\u5206\u914d\u89c4\u5219");
        }
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public Set<String> getUserIds() {
        return this.userIds;
    }

    public Set<String> getPartTimeJobPerson() {
        return this.partTimeJobPerson;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getAllocRuleId() {
        return this.allocRuleId;
    }

    public void setChannelIds(List<String> channelIds) {
        this.channelIds = channelIds;
    }

    public void setUserIds(Set<String> userIds) {
        this.userIds = userIds;
    }

    public void setPartTimeJobPerson(Set<String> partTimeJobPerson) {
        this.partTimeJobPerson = partTimeJobPerson;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public void setAllocRuleId(String allocRuleId) {
        this.allocRuleId = allocRuleId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelStaffDto)) {
            return false;
        }
        ChannelStaffDto other = (ChannelStaffDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$channelIds = this.getChannelIds();
        List<String> other$channelIds = other.getChannelIds();
        if (this$channelIds == null ? other$channelIds != null : !((Object)this$channelIds).equals(other$channelIds)) {
            return false;
        }
        Set<String> this$userIds = this.getUserIds();
        Set<String> other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
            return false;
        }
        Set<String> this$partTimeJobPerson = this.getPartTimeJobPerson();
        Set<String> other$partTimeJobPerson = other.getPartTimeJobPerson();
        if (this$partTimeJobPerson == null ? other$partTimeJobPerson != null : !((Object)this$partTimeJobPerson).equals(other$partTimeJobPerson)) {
            return false;
        }
        String this$deptId = this.getDeptId();
        String other$deptId = other.getDeptId();
        if (this$deptId == null ? other$deptId != null : !this$deptId.equals(other$deptId)) {
            return false;
        }
        String this$allocRuleId = this.getAllocRuleId();
        String other$allocRuleId = other.getAllocRuleId();
        return !(this$allocRuleId == null ? other$allocRuleId != null : !this$allocRuleId.equals(other$allocRuleId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelStaffDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $channelIds = this.getChannelIds();
        result = result * 59 + ($channelIds == null ? 43 : ((Object)$channelIds).hashCode());
        Set<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        Set<String> $partTimeJobPerson = this.getPartTimeJobPerson();
        result = result * 59 + ($partTimeJobPerson == null ? 43 : ((Object)$partTimeJobPerson).hashCode());
        String $deptId = this.getDeptId();
        result = result * 59 + ($deptId == null ? 43 : $deptId.hashCode());
        String $allocRuleId = this.getAllocRuleId();
        result = result * 59 + ($allocRuleId == null ? 43 : $allocRuleId.hashCode());
        return result;
    }

    public String toString() {
        return "ChannelStaffDto(channelIds=" + this.getChannelIds() + ", userIds=" + this.getUserIds() + ", partTimeJobPerson=" + this.getPartTimeJobPerson() + ", deptId=" + this.getDeptId() + ", allocRuleId=" + this.getAllocRuleId() + ")";
    }
}

