/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletAPI;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.JsCode2SessionReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletSessionResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.GetUserPhoneResp;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.dto.setting.CategoryDto;
import com.kuaike.scrm.applet.dto.req.AuthPhoneReportReq;
import com.kuaike.scrm.applet.dto.req.MaterialDetailReq;
import com.kuaike.scrm.applet.dto.req.MaterialListReq;
import com.kuaike.scrm.applet.dto.req.MaterialListSearchReq;
import com.kuaike.scrm.applet.dto.req.MaterialQueryBaseReq;
import com.kuaike.scrm.applet.dto.req.MaterialScanHistoryReq;
import com.kuaike.scrm.applet.dto.req.MaterialScanReportReq;
import com.kuaike.scrm.applet.dto.req.OpenAppletReportReq;
import com.kuaike.scrm.applet.dto.req.QueryBaseReq;
import com.kuaike.scrm.applet.dto.req.QueryConfigReq;
import com.kuaike.scrm.applet.dto.req.SettingConfigReq;
import com.kuaike.scrm.applet.dto.req.setting.AddCategoryReq;
import com.kuaike.scrm.applet.dto.req.setting.DelAreaReq;
import com.kuaike.scrm.applet.dto.req.setting.DelCategoryReq;
import com.kuaike.scrm.applet.dto.req.setting.ModAreaReq;
import com.kuaike.scrm.applet.dto.req.setting.ModCategoryReq;
import com.kuaike.scrm.applet.dto.req.setting.ModFirstCategorySortReq;
import com.kuaike.scrm.applet.dto.req.setting.ViewSettingReq;
import com.kuaike.scrm.applet.dto.resp.AppletUserResp;
import com.kuaike.scrm.applet.dto.resp.AreaResp;
import com.kuaike.scrm.applet.dto.resp.CategoryChildResp;
import com.kuaike.scrm.applet.dto.resp.CategoryResp;
import com.kuaike.scrm.applet.dto.resp.ConfigResp;
import com.kuaike.scrm.applet.dto.resp.MaterialConfigResp;
import com.kuaike.scrm.applet.dto.resp.MaterialDetailResp;
import com.kuaike.scrm.applet.dto.resp.MaterialFileResp;
import com.kuaike.scrm.applet.dto.resp.MaterialScanHistoryResp;
import com.kuaike.scrm.applet.dto.resp.auth.AuthPhoneReportResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletMeetingService;
import com.kuaike.scrm.applet.service.AppletService;
import com.kuaike.scrm.applet.service.AppletSettingService;
import com.kuaike.scrm.applet.service.MaterialAppletService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.applet.AppletLevelConfigTypeEnum;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.dal.applet.dto.AppletMaterialListQuery;
import com.kuaike.scrm.dal.applet.dto.HistoryRecordResp;
import com.kuaike.scrm.dal.applet.dto.UpdateLevelConfigSortDto;
import com.kuaike.scrm.dal.applet.entity.AppletConfig;
import com.kuaike.scrm.dal.applet.entity.AppletContactInfo;
import com.kuaike.scrm.dal.applet.entity.AppletLevelConfig;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterial;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialFile;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialGroup;
import com.kuaike.scrm.dal.applet.entity.AppletMarketingMaterialUserInfo;
import com.kuaike.scrm.dal.applet.entity.AppletUserHistoryRecord;
import com.kuaike.scrm.dal.applet.mapper.AppletConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletContactInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletLevelConfigMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialFileMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialGroupMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletMarketingMaterialUserInfoMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletUserHistoryRecordMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.enums.AppletConfigTypeEnum;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.enums.GroupConfigEnum;
import com.kuaike.scrm.material.service.MarketingMaterialService;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppletSettingServiceImpl
implements AppletSettingService {
    private static final Logger log = LoggerFactory.getLogger(AppletSettingServiceImpl.class);
    @Resource
    private AppletConfigMapper configMapper;
    @Resource
    private AppletInfoMapper infoMapper;
    @Resource
    private AppletLevelConfigMapper levelConfigMapper;
    @Resource
    private AppletMarketingMaterialMapper materialMapper;
    @Resource
    private AppletMarketingMaterialGroupMapper materialGroupMapper;
    @Resource
    private AppletMarketingMaterialFileMapper materialFileMapper;
    @Resource
    private AppletMarketingMaterialUserInfoMapper materialUserInfoMapper;
    @Resource
    private AppletContactInfoMapper contactInfoMapper;
    @Resource
    private AppletUserHistoryRecordMapper historyRecordMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private MaterialAppletService materialAppletService;
    @Resource
    private AppletMeetingService appletMeetingService;
    @Autowired
    private IdGen idGen;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Value(value="${scrm.applet.viewSetting.default}")
    private String viewSettingDefault;
    @Value(value="${scrm.applet.qrcodeDisplay.default}")
    private String qrcodeDisplayDefault;
    @Value(value="${scrm.applet.marketingMaterialList.default}")
    private String marketingMaterialList;
    @Value(value="${scrm.applet.marketingMaterialDetail.default}")
    private String marketingMaterialDetail;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private AppletAPI appletAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private MarketingMaterialService marketingMaterialService;
    @Resource
    private AppletService appletService;
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Resource
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Resource
    private ExternalContactClient externalContactClient;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService appletSettingThreadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10), (ThreadFactory)new NamedThreadFactory("appletSettingThreadPool"), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void setAppletConfig(SettingConfigReq req) {
        CurrentUserInfo info = LoginUtils.getCurrentUser();
        log.info("setAppletConfig req: {}, bizId: {}", (Object)req, (Object)info.getBizId());
        req.validate();
        AppletConfig config = this.configMapper.queryConfig(info.getBizId(), req.getType());
        if (config == null) {
            config = new AppletConfig();
            config.setNum(this.idGen.getNum());
            config.setBizId(info.getBizId());
            config.setType(req.getType());
            config.setContent(req.getData());
            config.setCreateTime(new Date());
            config.setUpdateTime(new Date());
            config.setCreateBy(info.getId());
            config.setUpdateBy(info.getId());
            config.setIsDeleted(Integer.valueOf(0));
            this.configMapper.insertSelective((Object)config);
        } else {
            this.configMapper.updateConfigContent(info.getBizId(), req.getType(), req.getData());
        }
    }

    @Override
    public ConfigResp getAppletConfig(QueryConfigReq req) {
        Long bizId = null;
        if (req.getAppId() == null) {
            CurrentUserInfo info = LoginUtils.getCurrentUser();
            bizId = info.getBizId();
        } else {
            AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
            if (appletInfo != null) {
                bizId = appletInfo.getBizId();
            }
        }
        log.info("setAppletConfig req: {}, bizId: {}", (Object)req, (Object)bizId);
        Preconditions.checkArgument((req.getType() != null ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        ConfigResp resp = new ConfigResp();
        AppletConfig config = this.configMapper.queryConfig(bizId, req.getType());
        if (config == null) {
            String content = "";
            switch (AppletConfigTypeEnum.get(req.getType())) {
                case VIEW_SETTING: {
                    content = this.viewSettingDefault;
                    break;
                }
                case QRCODE_DISPLAY_RULE: {
                    content = this.qrcodeDisplayDefault;
                    break;
                }
            }
            resp.setType(req.getType());
            resp.setData(content);
        } else {
            resp.setType(config.getType());
            resp.setData(config.getContent());
        }
        return resp;
    }

    @Override
    public List<CategoryResp> getCategoryList(QueryBaseReq req) {
        Long bizId = null;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (user == null) {
            String appId = req.getAppId();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
            AppletInfo appletInfo = this.infoMapper.getByAppId(appId);
            if (appletInfo != null) {
                bizId = appletInfo.getBizId();
            }
            Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        } else {
            bizId = user.getBizId();
        }
        log.info("getCategoryList getBizId: {}", (Object)bizId);
        List configList = this.levelConfigMapper.queryLevelConfigBy(bizId, Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()));
        if (CollectionUtils.isEmpty((Collection)configList)) {
            log.info("getCategoryList get configList is empty, bizId: {}", (Object)bizId);
            return null;
        }
        List firstConfig = configList.stream().filter(a -> "0".equals(a.getpNum())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(firstConfig)) {
            log.info("getCategoryList get firstConfig is empty, \u67e5\u8be2\u7684\u4e00\u7ea7\u5206\u7c7b\u4e3a\u7a7a, bizId: {}", (Object)bizId);
            return null;
        }
        String content = this.viewSettingDefault;
        AppletConfig appletConfig = this.configMapper.queryConfig(bizId, Integer.valueOf(AppletConfigTypeEnum.VIEW_SETTING.getType()));
        if (appletConfig != null) {
            content = appletConfig.getContent();
        }
        ViewSettingReq settingReq = (ViewSettingReq)JSONObject.parseObject((String)content, ViewSettingReq.class);
        log.info("getCategoryList category level : {}", (Object)settingReq.getCategory().getLevel());
        ArrayList respList = Lists.newArrayList();
        for (AppletLevelConfig config : firstConfig) {
            CategoryResp resp = new CategoryResp();
            resp.setCategoryId(config.getNum());
            resp.setCategoryName(config.getName());
            resp.setLevel(1);
            List secondConfig = configList.stream().filter(a -> a.getpNum().equals(config.getNum())).collect(Collectors.toList());
            ArrayList childRespList = Lists.newArrayList();
            if (user == null && settingReq.getCategory() != null && settingReq.getCategory().getLevel() == 2) {
                CategoryChildResp allCate = new CategoryChildResp();
                allCate.setCategoryId("0");
                allCate.setCategoryName("\u5168\u90e8");
                allCate.setLevel(2);
                allCate.setPCategoryId(config.getNum());
                childRespList.add(allCate);
            }
            if (!CollectionUtils.isEmpty(secondConfig) && settingReq.getCategory() != null && settingReq.getCategory().getLevel() == 2) {
                for (AppletLevelConfig sConfig : secondConfig) {
                    CategoryChildResp sResp = new CategoryChildResp();
                    sResp.setCategoryId(sConfig.getNum());
                    sResp.setCategoryName(sConfig.getName());
                    sResp.setLevel(2);
                    sResp.setPCategoryId(config.getNum());
                    childRespList.add(sResp);
                }
            }
            resp.setChildren(childRespList);
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public List<AreaResp> getAreaList(QueryBaseReq req) {
        Long bizId = null;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (user == null) {
            String appId = req.getAppId();
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
            AppletInfo appletInfo = this.infoMapper.getByAppId(appId);
            if (appletInfo != null) {
                bizId = appletInfo.getBizId();
            }
            Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        } else {
            bizId = user.getBizId();
        }
        log.info("getAreaList getBizId: {}, param: {}", (Object)bizId, (Object)req);
        List configList = this.levelConfigMapper.queryLevelConfigBy(bizId, Integer.valueOf(AppletLevelConfigTypeEnum.AREA.getType()));
        if (CollectionUtils.isEmpty((Collection)configList)) {
            log.info("getCategoryList get configList is empty, bizId: {}", (Object)bizId);
            return null;
        }
        Map firstAreaMap = configList.stream().filter(x -> "0".equals(x.getpNum())).collect(Collectors.toMap(AppletLevelConfig::getNum, Function.identity()));
        ArrayList respList = Lists.newArrayList();
        for (AppletLevelConfig config : configList) {
            AreaResp resp = new AreaResp();
            resp.setAreaId(config.getNum());
            resp.setLevel(config.getLevel());
            resp.setLabel(config.getName());
            resp.setValue(config.getValue());
            AppletLevelConfig appletLevelConfig = (AppletLevelConfig)firstAreaMap.get(config.getpNum());
            if (appletLevelConfig != null) {
                resp.setPAreaId(appletLevelConfig.getNum());
            }
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public MaterialConfigResp getMaterialConfig(MaterialQueryBaseReq req) {
        Long bizId = null;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getAppId()), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("getAreaList getBizId: {}, param: {}", (Object)bizId, (Object)req);
        AppletMarketingMaterial material = this.materialMapper.selectByNum(req.getMaterialId());
        if (material == null) {
            log.info("getMaterialConfig material is null, num: {}, bizId: {}", (Object)req.getMaterialId(), (Object)bizId);
            return null;
        }
        MaterialConfigResp resp = new MaterialConfigResp();
        resp.setId(material.getNum());
        resp.setAreaCode(material.getAreaCode());
        resp.setFirstCategoryId(material.getFirstCategoryId());
        resp.setSecondCategoryId(material.getSecondCategoryId());
        resp.setTitle(material.getTitle());
        resp.setPicUrl(material.getPicUrl());
        resp.setAuthConfig(material.getAuthConfig());
        resp.setViewCount(material.getInitNumber().intValue());
        resp.setQrcodeConfig(material.getQrcodeConfig());
        resp.setCreateTime(material.getCreateTime());
        return resp;
    }

    @Override
    public List<MaterialConfigResp> queryMaterialList(MaterialListReq req) {
        Long bizId = null;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getAppId()), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("queryMaterialList getBizId: {}, param: {}", (Object)bizId, (Object)req);
        req.validateParams();
        AppletMarketingMaterial mm = new AppletMarketingMaterial();
        mm.setBizId(bizId);
        mm.setStatus(Integer.valueOf(1));
        int selectCount = this.materialMapper.selectCount((Object)mm);
        if (selectCount == 0) {
            return JSONObject.parseArray((String)this.marketingMaterialList, MaterialConfigResp.class);
        }
        AppletMaterialListQuery query = new AppletMaterialListQuery();
        query.setBizId(bizId);
        query.setTitle(req.getTitle());
        query.setFirstCategoryId(req.getFirstCategoryId());
        ArrayList areaCodes = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)req.getAreaCode()) && !req.getAreaCode().equals("1")) {
            areaCodes.add(req.getAreaCode());
            if (req.getAreaCode().endsWith("0000")) {
                String beginStr = req.getAreaCode().substring(0, 2);
                List childAreas = this.levelConfigMapper.queryAreaValueBy(bizId);
                if (CollectionUtils.isNotEmpty((Collection)childAreas)) {
                    List filterAreas = childAreas.stream().filter(a -> a.startsWith(beginStr)).collect(Collectors.toList());
                    areaCodes.addAll(filterAreas);
                }
            }
        }
        log.info("queryMaterialList get areaCodes: {}, reqArea: {}", (Object)areaCodes, (Object)req.getAreaCode());
        query.setAreaCodes((List)areaCodes);
        if (StringUtils.isBlank((CharSequence)req.getSecondCategoryId()) || req.getSecondCategoryId().equals("0")) {
            query.setSecondCategoryId("");
        } else {
            query.setSecondCategoryId(req.getSecondCategoryId());
        }
        query.setOffset(Integer.valueOf(req.getPageDto().getOffset()));
        query.setPageSize(req.getPageDto().getPageSize());
        List materialList = this.materialMapper.queryMaterialListBy(query);
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            log.info("queryMaterialList materialList is null \u672a\u67e5\u8be2\u5230\u8425\u9500\u8d44\u6599\u5217\u8868, query: {}", (Object)query);
            return Collections.emptyList();
        }
        Integer count = this.materialMapper.queryMaterialListCountBy(query);
        req.getPageDto().setCount(count);
        ArrayList respList = Lists.newArrayList();
        for (AppletMarketingMaterial material : materialList) {
            MaterialConfigResp resp = new MaterialConfigResp();
            resp.setId(material.getNum());
            resp.setTitle(material.getTitle());
            resp.setAreaCode(material.getAreaCode());
            resp.setPicUrl(material.getPicUrl());
            resp.setFirstCategoryId(material.getFirstCategoryId());
            resp.setSecondCategoryId(material.getSecondCategoryId());
            resp.setAuthConfig(material.getAuthConfig());
            int viewCount = material.getInitNumber().intValue() + material.getViewCount().intValue();
            resp.setViewCount(viewCount);
            resp.setQrcodeConfig(material.getQrcodeConfig());
            resp.setCreateTime(material.getCreateTime());
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public List<MaterialConfigResp> searchMaterialList(MaterialListSearchReq req) {
        Long bizId = null;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getAppId()), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("searchMaterialList getBizId: {}, param: {}", (Object)bizId, (Object)req);
        if (StringUtils.isBlank((CharSequence)req.getQuery())) {
            return Collections.emptyList();
        }
        List materialList = this.materialMapper.searchMaterialListBy(bizId, req.getQuery());
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Collections.emptyList();
        }
        ArrayList respList = Lists.newArrayList();
        for (AppletMarketingMaterial material : materialList) {
            MaterialConfigResp resp = new MaterialConfigResp();
            resp.setId(material.getNum());
            resp.setTitle(material.getTitle());
            resp.setAreaCode(material.getAreaCode());
            resp.setPicUrl(material.getPicUrl());
            resp.setFirstCategoryId(material.getFirstCategoryId());
            resp.setSecondCategoryId(material.getSecondCategoryId());
            resp.setAuthConfig(material.getAuthConfig());
            int viewCount = material.getInitNumber().intValue() + material.getViewCount().intValue();
            resp.setViewCount(viewCount);
            resp.setQrcodeConfig(material.getQrcodeConfig());
            resp.setCreateTime(material.getCreateTime());
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public MaterialConfigResp queryMaterialDetail(MaterialDetailReq req) {
        req.validate();
        if (req.getMaterialId().equals("0")) {
            log.info("queryMaterialDetail is null \u9ed8\u8ba4\u6570\u636e, req: {}", (Object)req);
            return (MaterialConfigResp)JSONObject.parseObject((String)this.marketingMaterialDetail, MaterialConfigResp.class);
        }
        Long bizId = null;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getAppId()), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("queryMaterialDetail getBizId: {}\uff0c param: {}", (Object)bizId, (Object)req);
        AppletMarketingMaterial material = this.materialMapper.selectByNum(req.getMaterialId());
        MaterialConfigResp resp = new MaterialConfigResp();
        resp.setId(material.getNum());
        resp.setTitle(material.getTitle());
        resp.setPicUrl(material.getPicUrl());
        resp.setStatus(material.getStatus());
        if (material.getStatus() == 0) {
            log.info("queryMaterialDetail materialId: {}, status: {}", (Object)req.getMaterialId(), (Object)material.getStatus());
            return resp;
        }
        resp.setAreaCode(material.getAreaCode());
        resp.setFirstCategoryId(material.getFirstCategoryId());
        resp.setSecondCategoryId(material.getSecondCategoryId());
        resp.setAuthConfig(material.getAuthConfig());
        int viewCount = material.getInitNumber().intValue() + material.getViewCount().intValue();
        resp.setViewCount(viewCount);
        resp.setQrcodeConfig(material.getQrcodeConfig());
        resp.setCreateTime(material.getCreateTime());
        resp.setGroupConfig(material.getGroupConfig());
        if (GroupConfigEnum.GROUP.getValue() == material.getGroupConfig().intValue()) {
            List groupList = this.materialGroupMapper.selectByBizIdAndMaterialId(bizId, material.getId());
            if (CollectionUtils.isEmpty((Collection)groupList)) {
                log.info("queryMaterialDetail groupList is null, MaterialId: {}, bizId: {}", (Object)material.getId(), (Object)bizId);
                resp.setGroupDetailResps(Collections.emptyList());
                return resp;
            }
            List groupIds = groupList.stream().map(AppletMarketingMaterialGroup::getId).collect(Collectors.toList());
            log.info("queryMaterialDetail get groupIds: {}", groupIds);
            List fileList = this.materialFileMapper.selectByBizIdAndGroupIds(bizId, groupIds);
            ArrayList respList = Lists.newArrayList();
            for (AppletMarketingMaterialGroup group : groupList) {
                MaterialDetailResp detailResp = new MaterialDetailResp();
                detailResp.setGroupName(group.getGroupName());
                detailResp.setSort(group.getSort());
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    List files = fileList.stream().filter(a -> a.getGroupId().equals(group.getId())).collect(Collectors.toList());
                    ArrayList fileResps = Lists.newArrayList();
                    if (CollectionUtils.isNotEmpty(files)) {
                        for (AppletMarketingMaterialFile fileResp : files) {
                            MaterialFileResp fResp = new MaterialFileResp();
                            fResp.setId(fileResp.getNum());
                            fResp.setName(fileResp.getFileName());
                            fResp.setUrl(fileResp.getFileUrl());
                            fResp.setSort(fileResp.getSort());
                            fileResps.add(fResp);
                        }
                    }
                    detailResp.setMaterialFiles(fileResps);
                }
                respList.add(detailResp);
            }
            resp.setGroupDetailResps(respList);
        } else {
            List fileList = this.materialFileMapper.selectByBizIdAndMaterialId(bizId, material.getId());
            if (CollectionUtils.isEmpty((Collection)fileList)) {
                resp.setMaterialFiles(Collections.emptyList());
                return resp;
            }
            ArrayList fileResps = Lists.newArrayList();
            for (AppletMarketingMaterialFile fileResp : fileList) {
                MaterialFileResp fResp = new MaterialFileResp();
                fResp.setId(fileResp.getNum());
                fResp.setName(fileResp.getFileName());
                fResp.setUrl(fileResp.getFileUrl());
                fResp.setSort(fileResp.getSort());
                fileResps.add(fResp);
            }
            resp.setMaterialFiles(fileResps);
        }
        this.appletSettingThreadPool.submit(() -> {
            AppletContactInfo appletContactInfo;
            if (StringUtils.isNotBlank((CharSequence)req.getMaterialId()) && StringUtils.isNotBlank((CharSequence)req.getOpenId()) && (appletContactInfo = this.contactInfoMapper.checkPhoneByOpenId(material.getBizId(), req.getOpenId())) != null) {
                log.info("queryMaterialDetail checkPhoneByOpenId:{}", (Object)appletContactInfo.getId());
                this.materialUserInfoMapper.updateLatestAuthStatusByMaterialNum(material.getBizId(), req.getMaterialId(), appletContactInfo.getOpenId());
                this.marketingMaterialService.addTagWhenGetMaterialDetailByUserAuthorised(material.getBizId(), req.getMaterialId(), appletContactInfo.getPhone());
            }
        });
        return resp;
    }

    @Override
    public List<MaterialScanHistoryResp> getMaterialScanHistoryList(MaterialScanHistoryReq req) {
        req.validateParams();
        Long bizId = null;
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("getMaterialScanHistoryList getBizId: {}\uff0c param: {}", (Object)bizId, (Object)req);
        List recordResps = this.historyRecordMapper.queryHistoryRecordBy(bizId, req.getAppId(), req.getOpenId(), Integer.valueOf(req.getPageDto().getOffset()), req.getPageDto().getPageSize());
        if (CollectionUtils.isEmpty((Collection)recordResps)) {
            log.info("getMaterialScanHistoryList get recordResps is empty, bizId: {}, openId: {}", (Object)bizId, (Object)req.getOpenId());
            return Collections.emptyList();
        }
        Integer count = this.historyRecordMapper.queryHistoryRecordCount(bizId, req.getAppId(), req.getOpenId());
        req.getPageDto().setCount(count);
        ArrayList respList = Lists.newArrayList();
        for (HistoryRecordResp resp : recordResps) {
            MaterialScanHistoryResp historyResp = new MaterialScanHistoryResp();
            historyResp.setMaterialId(resp.getMaterialId());
            historyResp.setMaterialName(resp.getMaterialName());
            historyResp.setMaterialPic(resp.getMaterialPic());
            historyResp.setType(resp.getType());
            historyResp.setVisitTime(resp.getVisitTime());
            long visitCount = resp.getViewCount() + resp.getInitNum();
            historyResp.setViewCount((int)visitCount);
            respList.add(historyResp);
        }
        return respList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AppletUserResp materialScanReport(MaterialScanReportReq req) {
        req.validataParam();
        Long bizId = null;
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("materialScanReport getBizId: {}, param: {}", (Object)bizId, (Object)req);
        AppletMarketingMaterial material = this.materialMapper.selectByNum(req.getMaterialId());
        if (material == null) {
            log.info("materialScanReport material is null, materialId: {}", (Object)req.getMaterialId());
            return null;
        }
        AppletUserHistoryRecord appletUserHistoryRecord = this.historyRecordMapper.queryHistoryRecordToday(bizId, req.getAppId(), req.getOpenId(), material.getNum());
        if (appletUserHistoryRecord == null) {
            appletUserHistoryRecord = new AppletUserHistoryRecord();
            appletUserHistoryRecord.setBizId(bizId);
            appletUserHistoryRecord.setNum(this.idGen.getNum());
            appletUserHistoryRecord.setAppId(req.getAppId());
            appletUserHistoryRecord.setOpenId(req.getOpenId());
            appletUserHistoryRecord.setVisiteTime(new Date());
            appletUserHistoryRecord.setType(Integer.valueOf(1));
            appletUserHistoryRecord.setMaterialNum(material.getNum());
            appletUserHistoryRecord.setMaterialTitle(material.getTitle());
            appletUserHistoryRecord.setCreateTime(new Date());
            appletUserHistoryRecord.setIsDeleted(Integer.valueOf(0));
            this.historyRecordMapper.insertSelective((Object)appletUserHistoryRecord);
        } else {
            appletUserHistoryRecord.setVisiteTime(new Date());
            this.historyRecordMapper.updateByPrimaryKeySelective((Object)appletUserHistoryRecord);
        }
        Long viewCount = material.getViewCount() + 1L;
        material.setUpdateTime(new Date());
        material.setViewCount(viewCount);
        this.materialMapper.updateByPrimaryKeySelective((Object)material);
        if (StringUtils.isNotBlank((CharSequence)req.getMaterialFileId())) {
            AppletMarketingMaterialFile materialFile = this.materialFileMapper.selectByNum(req.getMaterialFileId());
            Long fileViewCount = materialFile.getViewCount() + 1L;
            materialFile.setViewCount(fileViewCount);
            materialFile.setUpdateTime(new Date());
            this.materialFileMapper.updateByPrimaryKeySelective((Object)materialFile);
        }
        if (req.getType() == 1 && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{req.getSpreadChannelId(), req.getSpreadChannelStaffId()})) {
            this.insertAppletMarketingMaterialUserInfoByNoSpread(material.getBizId(), material.getNum(), req.getOpenId());
        }
        if (req.getType() == 1 && StringUtils.isNotBlank((CharSequence)material.getNum())) {
            this.materialUserInfoMapper.updateBrowseByOpenId(material.getBizId(), material.getNum(), req.getOpenId());
        }
        AppletUserResp resp = new AppletUserResp();
        resp.setOpenId(req.getOpenId());
        return resp;
    }

    private void insertAppletMarketingMaterialUserInfoByNoSpread(Long bizId, String materialId, String openId) {
        AppletMarketingMaterialUserInfo materialUserInfo = new AppletMarketingMaterialUserInfo();
        materialUserInfo.setNum(this.idGen.getNum());
        materialUserInfo.setBizId(bizId);
        materialUserInfo.setMaterialNum(materialId);
        materialUserInfo.setCreateTime(new Date());
        materialUserInfo.setUpdateTime(new Date());
        materialUserInfo.setIsDeleted(Integer.valueOf(0));
        materialUserInfo.setOpenId(openId);
        materialUserInfo.setUnionId(this.contactInfoMapper.getUnionIdByOpenId(bizId, openId));
        this.materialUserInfoMapper.insertSelective((Object)materialUserInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AuthPhoneReportResp authPhoneReport(AuthPhoneReportReq req) {
        String phone;
        req.validate();
        AuthPhoneReportResp resp = new AuthPhoneReportResp();
        StopWatchDto timer = new StopWatchDto("appletAuthPhoneReport", true, log);
        Long bizId = null;
        timer.start("getByAppId");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        timer.stop();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("authPhoneReport getBizId: {}, param: {}", (Object)bizId, (Object)req);
        timer.start("decryptMobile");
        if (StringUtils.isNotBlank((CharSequence)req.getIv())) {
            try {
                String decryptData = this.decryptData(req.getPhone(), req.getSessionKey(), req.getIv());
                JSONObject jsonObject = JSONObject.parseObject((String)decryptData);
                phone = jsonObject.getString("purePhoneNumber");
            }
            catch (Exception e) {
                log.error("authPhoneReport \u89e3\u5bc6\u624b\u673a\u53f7\u5931\u8d25", (Throwable)e);
                timer.stop();
                timer.print();
                return resp;
            }
        } else {
            String accessToken = this.appletAccessTokenService.getAccessToken(appletInfo.getAppId());
            GetUserPhoneResp userPhone = this.getUserPhone(3, accessToken, req.getPhone());
            if (userPhone == null) {
                log.error("authPhoneReport \u89e3\u5bc6\u624b\u673a\u53f7\u5931\u8d25");
                timer.stop();
                timer.print();
                return resp;
            }
            phone = userPhone.getPhoneInfo().getPurePhoneNumber();
        }
        timer.stop();
        req.setPhone(phone);
        timer.start("queryContactInfo");
        AppletContactInfo contactInfo = this.contactInfoMapper.queryContactInfo(bizId, req.getOpenId());
        if (contactInfo == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u6388\u6743\uff0c\u67e5\u8be2\u5230\u7684\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        timer.stop();
        timer.start("updateContactInfo");
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, req.getPhone());
        log.info("authPhoneReport get customerNum: {}, phone: {}", (Object)customerNum, (Object)req.getPhone());
        this.contactInfoMapper.updateContactInfo(bizId, req.getOpenId(), req.getPhone(), customerNum);
        timer.stop();
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        AppletUseBusinessType businessType = AppletUseBusinessType.get(req.getAppletBusinessType());
        if (AppletUseBusinessType.MARKETING_MATERIAL.equals((Object)businessType)) {
            try {
                this.materialAppletService.doBusinessWhenAuthPhoneReport(bizId, businessCustomer.getCorpId(), req, contactInfo);
            }
            catch (Exception e) {
                log.error("authPhoneReport materialAppletService.doBusinessWhenAuthPhoneReport error", (Throwable)e);
            }
        } else {
            try {
                timer.start("doBusinessWhenAuthPhoneReport");
                resp = this.appletMeetingService.doBusinessWhenAuthPhoneReport(bizId, req);
                timer.stop();
            }
            catch (Exception e) {
                log.error("authPhoneReport appletMeetingService.doBusinessWhenAuthPhoneReport error", (Throwable)e);
                timer.stop();
            }
        }
        Long finalBizId = bizId;
        this.appletSettingThreadPool.submit(() -> {
            try {
                this.syncToCustomer(finalBizId, req.getPhone(), contactInfo.getOpenId());
            }
            catch (Exception e) {
                log.error("authPhoneReport syncToCustomer error", (Throwable)e);
            }
        });
        resp.setPhone(req.getPhone());
        timer.print();
        return resp;
    }

    private String decryptData(String encryptDataB64, String sessionKeyB64, String ivB64) {
        byte[] encryptedData = Base64.getDecoder().decode(encryptDataB64);
        byte[] keyBytes = Base64.getDecoder().decode(sessionKeyB64);
        byte[] ivs = Base64.getDecoder().decode(ivB64);
        int base = 16;
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + 1;
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec iv = new IvParameterSpec(ivs);
            cipher.init(2, (Key)keySpec, iv);
            byte[] decrypted = cipher.doFinal(encryptedData);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "AES\u89e3\u5bc6\u5931\u8d25");
        }
    }

    private void syncToCustomer(Long bizId, String mobile, String openId) {
        log.info("authPhoneReport syncToCustomer, bizId:{}, mobile:{}, openId:{}", new Object[]{bizId, mobile, openId});
        AppletInfo appletInfo = this.appletService.getByBusinessType(bizId, AppletUseBusinessType.MARKETING_MATERIAL, AppletAuthStatus.AUTHORIZED);
        if (appletInfo == null) {
            return;
        }
        boolean bindAppletAccount = this.ccCustomerNumService.mobileBindAppletAccount(bizId, mobile);
        if (bindAppletAccount) {
            log.info("authPhoneReport syncToCustomer,\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5c0f\u7a0b\u5e8f,\u672c\u6b21\u4e0d\u7ed1\u5b9a");
            return;
        }
        this.ccCustomerNumService.bindAppletAccountAndMobile(bizId, appletInfo.getAppId(), openId, mobile, null);
    }

    private GetUserPhoneResp getUserPhone(int retryTimes, String accessToken, String code) {
        GetUserPhoneResp userPhoneNumber;
        if (retryTimes == 0) {
            return null;
        }
        try {
            userPhoneNumber = this.appletAPI.getUserPhoneNumber(accessToken, code);
        }
        catch (Exception e) {
            log.error("getUserPhone error, retryTimes:{}", (Object)retryTimes, (Object)e);
            return this.getUserPhone(--retryTimes, accessToken, code);
        }
        log.info("getUserPhone code:{}, getUserPhoneResp:{}", (Object)code, (Object)userPhoneNumber);
        return userPhoneNumber;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AppletUserResp openAppletReport(OpenAppletReportReq req) {
        AppletUseBusinessType businessType;
        req.validateParam();
        StopWatchDto timer = new StopWatchDto("appletOpenAppletReport", true, log);
        Long bizId = null;
        timer.start("getByAppId");
        AppletInfo appletInfo = this.infoMapper.getByAppId(req.getAppId());
        if (appletInfo != null) {
            bizId = appletInfo.getBizId();
        }
        timer.stop();
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
        log.info("openAppletReport getBizId: {}, param: {}", (Object)bizId, (Object)req);
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        JsCode2SessionReq jsCode2SessionReq = new JsCode2SessionReq();
        jsCode2SessionReq.setAppId(req.getAppId());
        jsCode2SessionReq.setJsCode(req.getJsCode());
        jsCode2SessionReq.setComponentAppId(this.componentAppId);
        jsCode2SessionReq.setComponentAccessToken(componentAccessToken);
        timer.start("code2Session");
        AppletSessionResp session = this.appletAPI.code2Session(jsCode2SessionReq);
        timer.stop();
        if (session == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "jsCode\u89e3\u6790\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        this.insertAppletContact(req, bizId, session);
        AppletUserResp resp = null;
        AppletUseBusinessType appletUseBusinessType = businessType = req.getAppletBusinessType() == null ? AppletUseBusinessType.MARKETING_MATERIAL : AppletUseBusinessType.get(req.getAppletBusinessType());
        if (AppletUseBusinessType.MARKETING_MATERIAL.equals((Object)businessType)) {
            try {
                resp = this.materialAppletService.doBusinessWhenOpenAppletReport(bizId, session, req);
            }
            catch (Exception e) {
                log.error("openAppletReport,materialAppletService.doBusinessWhenOpenAppletReport error", (Throwable)e);
            }
        } else if (AppletUseBusinessType.LIVE_DELIVERY.equals((Object)businessType)) {
            try {
                timer.start("doBusinessWhenOpenAppletReport");
                resp = this.appletMeetingService.doBusinessWhenOpenAppletReport(bizId, session, req);
                timer.stop();
            }
            catch (Exception e) {
                log.error("openAppletReport,appletMeetingService.doBusinessWhenOpenAppletReport error", (Throwable)e);
                timer.stop();
            }
        }
        if (resp == null) {
            resp = new AppletUserResp();
        }
        resp.setOpenId(session.getOpenId());
        resp.setSessionKey(session.getSessionKey());
        timer.print();
        return resp;
    }

    private void insertAppletContact(OpenAppletReportReq req, Long bizId, AppletSessionResp session) {
        int count;
        AppletContactInfo select = new AppletContactInfo();
        select.setBizId(bizId);
        select.setAppId(req.getAppId());
        select.setOpenId(session.getOpenId());
        if (StringUtils.isNotBlank((CharSequence)session.getUnionId())) {
            select.setUnionId(session.getUnionId());
        }
        if ((count = this.contactInfoMapper.selectCount((Object)select)) != 0) {
            this.appletSettingThreadPool.submit(() -> {
                if (StringUtils.isBlank((CharSequence)session.getUnionId())) {
                    return;
                }
                AppletContactInfo selectContactId = new AppletContactInfo();
                selectContactId.setBizId(bizId);
                selectContactId.setUnionId(session.getUnionId());
                AppletContactInfo appletContactInfo = (AppletContactInfo)this.contactInfoMapper.selectOne((Object)selectContactId);
                String contactId = appletContactInfo == null ? null : appletContactInfo.getContactId();
                this.updateIntoGroupStatusAndAvatar(bizId, session.getUnionId(), contactId);
                if (StringUtils.isNotBlank((CharSequence)contactId) && StringUtils.isNotBlank((CharSequence)appletContactInfo.getPhone()) && StringUtils.isNotBlank((CharSequence)appletContactInfo.getCustomerNum())) {
                    this.marketingMaterialService.bindMobileAndContactId(bizId, appletContactInfo.getPhone(), contactId, appletContactInfo.getCustomerNum());
                }
            });
            return;
        }
        AppletContactInfo contactInfo = new AppletContactInfo();
        contactInfo.setNum(this.idGen.getNum());
        contactInfo.setBizId(bizId);
        contactInfo.setAppId(req.getAppId());
        contactInfo.setOpenId(session.getOpenId());
        contactInfo.setUnionId(session.getUnionId());
        contactInfo.setCreateTime(new Date());
        contactInfo.setCreateBy(Long.valueOf(-1L));
        contactInfo.setUpdateTime(new Date());
        contactInfo.setUpdateBy(Long.valueOf(-1L));
        contactInfo.setIsDeleted(Integer.valueOf(0));
        this.contactInfoMapper.insertSelective((Object)contactInfo);
        if (StringUtils.isNotBlank((CharSequence)session.getUnionId())) {
            this.appletSettingThreadPool.submit(() -> this.updateIntoGroupStatusAndAvatar(bizId, session.getUnionId(), null));
        }
    }

    private void updateIntoGroupStatusAndAvatar(Long bizId, String unionId, String contactId) {
        log.info("updateIntoGroupStatusAndAvatar, bizId:{}, unionId:{}, contactId:{}", new Object[]{bizId, unionId, contactId});
        if (StringUtils.isBlank((CharSequence)unionId)) {
            return;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = businessCustomer.getCorpId();
        WeworkContact weworkContact = this.weworkContactMapper.selectByCorpIdAndUnionId(businessCustomer.getCorpId(), unionId);
        log.info("updateIntoGroupStatusAndAvatar select weworkContact:{}", (Object)(weworkContact == null ? 1 : 0));
        if (weworkContact != null) {
            if (StringUtils.isBlank((CharSequence)contactId) && StringUtils.isNotBlank((CharSequence)weworkContact.getContactId())) {
                log.info("updateIntoGroupStatusAndAvatar updateContactIdByUnionId, bizId:{}, unionId:{}, weworkContactContactId:{}", new Object[]{bizId, unionId, weworkContact.getContactId()});
                this.contactInfoMapper.updateContactIdByUnionId(bizId, unionId, weworkContact.getContactId());
            }
            String string = contactId = StringUtils.isNotBlank((CharSequence)contactId) ? contactId : weworkContact.getContactId();
            if (StringUtils.isNotBlank((CharSequence)weworkContact.getAvatar()) || StringUtils.isNotBlank((CharSequence)weworkContact.getName())) {
                this.contactInfoMapper.updateAvatarAndNicknameByUnionId(bizId, unionId, weworkContact.getAvatar(), weworkContact.getName());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            this.marketingMaterialService.updateIntoGroupStatusByContactId(bizId, corpId, contactId);
        }
    }

    @Override
    public void delArea(DelAreaReq req) {
        log.info("delArea req:{}", (Object)req);
        req.validate();
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        this.levelConfigMapper.delAllLevelByNums(user.getBizId(), Integer.valueOf(AppletLevelConfigTypeEnum.AREA.getType()), req.getAreaIds(), user.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modArea(ModAreaReq req) {
        log.info("modArea req:{}", (Object)req);
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        if (CollectionUtils.isNotEmpty(req.getDelAreaIds())) {
            DelAreaReq delAreaReq = new DelAreaReq();
            delAreaReq.setAreaIds(req.getDelAreaIds());
            this.delArea(delAreaReq);
        }
        List<AreaResp> data = req.getData();
        HashSet<AreaResp> firstArea = new HashSet<AreaResp>();
        HashSet<String> addSecondAreaCode = new HashSet<String>();
        HashMap<String, AreaResp> areaMap = new HashMap<String, AreaResp>();
        for (AreaResp area : data) {
            if (area.getValue().endsWith("0000")) {
                firstArea.add(area);
            } else if (StringUtils.isBlank((CharSequence)area.getAreaId())) {
                addSecondAreaCode.add(area.getValue());
            }
            areaMap.put(area.getValue(), area);
        }
        ArrayList<AppletLevelConfig> addList = new ArrayList<AppletLevelConfig>();
        Date now = new Date();
        for (AreaResp areaResp : firstArea) {
            String pNum = areaResp.getAreaId();
            if (StringUtils.isEmpty((CharSequence)pNum)) {
                pNum = this.idGen.getNum();
                addList.add(this.buildAppletLevelConfig(pNum, "0", now, user, areaResp.getLabel(), areaResp.getValue(), areaResp.getLevel(), AppletLevelConfigTypeEnum.AREA, 1));
            }
            String startCode = areaResp.getValue().substring(0, 2);
            HashSet<String> removeSecondAreaCode = new HashSet<String>();
            for (String secondArea : addSecondAreaCode) {
                if (!secondArea.startsWith(startCode)) continue;
                addList.add(this.buildAppletLevelConfig(this.idGen.getNum(), pNum, now, user, ((AreaResp)areaMap.get(secondArea)).getLabel(), ((AreaResp)areaMap.get(secondArea)).getValue(), areaResp.getLevel(), AppletLevelConfigTypeEnum.AREA, 1));
                removeSecondAreaCode.add(secondArea);
            }
            addSecondAreaCode.removeAll(removeSecondAreaCode);
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            this.levelConfigMapper.batchInsert(addList);
        }
    }

    private AppletLevelConfig buildAppletLevelConfig(String num, String pNum, Date now, CurrentUserInfo user, String name, String value, String level, AppletLevelConfigTypeEnum typeEnum, Integer sort) {
        AppletLevelConfig config = new AppletLevelConfig();
        config.setpNum(pNum);
        config.setNum(num);
        config.setBizId(user.getBizId());
        config.setType(Integer.valueOf(typeEnum.getType()));
        config.setName(name);
        config.setValue(value);
        config.setCreateTime(now);
        config.setCreateBy(user.getId());
        config.setSort(sort);
        config.setLevel(level);
        return config;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addCategory(AddCategoryReq req) {
        log.info("addCategory req:{}", (Object)req);
        req.validate();
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        List<CategoryDto> data = req.getData();
        HashMap<String, String> newNamesPcategroyMap = new HashMap<String, String>();
        for (CategoryDto categoryDto : data) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)categoryDto.getCategoryName()), (Object)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            newNamesPcategroyMap.put(categoryDto.getCategoryName(), categoryDto.getPCategoryId());
        }
        List appletLevelConfigs = this.levelConfigMapper.selectByNames(user.getBizId(), newNamesPcategroyMap.keySet(), Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()));
        if (CollectionUtils.isNotEmpty((Collection)appletLevelConfigs)) {
            for (AppletLevelConfig appletLevelConfig : appletLevelConfigs) {
                String pCategoryId = (String)newNamesPcategroyMap.get(appletLevelConfig.getName());
                if (!StringUtils.isNotBlank((CharSequence)pCategoryId) || !appletLevelConfig.getpNum().equals(pCategoryId)) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, appletLevelConfig.getName() + " \u5206\u7c7b\u5df2\u5b58\u5728");
            }
        }
        ArrayList<AppletLevelConfig> arrayList = new ArrayList<AppletLevelConfig>();
        Date now = new Date();
        String pNum = this.idGen.getNum();
        for (CategoryDto categoryDto : data) {
            AppletLevelConfig config;
            if (categoryDto.getLevel() == 1) {
                config = this.buildAppletLevelConfig(pNum, "0", now, user, categoryDto.getCategoryName(), "", categoryDto.getLevel().toString(), AppletLevelConfigTypeEnum.CATEGORY, categoryDto.getSort());
                arrayList.add(config);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)categoryDto.getPCategoryId())) {
                pNum = categoryDto.getPCategoryId();
            }
            config = this.buildAppletLevelConfig(this.idGen.getNum(), pNum, now, user, categoryDto.getCategoryName(), "", categoryDto.getLevel().toString(), AppletLevelConfigTypeEnum.CATEGORY, 1);
            arrayList.add(config);
        }
        if (CollectionUtils.isNotEmpty(arrayList)) {
            this.levelConfigMapper.batchInsert(arrayList);
        }
    }

    @Override
    public void delCategory(DelCategoryReq req) {
        log.info("delCategory req:{}", (Object)req);
        req.validate();
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        AppletLevelConfig select = new AppletLevelConfig();
        select.setBizId(user.getBizId());
        select.setNum(req.getCategoryId());
        select.setType(Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()));
        select.setIsDeleted(Integer.valueOf(0));
        AppletLevelConfig config = (AppletLevelConfig)this.levelConfigMapper.selectOne((Object)select);
        if (config == null) {
            return;
        }
        if ("0".equals(config.getpNum())) {
            this.levelConfigMapper.delAllLevelByNum(user.getBizId(), Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()), config.getNum(), user.getId());
        } else {
            this.levelConfigMapper.delByNums(user.getBizId(), Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()), Collections.singletonList(config.getNum()), user.getId());
        }
    }

    @Override
    public void modCategory(ModCategoryReq req) {
        log.info("modCategory req:{}", (Object)req);
        req.validate();
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        AppletLevelConfig select = new AppletLevelConfig();
        select.setBizId(user.getBizId());
        select.setNum(req.getCategoryId());
        select.setType(Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()));
        select.setIsDeleted(Integer.valueOf(0));
        AppletLevelConfig config = (AppletLevelConfig)this.levelConfigMapper.selectOne((Object)select);
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        Long isExist = this.levelConfigMapper.checkNameIsExist(user.getBizId(), Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()), req.getCategoryName(), config.getNum(), Integer.valueOf(Integer.parseInt(config.getLevel())));
        Preconditions.checkArgument((isExist == 0L ? 1 : 0) != 0, (Object)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        config.setName(req.getCategoryName());
        config.setUpdateTime(new Date());
        config.setUpdateBy(user.getId());
        this.levelConfigMapper.updateByPrimaryKeySelective((Object)config);
    }

    @Override
    public void modFirstCategorySortReq(ModFirstCategorySortReq req) {
        log.info("modFirstCategorySortReq req:{}", (Object)req);
        req.validate();
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        List<String> firstCategoryIds = req.getFirstCategoryIds();
        ArrayList<UpdateLevelConfigSortDto> list = new ArrayList<UpdateLevelConfigSortDto>();
        for (int i1 = 0; i1 < firstCategoryIds.size(); ++i1) {
            UpdateLevelConfigSortDto dto = new UpdateLevelConfigSortDto();
            dto.setNum(firstCategoryIds.get(i1));
            dto.setSort(Integer.valueOf(i1 + 1));
            list.add(dto);
        }
        this.levelConfigMapper.batchUpdateCategorySort(user.getBizId(), Integer.valueOf(AppletLevelConfigTypeEnum.CATEGORY.getType()), list);
    }
}

