/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletAPI;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletCategoryAPI;
import cn.kinyun.scrm.weixin.sdk.api.component.ComponentAuthAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopAPI;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfo;
import cn.kinyun.scrm.weixin.sdk.entity.component.AuthorizerInfoResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category.CategoriesDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.dto.category.CategoriesListDto;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.req.JsCode2SessionReq;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletSessionResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.category.GetAllCategoriesResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ShopInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.ShopInfoResp;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.applet.dto.req.AppletReq;
import com.kuaike.scrm.applet.dto.req.Code2SessionReq;
import com.kuaike.scrm.applet.dto.req.CodeSessionReqDto;
import com.kuaike.scrm.applet.dto.req.GenSchemeReqDto;
import com.kuaike.scrm.applet.dto.resp.AppletBaseInfoResp;
import com.kuaike.scrm.applet.dto.resp.AppletIsAuthResp;
import com.kuaike.scrm.applet.dto.resp.AppletListResp;
import com.kuaike.scrm.applet.dto.resp.AppletSchemeRespDto;
import com.kuaike.scrm.applet.dto.resp.AppletTokenRespDto;
import com.kuaike.scrm.applet.dto.resp.CodeSessionRespDto;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.applet.entity.AppletAuditRelease;
import com.kuaike.scrm.dal.applet.entity.AppletVersion;
import com.kuaike.scrm.dal.applet.mapper.AppletAuditReleaseMapper;
import com.kuaike.scrm.dal.applet.mapper.AppletVersionMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dto.req.CategoriesReq;
import com.kuaike.scrm.enums.AppletUseBusinessType;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class AppletServiceImpl
implements AppletService {
    private static final Logger log = LoggerFactory.getLogger(AppletServiceImpl.class);
    @Resource
    private AppletCategoryAPI appletCategoryAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Value(value="${scrm.applet.appid}")
    private String appId;
    @Value(value="${scrm.applet.secret}")
    private String appSecret;
    @Value(value="${scrm.applet.getAccessToken.url}")
    private String getTokenUrl;
    @Value(value="${scrm.applet.generateScheme.url}")
    private String generateScheme;
    @Value(value="${scrm.applet.code2Session.url}")
    private String codeSessionUrl;
    @Value(value="${scrm.applet.accessToken.key}")
    private String tokenKey;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ComponentAuthAPI componentAuthAPI;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Value(value="${wx.component.appid}")
    private String componentAppId;
    @Autowired
    private AppletAPI appletAPI;
    @Resource
    private WxShopAPI wxShopAPI;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    private static final String APPLET_SESSION_INFO_KEY = "appletInfo:";
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private ExternalContactClient externalContactClient;
    @Resource
    private AppletAuditReleaseMapper appletAuditReleaseMapper;
    @Resource
    private AppletVersionMapper appletVersionMapper;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;

    @Override
    public String getAccessToken() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("grant_type", "client_credential");
        param.put("appid", this.appId);
        param.put("secret", this.appSecret);
        log.info("getAccessToken param: {}", param);
        try {
            String resultJson = HttpClientUtils.doGet((String)this.getTokenUrl, param, null, (String)StandardCharsets.UTF_8.toString());
            log.info("getAccessToken Url: {}, resultJson: {}", (Object)this.getTokenUrl, (Object)resultJson);
            AppletTokenRespDto respDto = (AppletTokenRespDto)JacksonUtil.str2Obj((String)resultJson, AppletTokenRespDto.class);
            if (respDto != null) {
                if (respDto.getErrCode() != null) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, respDto.getErrMsg());
                }
                ValueOperations opsForValue = this.redisTemplate.opsForValue();
                opsForValue.set((Object)this.tokenKey, (Object)respDto.getAccessToken());
                return respDto.getAccessToken();
            }
        }
        catch (Exception e) {
            log.error("getAccessToken error", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getSchemeUrl(GenSchemeReqDto reqDto) {
        reqDto.validate();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (reqDto.getJumpWxaReqDto() != null) {
            param.put("jump_wxa", reqDto.getJumpWxaReqDto());
        }
        if (reqDto.getIsExpire() != null) {
            param.put("is_expire", reqDto.getIsExpire());
        }
        if (reqDto.getExpireType() != null) {
            param.put("expire_type", reqDto.getExpireType());
        }
        if (reqDto.getExpireTime() != null) {
            param.put("expire_time", reqDto.getExpireTime());
        }
        if (reqDto.getExpireInterval() != null) {
            param.put("expire_interval", reqDto.getExpireInterval());
        }
        log.info("getSchemeUrl param: {}", param);
        String authorizedAppId = this.appletInfoMapper.selectOneAppIdByBizIdAndStatus(reqDto.getBizId(), AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
        if (StringUtils.isBlank((CharSequence)authorizedAppId)) {
            log.info("\u5546\u6237bizId:{}\u4e0b\u672a\u67e5\u8be2\u5230\u5df2\u6388\u6743\u5df2\u8ba4\u8bc1\u7684\u5c0f\u7a0b\u5e8f", (Object)reqDto.getBizId());
            return "";
        }
        try {
            String accessToken = this.appletAccessTokenService.getAccessToken(authorizedAppId);
            log.info("getSchemeUrl accessToken: {}", (Object)accessToken);
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                String schemeUrl = this.generateScheme + "?access_token=" + accessToken;
                String resultJson = HttpClientUtils.doJsonPost((String)schemeUrl, param, (String)StandardCharsets.UTF_8.toString());
                log.info("getSchemeUrl Url: {}, resultJson: {}", (Object)schemeUrl, (Object)resultJson);
                AppletSchemeRespDto respDto = (AppletSchemeRespDto)JacksonUtil.str2Obj((String)resultJson, AppletSchemeRespDto.class);
                if (respDto != null) {
                    if (respDto.getErrcode() != 0) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, respDto.getErrmsg());
                    }
                    log.info("getSchemeUrl getOpenlink: {}", (Object)respDto.getOpenlink());
                    return respDto.getOpenlink();
                }
            }
        }
        catch (Exception e) {
            log.error("getSchemeUrl error", (Throwable)e);
        }
        return null;
    }

    @Override
    public CodeSessionRespDto code2Session(CodeSessionReqDto reqDto) {
        reqDto.validate();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("appid", this.appId);
        param.put("secret", this.appSecret);
        param.put("js_code", reqDto.getJsCode());
        param.put("grant_type", "authorization_code");
        log.info("code2Session param: {}", param);
        try {
            String resultJson = HttpClientUtils.doGet((String)this.codeSessionUrl, param, null, (String)StandardCharsets.UTF_8.toString());
            log.info("code2Session Url: {}, resultJson: {}", (Object)this.codeSessionUrl, (Object)resultJson);
            CodeSessionRespDto respDto = (CodeSessionRespDto)JacksonUtil.str2Obj((String)resultJson, CodeSessionRespDto.class);
            if (respDto != null) {
                if (respDto.getErrCode() != null && respDto.getErrCode() != 0) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, respDto.getErrMsg());
                }
                log.info("code2Session respDto: {}", (Object)respDto);
                return respDto;
            }
        }
        catch (Exception e) {
            log.error("code2Session error", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<CategoriesDto> categories(CategoriesReq req) {
        GetAllCategoriesResp allCategories;
        log.info("categories req:{}", (Object)req);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        req.validate();
        AppletInfo appletInfo = this.selectAuthorizedByBizId(userInfo.getBizId());
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        ArrayList<CategoriesDto> list = new ArrayList<CategoriesDto>();
        try {
            allCategories = this.appletCategoryAPI.getAllCategories(this.appletAccessTokenService.getAccessToken(appletInfo.getAppId()));
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7c7b\u76ee\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7c7b\u76ee allCategories size:{}", (Object)allCategories.getCategoriesList().getCategoriesDto().size());
        CategoriesListDto categoriesList = allCategories.getCategoriesList();
        Preconditions.checkArgument((categoriesList != null ? 1 : 0) != 0, (Object)"\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        List categoriesDto = categoriesList.getCategoriesDto();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)categoriesDto), (Object)"\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        for (CategoriesDto dto : categoriesDto) {
            if (dto.getFather() == null || !dto.getFather().equals(req.getId())) continue;
            list.add(dto);
        }
        return list;
    }

    @Override
    public AppletInfo selectAuthorizedByBizId(Long bizId) {
        AppletInfo shopExist = new AppletInfo();
        shopExist.setBizId(bizId);
        shopExist.setBusinessType(AppletUseBusinessType.WX_SHOP.getType());
        shopExist.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
        return (AppletInfo)this.appletInfoMapper.selectOne((Object)shopExist);
    }

    @Override
    public AppletInfo selectAuthorizedByAppId(Long bizId, String appId) {
        AppletInfo select = new AppletInfo();
        select.setAppId(appId);
        select.setBizId(bizId);
        select.setAuthStatus(AppletAuthStatus.AUTHORIZED.getStatus());
        return (AppletInfo)this.appletInfoMapper.selectOne((Object)select);
    }

    @Override
    public AppletBaseInfoResp baseInfo() {
        ShopInfoResp shopInfo;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        AppletInfo appletInfo = this.selectAuthorizedByBizId(userInfo.getBizId());
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728\u6216\u5df2\u53d6\u6d88\u6388\u6743");
        AppletBaseInfoResp resp = new AppletBaseInfoResp();
        try {
            shopInfo = this.wxShopAPI.getShopInfo(this.appletAccessTokenService.getAccessToken(appletInfo.getAppId()));
        }
        catch (Exception e) {
            log.error("baseInfo \u5b9e\u65f6\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u57fa\u672c\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        ShopInfoDto data = shopInfo.getData();
        resp.setName(data.getStoreName());
        resp.setLogo(data.getLogo());
        resp.setType(data.getType());
        resp.setAppId(appletInfo.getAppId());
        resp.setOriginId(appletInfo.getUserName());
        return resp;
    }

    @Override
    public CategoriesDto getCategoryByAccessTokenAndId(String accessToken, Integer id) {
        GetAllCategoriesResp allCategories;
        try {
            allCategories = this.appletCategoryAPI.getAllCategories(accessToken);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7c7b\u76ee\u5f02\u5e38", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u5c0f\u7a0b\u5e8f\u7c7b\u76ee allCategories:{}", (Object)allCategories);
        CategoriesListDto categoriesList = allCategories.getCategoriesList();
        Preconditions.checkArgument((categoriesList != null ? 1 : 0) != 0, (Object)"\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        List categoriesDto = categoriesList.getCategoriesDto();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)categoriesDto), (Object)"\u83b7\u53d6\u7c7b\u76ee\u5931\u8d25\uff0c\u83b7\u53d6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        for (CategoriesDto dto : categoriesDto) {
            if (!dto.getId().equals(id)) continue;
            return dto;
        }
        return null;
    }

    @Override
    public void resetAppletInfo(String appId) {
        log.info("resetAppletInfo with appId={}", (Object)appId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        AuthorizerInfoResp appInfo = this.componentAuthAPI.apiGetAuthorizerInfo(componentAccessToken, this.componentAppId, appId);
        AuthorizerInfo authorizerInfo = appInfo.getAuthorizerInfo();
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(appId);
        appletInfo.setLogo(authorizerInfo.getHeadImg());
        appletInfo.setPrincipalName(authorizerInfo.getPrincipalName());
        appletInfo.setQrcodeUrl(authorizerInfo.getQrcodeUrl());
        appletInfo.setStoreName(authorizerInfo.getNickName());
        appletInfo.setUserName(authorizerInfo.getUserName());
        this.appletInfoMapper.updateByPrimaryKeySelective((Object)appletInfo);
    }

    @Override
    public CodeSessionRespDto getSessionInfo(Code2SessionReq req) {
        log.info("getSessionInfo with req={}", (Object)req);
        req.validate();
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(req.getAppId());
        if (Objects.isNull(appletInfo) || appletInfo.getAuthStatus() != 1) {
            return null;
        }
        CodeSessionRespDto dto = new CodeSessionRespDto();
        AppletSessionResp resp = this.getAppletSession(req);
        this.meetingUrlCommonService.unionId2contactId(appletInfo.getCorpId(), resp.getUnionId(), resp.getOpenId());
        dto.setSessionKey(resp.getSessionKey());
        dto.setErrCode(resp.getErrCode());
        dto.setErrMsg(resp.getErrMsg());
        dto.setOpenId(resp.getOpenId());
        dto.setUnionId(resp.getUnionId());
        return dto;
    }

    private AppletSessionResp getAppletSession(Code2SessionReq req) {
        String redisKey = APPLET_SESSION_INFO_KEY + req.getJsCode();
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            AppletSessionResp appletSessionResp;
            log.info("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u7684appletSession\u4e3a:{}", (Object)value);
            try {
                appletSessionResp = (AppletSessionResp)JacksonUtil.str2Obj((String)value, AppletSessionResp.class);
            }
            catch (Exception e) {
                log.error("getAppletSession\u5f02\u5e38 \u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            return appletSessionResp;
        }
        String componentAccessToken = this.componentTokenService.getComponentAccessToken();
        JsCode2SessionReq jsCode2SessionReq = new JsCode2SessionReq();
        jsCode2SessionReq.setAppId(req.getAppId());
        jsCode2SessionReq.setJsCode(req.getJsCode());
        jsCode2SessionReq.setComponentAppId(this.componentAppId);
        jsCode2SessionReq.setComponentAccessToken(componentAccessToken);
        AppletSessionResp session = this.appletAPI.code2Session(jsCode2SessionReq);
        this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JacksonUtil.obj2Str((Object)session), 1L, TimeUnit.MINUTES);
        return session;
    }

    private void syncToCustomer(Code2SessionReq req, AppletInfo appletInfo, AppletSessionResp resp) {
        log.info("\u7528\u6237\u767b\u5f55\u5c0f\u7a0b\u5e8f \u540c\u6b65\u4fe1\u606f\u81f3\u5ba2\u6237\u4e2d\u5fc3 req:{},bizId:{},appId:{},openId:{},unionId:{}", new Object[]{req, appletInfo.getBizId(), appletInfo.getAppId(), resp.getOpenId(), resp.getUnionId()});
        String customerNum = this.ccCustomerNumService.getCustomerNumByMiniProgram(appletInfo.getBizId(), appletInfo.getAppId(), resp.getOpenId(), resp.getUnionId());
        log.info("ccCustomerNumService getCustomerNumByMiniProgram res:{}", (Object)customerNum);
    }

    @Override
    public AppletIsAuthResp isAuth(Code2SessionReq req) {
        log.info("isAuth req:{}", (Object)req);
        req.validate();
        AppletIsAuthResp resp = new AppletIsAuthResp();
        resp.setAuth(false);
        AppletInfo appletInfo = this.appletInfoMapper.queryByAppId(req.getAppId());
        if (Objects.isNull(appletInfo) || appletInfo.getAuthStatus() != 1) {
            log.info("isAuth \u901a\u8fc7appId\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u4fe1\u606f\u4e3a\u7a7a\u6216\u672a\u6388\u6743");
            return resp;
        }
        AppletSessionResp appletSession = this.getAppletSession(req);
        this.meetingUrlCommonService.unionId2contactId(appletInfo.getCorpId(), appletSession.getUnionId(), appletSession.getOpenId());
        boolean isExist = this.ccCustomerNumService.appIdAndOpenIdIsExistByMiniProgram(appletInfo.getBizId(), appletInfo.getAppId(), appletSession.getOpenId(), appletSession.getUnionId());
        if (isExist) {
            resp.setAuth(true);
        } else {
            CompletableFuture.runAsync(() -> {
                try {
                    this.syncToCustomer(req, appletInfo, appletSession);
                }
                catch (Exception e) {
                    log.error("\u7528\u6237\u767b\u5f55\u5c0f\u7a0b\u5e8f \u540c\u6b65\u4fe1\u606f\u81f3\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38", (Throwable)e);
                }
            });
        }
        return resp;
    }

    @Override
    public List<AppletListResp> list() {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        AppletInfo select = new AppletInfo();
        select.setBizId(currentUser.getBizId());
        select.setIsDeleted(Integer.valueOf(0));
        List appletInfoList = this.appletInfoMapper.select((Object)select);
        if (CollectionUtils.isEmpty((Collection)appletInfoList)) {
            return Collections.emptyList();
        }
        List appIds = appletInfoList.stream().map(AppletInfo::getAppId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List appletAuditReleases = this.appletAuditReleaseMapper.selectRecentRecordByAppIds(appIds);
        Map auditMap = appletAuditReleases.stream().collect(Collectors.toMap(AppletAuditRelease::getAppId, Function.identity()));
        List appletVersions = this.appletVersionMapper.selectRecentRecordByAppIds(appIds);
        Map versionMap = appletVersions.stream().collect(Collectors.toMap(AppletVersion::getAppId, Function.identity()));
        ArrayList<AppletListResp> list = new ArrayList<AppletListResp>(appletInfoList.size());
        for (AppletInfo appletInfo : appletInfoList) {
            AppletVersion appletVersion;
            if (AppletAuthStatus.UNAUTHORIZED.getStatus().equals(appletInfo.getAuthStatus())) continue;
            String appId = appletInfo.getAppId();
            AppletListResp resp = new AppletListResp();
            resp.setId(appId);
            resp.setAppId(appId);
            resp.setName(appletInfo.getStoreName());
            resp.setAuthStatus(appletInfo.getAuthStatus());
            AppletAuditRelease appletAuditRelease = (AppletAuditRelease)auditMap.get(appId);
            if (appletAuditRelease != null) {
                resp.setAuditStatus(appletAuditRelease.getAuditStatus());
            }
            if ((appletVersion = (AppletVersion)versionMap.get(appId)) != null) {
                resp.setVersion(appletVersion.getVersion());
            }
            list.add(resp);
        }
        return list;
    }

    @Override
    public AppletInfo getByBusinessType(Long bizId, AppletUseBusinessType businessType, AppletAuthStatus appletAuthStatus) {
        log.info("getByBusinessType, bizId:{}, businessType:{}, appletAuthStatus:{}", new Object[]{bizId, businessType, appletAuthStatus});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((businessType != null ? 1 : 0) != 0, (Object)"businessType\u4e0d\u80fd\u4e3a\u7a7a");
        AppletInfo select = new AppletInfo();
        select.setIsDeleted(Integer.valueOf(0));
        select.setBizId(bizId);
        select.setBusinessType(businessType.getType());
        if (appletAuthStatus != null) {
            select.setAuthStatus(appletAuthStatus.getStatus());
        }
        return (AppletInfo)this.appletInfoMapper.selectOne((Object)select);
    }

    @Override
    public AppletBaseInfoResp getAppletSimpleInfo(AppletReq req) {
        log.info("getAppletSimpleInfo,req:{}", (Object)req);
        if (req.getBizId() == null || req.getBizId() < 0L) {
            log.info("\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5,req:{}", (Object)req);
            return null;
        }
        AppletInfo appletInfo = this.appletInfoMapper.selectNewestAppletByBizIdAndStatus(req.getBizId(), AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
        if (appletInfo == null) {
            log.warn("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230\u5df2\u6388\u6743\u3001\u5df2\u8ba4\u8bc1\u7684\u5c0f\u7a0b\u5e8f", (Object)req.getBizId());
            return null;
        }
        AppletBaseInfoResp resp = new AppletBaseInfoResp();
        resp.setName(appletInfo.getStoreName());
        resp.setLogo(appletInfo.getLogo());
        return resp;
    }
}

