/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.weixin.sdk.api.applet.AppletQrcodeAPI;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkReq;
import cn.kinyun.scrm.weixin.sdk.entity.applet.GenerateUrlLinkResp;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.resp.AppletSessionResp;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.dto.req.AuthPhoneReportReq;
import com.kuaike.scrm.applet.dto.req.GenSchemeReqDto;
import com.kuaike.scrm.applet.dto.req.GetMeetingLiveDeliveryConfigReq;
import com.kuaike.scrm.applet.dto.req.JumpWxaReqDto;
import com.kuaike.scrm.applet.dto.req.OpenAppletReportReq;
import com.kuaike.scrm.applet.dto.req.meeting.GetAppletUrlReq;
import com.kuaike.scrm.applet.dto.resp.AppletUserResp;
import com.kuaike.scrm.applet.dto.resp.GetMeetingLiveDeliveryConfigResp;
import com.kuaike.scrm.applet.dto.resp.auth.AuthPhoneReportResp;
import com.kuaike.scrm.applet.dto.resp.meeting.GetAppletUrlResp;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.AppletMeetingService;
import com.kuaike.scrm.applet.service.AppletService;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.enums.applet.AppletAuthStatus;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyStudentInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dto.MeetingCustomerInfoDto;
import com.kuaike.scrm.order.dto.JudgeOrderBelongUserIdDto;
import com.kuaike.scrm.order.service.GoodsOrderService;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppletMeetingServiceImpl
implements AppletMeetingService {
    private static final Logger log = LoggerFactory.getLogger(AppletMeetingServiceImpl.class);
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private AppletService appletService;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private GoodsOrderService goodsOrderService;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private SettingService settingService;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private AppletQrcodeAPI appletQrcodeAPI;
    @Resource
    private ParamEncryMapper paramEncryMapper;
    @Resource
    private MeetingBjyStudentInfoMapper meetingBjyStudentInfoMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Resource
    private IdGen idGen;
    @Value(value="${scrm.applet.envVersion}")
    private String envVersion;
    private final int size = Runtime.getRuntime().availableProcessors();
    private final ExecutorService threadPool = new ThreadPoolExecutor(this.size, this.size * 2, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1024), (ThreadFactory)new NamedThreadFactory("appletMeetingService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.threadPool);
    }

    @Override
    public GetAppletUrlResp getAppletUrl(GetAppletUrlReq req) {
        String url;
        log.info("getAppletUrl,req:{}", (Object)req);
        req.validate();
        Meeting meeting = this.meetingCacheService.getMeetingByNum(req.getMeetingNum());
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        Long bizId = meeting.getBizId();
        AppletInfo appletInfo = this.appletInfoMapper.selectNewestAppletByBizIdAndStatus(bizId, AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
        Preconditions.checkArgument((appletInfo != null ? 1 : 0) != 0, (Object)"\u672a\u6388\u6743\u5c0f\u7a0b\u5e8f");
        StringBuilder query = new StringBuilder().append("a=").append(req.getMeetingNum()).append("&b=").append(req.getChannelNum()).append("&c=").append(req.getWeworkUserNum()).append("&d=").append(req.getIsPlayback());
        Integer urlType = this.settingService.getIntegerOrDefault(meeting.getBizId(), SystemParamName.MEETING_LIVE_DELIVERY_APPLET_URL_TYPE.getKey(), NumberUtils.INTEGER_ONE);
        if (urlType.equals(NumberUtils.INTEGER_ONE)) {
            GenSchemeReqDto schemeReqDto = new GenSchemeReqDto();
            schemeReqDto.setBizId(bizId);
            JumpWxaReqDto jumpWxaReqDto = new JumpWxaReqDto();
            jumpWxaReqDto.setPath(req.getPath());
            jumpWxaReqDto.setEnvVersion(this.envVersion);
            jumpWxaReqDto.setQuery(query.toString());
            schemeReqDto.setJumpWxaReqDto(jumpWxaReqDto);
            url = this.getSchemeUrl(schemeReqDto, 3);
            log.info("getAppletUrl,schemeReqDto:{},schemeUrl:{}", (Object)schemeReqDto, (Object)url);
        } else {
            GenerateUrlLinkReq urlLinkReq = new GenerateUrlLinkReq();
            urlLinkReq.setPath(req.getPath());
            urlLinkReq.setQuery(query.toString());
            urlLinkReq.setIsExpire(Boolean.valueOf(true));
            urlLinkReq.setExpireType(NumberUtils.INTEGER_ONE);
            urlLinkReq.setEnvVersion(this.envVersion);
            url = this.getLinkUrl(urlLinkReq, appletInfo.getAppId(), 3);
            log.info("getAppletUrl,schemeReqDto:{},linkUrl:{}", (Object)urlLinkReq, (Object)url);
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        GetAppletUrlResp resp = new GetAppletUrlResp();
        resp.setUrl(url);
        return resp;
    }

    private String getLinkUrl(GenerateUrlLinkReq urlLinkReq, String appId, int retryTimes) {
        String linkUrl;
        if (retryTimes <= 0) {
            return null;
        }
        try {
            String accessToken = this.appletAccessTokenService.getAccessToken(appId);
            GenerateUrlLinkResp urlLinkResp = this.appletQrcodeAPI.generateUrlLinkUrl(accessToken, urlLinkReq);
            linkUrl = urlLinkResp.getUrlLink();
        }
        catch (Exception e) {
            log.error("getLinkUrl error,urlLinkReq:{},retryTimes:{}", new Object[]{urlLinkReq, --retryTimes, e});
            return this.getLinkUrl(urlLinkReq, appId, retryTimes);
        }
        return linkUrl;
    }

    private String getSchemeUrl(GenSchemeReqDto schemeReqDto, int retryTimes) {
        String schemeUrl;
        if (retryTimes <= 0) {
            return null;
        }
        try {
            schemeUrl = this.appletService.getSchemeUrl(schemeReqDto);
        }
        catch (Exception e) {
            log.error("getSchemeUrl error,schemeReqDto:{},retryTimes:{}", new Object[]{schemeReqDto, --retryTimes, e});
            return this.getSchemeUrl(schemeReqDto, retryTimes);
        }
        return schemeUrl;
    }

    @Override
    public AppletUserResp doBusinessWhenOpenAppletReport(Long bizId, AppletSessionResp session, OpenAppletReportReq req) {
        String meetingIntoUrl;
        String customerStr;
        log.info("doBusinessWhenOpenAppletReport,bizId:{},session:{},req:{}", new Object[]{bizId, session, req});
        StopWatchDto timer = new StopWatchDto("appletOpenAppletReport", true, log);
        timer.start("selectByMeeting");
        Meeting meeting = this.meetingCacheService.getMeetingByNum(req.getMeetingNum());
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        timer.stop();
        timer.start("queryCustomerDetail");
        String customerNumByType = this.ccCustomerNumService.getCustomerNumByMiniProgram(bizId, req.getAppId(), session.getOpenId(), session.getUnionId());
        CustomerDetailResp customerDetailResp = this.ccCustomerInfoService.queryCustomerDetail(bizId, customerNumByType);
        timer.stop();
        boolean isAuth = false;
        String headImgUrl = null;
        String nickname = null;
        Integer sex = null;
        if (customerDetailResp != null) {
            log.info("doBusinessWhenOpenAppletReport,customerNum:{},customerDetail:{}", (Object)customerNumByType, (Object)customerDetailResp);
            isAuth = StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile1()) || StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile2());
            headImgUrl = customerDetailResp.getAvatar();
            nickname = customerDetailResp.getName();
            sex = customerDetailResp.getGender();
        }
        timer.start("handleCustomerInfoWhenAuthorized");
        MeetingCustomerInfoDto customerInfoDto = null;
        try {
            customerInfoDto = this.meetingUrlCommonService.handleCustomerInfoWhenAuthorized(req.getChannelNum(), req.getWeworkUserNum(), meeting, req.getAppId(), session.getOpenId(), session.getUnionId(), headImgUrl, nickname, sex, MeetingLiveDeliveryAuthMode.APPLET);
        }
        catch (Exception e) {
            log.error("doBusinessWhenOpenAppletReport,handleCustomerInfoWhenAuthorized error", (Throwable)e);
        }
        timer.stop();
        if (customerInfoDto == null) {
            customerStr = this.idGen.getNum();
            if (req.getIsPlayback() != null && NumberUtils.INTEGER_ONE.equals(req.getIsPlayback())) {
                timer.start("buildPlaybackUrlToCommonDomainUrlWhenIsPlayback");
                meetingIntoUrl = this.meetingUrlCommonService.buildPlaybackUrlToCommonDomainUrl(meeting.getBizId(), meeting.getPlaybackUrl(), meeting.getNum(), customerStr, meeting.getRoomId());
                timer.stop();
            } else if (MeetingStatus.FINISHED.getValue() == meeting.getStatus().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
                log.info("doBusinessWhenOpenAppletReport,meetingId:{},\u4f1a\u8bae\u5df2\u7ed3\u675f\u4e14\u751f\u6210\u4e86\u56de\u653e\u5730\u5740", (Object)meeting.getId());
                timer.start("buildPlaybackUrlToCommonDomainUrl");
                meetingIntoUrl = this.meetingUrlCommonService.buildPlaybackUrlToCommonDomainUrl(meeting.getBizId(), meeting.getPlaybackUrl(), meeting.getNum(), customerStr, meeting.getRoomId());
                timer.stop();
            } else {
                meetingIntoUrl = this.meetingUrlCommonService.buildOriginMeetingUrlAndGenCustomerStr(meeting, req.getChannelNum(), req.getWeworkUserNum(), req.getAppId(), session.getOpenId(), session.getUnionId(), customerStr, false, true);
            }
        } else {
            customerStr = customerInfoDto.getCustomerStr();
            if (req.getIsPlayback() != null && NumberUtils.INTEGER_ONE.equals(req.getIsPlayback())) {
                timer.start("buildPlaybackUrlToCommonDomainUrlWhenIsPlayback");
                meetingIntoUrl = this.meetingUrlCommonService.buildPlaybackUrlToCommonDomainUrl(meeting.getBizId(), meeting.getPlaybackUrl(), meeting.getNum(), customerStr, meeting.getRoomId());
                timer.stop();
            } else if (MeetingStatus.FINISHED.getValue() == meeting.getStatus().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
                log.info("doBusinessWhenOpenAppletReport,meetingId:{},\u4f1a\u8bae\u5df2\u7ed3\u675f\u4e14\u751f\u6210\u4e86\u56de\u653e\u5730\u5740", (Object)meeting.getId());
                timer.start("buildPlaybackUrlToCommonDomainUrl");
                meetingIntoUrl = this.meetingUrlCommonService.buildPlaybackUrlToCommonDomainUrl(meeting.getBizId(), meeting.getPlaybackUrl(), meeting.getNum(), customerStr, meeting.getRoomId());
                timer.stop();
            } else {
                timer.start("selectByMeetingSetting");
                MeetingSetting meetingSetting = this.meetingCacheService.getMeetingSetting(bizId);
                timer.stop();
                if (meetingSetting == null) {
                    meetingIntoUrl = meeting.getOriginMeetingUrl();
                } else {
                    Integer isPrivate = meeting.getIsPrivate();
                    if (isAuth && NumberUtils.INTEGER_TWO.equals(isPrivate)) {
                        ArrayList mobiles = Lists.newArrayList();
                        log.info("doBusinessWhenOpenAppletReport,mobile1:{},mobile2:{}", (Object)customerDetailResp.getMobile1(), (Object)customerDetailResp.getMobile2());
                        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile1())) {
                            mobiles.add(customerDetailResp.getMobile1());
                        }
                        if (StringUtils.isNotBlank((CharSequence)customerDetailResp.getMobile2())) {
                            mobiles.add(customerDetailResp.getMobile2());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
                            timer.start("queryExistMobileCount");
                            int existMobileCount = this.meetingBjyStudentInfoMapper.queryExistMobileCount(meeting.getBizId(), meeting.getRoomId(), (Collection)mobiles);
                            log.info("doBusinessWhenOpenAppletReport,\u767d\u540d\u5355\u4f1a\u8bae,existMobileCount:{}", (Object)existMobileCount);
                            if (existMobileCount > 0) {
                                isPrivate = 0;
                            }
                            timer.stop();
                        }
                        timer.start("buildMeetingIntoUrl");
                        meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(customerStr, Long.valueOf(Long.parseLong(meeting.getRoomId())), headImgUrl, nickname, meetingSetting, customerInfoDto.getUserNumber(), meeting.getNum(), isPrivate.intValue());
                        timer.stop();
                    } else {
                        timer.start("buildMeetingIntoUrl");
                        meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(customerStr, Long.valueOf(Long.parseLong(meeting.getRoomId())), headImgUrl, nickname, meetingSetting, customerInfoDto.getUserNumber(), meeting.getNum(), isAuth ? 0 : isPrivate);
                        timer.stop();
                    }
                }
            }
        }
        AppletUserResp resp = new AppletUserResp();
        resp.setIsAuth(isAuth ? 1 : 0);
        resp.setUrl(meetingIntoUrl);
        resp.setMeetingTitle(meeting.getTitle());
        timer.start("selectAppletInfo");
        AppletInfo appletInfo = this.appletInfoMapper.selectNewestAppletByBizIdAndStatus(meeting.getBizId(), AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
        timer.stop();
        boolean appletHaveAvatar = appletInfo != null && StringUtils.isNotBlank((CharSequence)appletInfo.getLogo());
        String avatar = !appletHaveAvatar ? this.businessCustomerMapper.getAvatarById(bizId) : appletInfo.getLogo();
        resp.setAvatar(avatar);
        resp.setCustomerStr(customerStr);
        log.info("doBusinessWhenOpenAppletReport,bizId:{},resp:{}", (Object)bizId, (Object)resp);
        timer.print();
        return resp;
    }

    @Override
    public AuthPhoneReportResp doBusinessWhenAuthPhoneReport(Long bizId, AuthPhoneReportReq req) {
        log.info("doBusinessWhenAuthPhoneReport,bizId:{},req:{}", (Object)bizId, (Object)req);
        StopWatchDto timer = new StopWatchDto("doBusinessWhenAuthPhoneReport", true, log);
        timer.start("selectMeeting");
        Meeting meeting = this.meetingCacheService.getMeetingByNum(req.getMeetingNum());
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        timer.stop();
        AuthPhoneReportResp resp = new AuthPhoneReportResp();
        if (MeetingStatus.FINISHED.getValue() == meeting.getStatus().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
            log.info("doBusinessWhenAuthPhoneReport,meetingId:{},\u4f1a\u8bae\u5df2\u7ed3\u675f\u4e14\u751f\u6210\u4e86\u56de\u653e\u5730\u5740", (Object)meeting.getId());
            timer.start("buildPlaybackUrlToCommonDomainUrl");
            String meetingIntoUrl = this.meetingUrlCommonService.buildPlaybackUrlToCommonDomainUrl(meeting.getBizId(), meeting.getPlaybackUrl(), meeting.getNum(), req.getCustomerStr(), meeting.getRoomId());
            resp.setUrl(meetingIntoUrl);
            timer.stop();
        } else {
            timer.start("selectMeetingSetting");
            MeetingSetting meetingSetting = this.meetingCacheService.getMeetingSetting(bizId);
            timer.stop();
            if (meetingSetting != null) {
                Integer isPrivate = meeting.getIsPrivate();
                log.info("doBusinessWhenAuthPhoneReport,bizId:{},isPrivate:{}", (Object)bizId, (Object)isPrivate);
                if (!NumberUtils.INTEGER_ZERO.equals(isPrivate)) {
                    if (NumberUtils.INTEGER_ONE.equals(isPrivate)) {
                        timer.start("buildMeetingIntoUrlByMobile");
                        String meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(req.getCustomerStr(), Long.valueOf(Long.parseLong(meeting.getRoomId())), null, null, meetingSetting, Long.valueOf(Long.parseLong(req.getPhone())), meeting.getNum(), 0);
                        resp.setUrl(meetingIntoUrl);
                        timer.stop();
                    } else if (NumberUtils.INTEGER_TWO.equals(isPrivate)) {
                        timer.start("mobileIsExist");
                        int count = this.meetingBjyStudentInfoMapper.mobileIsExist(meeting.getRoomId(), meeting.getBizId(), req.getPhone());
                        timer.stop();
                        log.info("doBusinessWhenAuthPhoneReport,bizId:{},mobileIsExist:{}", (Object)bizId, (Object)count);
                        if (count > 0) {
                            timer.start("buildMeetingIntoUrlByWhiteList");
                            String meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(req.getCustomerStr(), Long.valueOf(Long.parseLong(meeting.getRoomId())), null, null, meetingSetting, Long.valueOf(Long.parseLong(req.getPhone())), meeting.getNum(), 0);
                            resp.setUrl(meetingIntoUrl);
                            timer.stop();
                        }
                    }
                } else {
                    timer.start("buildMeetingIntoUrlByDirect");
                    String meetingIntoUrl = this.meetingUrlCommonService.buildMeetingIntoUrl(req.getCustomerStr(), Long.valueOf(Long.parseLong(meeting.getRoomId())), null, null, meetingSetting, Long.valueOf(Long.parseLong(req.getPhone())), meeting.getNum(), 0);
                    resp.setUrl(meetingIntoUrl);
                    timer.stop();
                }
            }
        }
        this.threadPool.submit(() -> {
            MeetingParams meetingParams = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)req.getCustomerStr())) {
                    ParamEncry selectParamEncry = new ParamEncry();
                    selectParamEncry.setNum(req.getCustomerStr());
                    ParamEncry paramEncry = (ParamEncry)this.paramEncryMapper.selectOne((Object)selectParamEncry);
                    if (paramEncry != null) {
                        meetingParams = (MeetingParams)JSON.parseObject((String)paramEncry.getParams(), MeetingParams.class);
                        this.bindMobileAndOpenId(meeting.getBizId(), req.getPhone(), req.getOpenId(), meetingParams.getUnionId(), req.getAppId());
                    }
                }
            }
            catch (Exception e) {
                log.error("doBusinessWhenAuthPhoneReport,bindMobileAndOpenId error", (Throwable)e);
            }
            try {
                this.intoCrmLeads(bizId, req.getPhone(), req.getCustomerStr(), meetingParams);
            }
            catch (Exception e) {
                log.error("doBusinessWhenAuthPhoneReport,bizId:{},intoCrmLeads error", (Object)bizId, (Object)e);
            }
        });
        log.info("doBusinessWhenAuthPhoneReport,bizId:{},resp:{}", (Object)bizId, (Object)resp);
        timer.print();
        return resp;
    }

    private void bindMobileAndOpenId(Long bizId, String mobile, String openId, String unionId, String appId) {
        log.info("bindMobileAndOpenId,bizId:{},mobile:{},openId:{},unionId:{},appId:{}", new Object[]{bizId, mobile, openId, unionId, appId});
        if (bizId == null) {
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mobile, openId, appId})) {
            return;
        }
        boolean bindAppletAccount = this.ccCustomerNumService.mobileBindAppletAccount(bizId, mobile);
        if (bindAppletAccount) {
            log.info("bindMobileAndOpenId,\u624b\u673a\u53f7\u5df2\u7ed1\u5b9a\u5c0f\u7a0b\u5e8f,\u672c\u6b21\u4e0d\u7ed1\u5b9a");
            return;
        }
        this.ccCustomerNumService.bindAppletAccountAndMobile(bizId, appId, openId, mobile, unionId);
    }

    private void intoCrmLeads(Long bizId, String mobile, String customerStr, MeetingParams meetingParams) {
        log.info("intoCrmLeads,bizId:{},mobile:{},customerStr:{},meetingParams:{}", new Object[]{bizId, mobile, customerStr, meetingParams});
        if (!this.openCrm(bizId)) {
            log.info("intoCrmLeads not open crm,bizId:{}", (Object)bizId);
            return;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
        crmLeadsInfoReq.setMobile(mobile);
        crmLeadsInfoReq.setCorpId(businessCustomer.getCorpId());
        boolean exists = this.crmLeadsService.exists(crmLeadsInfoReq);
        log.info("intoCrmLeads exists : {}, mobile: {}", (Object)exists, (Object)mobile);
        if (exists) {
            return;
        }
        JudgeOrderBelongUserIdDto userIdDto = null;
        if (StringUtils.isNotBlank((CharSequence)customerStr)) {
            userIdDto = this.goodsOrderService.judgeOrderBelongUserId(bizId, businessCustomer.getCorpId(), crmLeadsInfoReq.getMobile(), customerStr);
        }
        CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
        crmLeadsReq.setCorpId(businessCustomer.getCorpId());
        crmLeadsReq.setMobile(mobile);
        crmLeadsReq.setSourceType(Integer.valueOf(SourceType.LIVE_COMMERCE.getValue()));
        Long channelId = this.channelMapper.querySysChannelId(SysChannelEnum.LIVE_COMMERCE.getCode());
        if (meetingParams != null && meetingParams.getChannelId() != 0L) {
            channelId = meetingParams.getChannelId();
        }
        crmLeadsReq.setChannelId(channelId);
        if (userIdDto != null) {
            crmLeadsReq.setAllocUserId(userIdDto.getBelongUserId());
        }
        log.info("intoCrmLeads sync crm crmLeadsReq:{}", (Object)crmLeadsReq);
        this.crmLeadsService.addLeads(crmLeadsReq);
    }

    private boolean openCrm(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        log.info("openCrm businessCustomer: {}", (Object)businessCustomer);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GetMeetingLiveDeliveryConfigResp getMeetingLiveDeliveryConfig(GetMeetingLiveDeliveryConfigReq req) {
        log.info("getMeetingLiveDeliveryConfig,req:{}", (Object)req);
        req.validate();
        Meeting meeting = this.meetingCacheService.getMeetingByNum(req.getMeetingNum());
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        GetMeetingLiveDeliveryConfigResp resp = new GetMeetingLiveDeliveryConfigResp();
        resp.setAuthMode(meeting.getLiveDeliveryAuthMode() == null ? MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue() : meeting.getLiveDeliveryAuthMode());
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)meeting.getBizId());
        if (meeting.getLiveDeliveryAuthMode() == null || MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue().equals(meeting.getLiveDeliveryAuthMode())) {
            OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(meeting.getBizId());
            String avatar = officialAccount == null || StringUtils.isBlank((CharSequence)officialAccount.getHeadImg()) ? businessCustomer.getAvatar() : officialAccount.getHeadImg();
            resp.setAvatar(avatar);
            resp.setAppId(officialAccount != null ? officialAccount.getAppId() : "");
        } else {
            AppletInfo appletInfo = this.appletInfoMapper.selectNewestAppletByBizIdAndStatus(meeting.getBizId(), AppletAuthStatus.AUTHORIZED.getStatus(), NumberUtils.INTEGER_ZERO);
            String avatar = appletInfo == null || StringUtils.isBlank((CharSequence)appletInfo.getLogo()) ? businessCustomer.getAvatar() : appletInfo.getLogo();
            resp.setAvatar(avatar);
            resp.setAppId(appletInfo != null ? appletInfo.getAppId() : "");
        }
        log.info("getMeetingLiveDeliveryConfig,resp:{}", (Object)resp);
        return resp;
    }
}

