/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.service.impl;

import com.kuaike.scrm.applet.dto.req.template.SetValidTemplateIdReq;
import com.kuaike.scrm.applet.service.AppletDraftTemplateService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AppletDraftTemplateServiceImpl
implements AppletDraftTemplateService {
    private static final Logger log = LoggerFactory.getLogger(AppletDraftTemplateServiceImpl.class);
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    private static final String CURRENT_VALID_TEMPLATEID_KEY = "shop:currentValidTemplateId:";
    private static final String CURRENT_MARKETING_MATERIAL_VALID_TEMPLATEID_KEY = "shop:currentMarketingMaterialValidTemplateId:";

    @Override
    public String getCurrentValidTemplateId() {
        return (String)this.redisTemplate.opsForValue().get((Object)CURRENT_VALID_TEMPLATEID_KEY);
    }

    @Override
    public void setValidTemplateId(SetValidTemplateIdReq req) {
        log.info("setValidTemplateId req:{}", (Object)req);
        this.redisTemplate.opsForValue().set((Object)CURRENT_VALID_TEMPLATEID_KEY, (Object)req.getTemplateId());
    }

    @Override
    public void setMarketingMaterialValidTemplateId(SetValidTemplateIdReq req) {
        log.info("setCommonValidTemplateId req:{}", (Object)req);
        this.redisTemplate.opsForValue().set((Object)CURRENT_MARKETING_MATERIAL_VALID_TEMPLATEID_KEY, (Object)req.getTemplateId());
    }

    @Override
    public String getMarketingMaterialValidTemplateId() {
        Object data = this.redisTemplate.opsForValue().get((Object)CURRENT_MARKETING_MATERIAL_VALID_TEMPLATEID_KEY);
        if (data == null) {
            return null;
        }
        log.info("getMarketingMaterialValidTemplateId data:{}", data);
        return (String)data;
    }
}

