/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.applet.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.applet.dto.dto.CategoryDto;
import com.kuaike.scrm.utils.HttpHeadUtils;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AppletModReq {
    private String appletName;
    private String license;
    private List<String> otherStuff;
    private String appletDesc;
    private String appletHeadImg;
    private List<CategoryDto> categories;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.license), (Object)"license\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)this.license)) {
            HttpHeadUtils.checkImgAndSize((String)this.license, (String)"license\u683c\u5f0f\u5fc5\u987b\u662fpng,jpg,jpeg,gif", (int)10, (String)"license\u4e0d\u8d85\u8fc710MB");
        }
        if (CollectionUtils.isNotEmpty(this.otherStuff)) {
            for (String s : this.otherStuff) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)s), (Object)"otherStuff\u5143\u7d20\u4e0d\u80fd\u4e3a\u7a7a");
                HttpHeadUtils.checkImgAndSize((String)s, (String)"\u5176\u4ed6\u8bc1\u660e\u6750\u6599\u683c\u5f0f\u5fc5\u987b\u4e3apng,jpg,jpeg,gif", (int)10, (String)"\u5176\u4ed6\u8bc1\u660e\u6750\u6599\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc710MB");
            }
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.appletName), (Object)"appletName\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.appletDesc), (Object)"appletDesc\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.appletHeadImg), (Object)"appletHeadImg\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)this.appletHeadImg)) {
            HttpHeadUtils.checkImgAndSize((String)this.appletHeadImg, (String)"\u5c0f\u7a0b\u5e8f\u5934\u50cf\u683c\u5f0f\u5fc5\u987b\u662fpng,jpg,jpeg,gif,bmp", (int)2, (String)"\u5c0f\u7a0b\u5e8f\u5934\u50cf\u4e0d\u8d85\u8fc72MB");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.categories), (Object)"categories\u4e0d\u80fd\u4e3a\u7a7a");
        for (CategoryDto category : this.categories) {
            category.validate();
        }
    }

    public String getAppletName() {
        return this.appletName;
    }

    public String getLicense() {
        return this.license;
    }

    public List<String> getOtherStuff() {
        return this.otherStuff;
    }

    public String getAppletDesc() {
        return this.appletDesc;
    }

    public String getAppletHeadImg() {
        return this.appletHeadImg;
    }

    public List<CategoryDto> getCategories() {
        return this.categories;
    }

    public void setAppletName(String appletName) {
        this.appletName = appletName;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setOtherStuff(List<String> otherStuff) {
        this.otherStuff = otherStuff;
    }

    public void setAppletDesc(String appletDesc) {
        this.appletDesc = appletDesc;
    }

    public void setAppletHeadImg(String appletHeadImg) {
        this.appletHeadImg = appletHeadImg;
    }

    public void setCategories(List<CategoryDto> categories) {
        this.categories = categories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppletModReq)) {
            return false;
        }
        AppletModReq other = (AppletModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appletName = this.getAppletName();
        String other$appletName = other.getAppletName();
        if (this$appletName == null ? other$appletName != null : !this$appletName.equals(other$appletName)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        List<String> this$otherStuff = this.getOtherStuff();
        List<String> other$otherStuff = other.getOtherStuff();
        if (this$otherStuff == null ? other$otherStuff != null : !((Object)this$otherStuff).equals(other$otherStuff)) {
            return false;
        }
        String this$appletDesc = this.getAppletDesc();
        String other$appletDesc = other.getAppletDesc();
        if (this$appletDesc == null ? other$appletDesc != null : !this$appletDesc.equals(other$appletDesc)) {
            return false;
        }
        String this$appletHeadImg = this.getAppletHeadImg();
        String other$appletHeadImg = other.getAppletHeadImg();
        if (this$appletHeadImg == null ? other$appletHeadImg != null : !this$appletHeadImg.equals(other$appletHeadImg)) {
            return false;
        }
        List<CategoryDto> this$categories = this.getCategories();
        List<CategoryDto> other$categories = other.getCategories();
        return !(this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppletModReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appletName = this.getAppletName();
        result = result * 59 + ($appletName == null ? 43 : $appletName.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        List<String> $otherStuff = this.getOtherStuff();
        result = result * 59 + ($otherStuff == null ? 43 : ((Object)$otherStuff).hashCode());
        String $appletDesc = this.getAppletDesc();
        result = result * 59 + ($appletDesc == null ? 43 : $appletDesc.hashCode());
        String $appletHeadImg = this.getAppletHeadImg();
        result = result * 59 + ($appletHeadImg == null ? 43 : $appletHeadImg.hashCode());
        List<CategoryDto> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        return result;
    }

    public String toString() {
        return "AppletModReq(appletName=" + this.getAppletName() + ", license=" + this.getLicense() + ", otherStuff=" + this.getOtherStuff() + ", appletDesc=" + this.getAppletDesc() + ", appletHeadImg=" + this.getAppletHeadImg() + ", categories=" + this.getCategories() + ")";
    }
}

