/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.app.center.service.impl;

import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.scrm.common.service.AppInstallService;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayInstallServiceImpl
implements AppInstallService {
    private static final Logger log = LoggerFactory.getLogger(PayInstallServiceImpl.class);
    @Value(value="${app.pay.appCode}")
    private String appCode;
    @Value(value="${scrm.init.pay.install}")
    private String installUrl;
    @Value(value="${scrm.init.pay.unInstall}")
    private String unInstallUrl;
    @Value(value="${permission.token}")
    private String token;
    @Autowired
    private BusinessCustomerMapper customerMapper;

    public void install(AppBindings bindings) {
        if (bindings == null) {
            return;
        }
        BusinessCustomer customer = this.customerMapper.getByCorpId(bindings.getCorpId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("corpId", bindings.getCorpId());
        params.put("businessName", customer.getName());
        params.put("token", this.token);
        String paramUrl = this.installUrl;
        try {
            String resultJson = HttpClientUtils.doJsonPost((String)paramUrl, params, (String)StandardCharsets.UTF_8.toString());
            log.info("installPaySystem url: {},  result : {}", (Object)paramUrl, (Object)resultJson);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
    }

    public void uninstall(AppBindings bindings) {
        if (bindings == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("corpId", bindings.getCorpId());
        String paramUrl = this.unInstallUrl;
        try {
            String resultJson = HttpClientUtils.doJsonPost((String)paramUrl, params, (String)StandardCharsets.UTF_8.toString());
            log.info("uninstallPaySystem url: {},  result : {}", (Object)paramUrl, (Object)resultJson);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
    }

    public String getAppCode() {
        return this.appCode;
    }
}

