/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dal.meeting.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@Table(name="meeting_tag")
public class MeetingTag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="num")
    private String num;
    @Column(name="meeting_id")
    private String meetingId;
    @Column(name="tag_id")
    private String tagId;
    @Column(name="type")
    private int type;
    @Column(name="biz_id")
    private long bizId;
    @Column(name="corp_id")
    private String corpId;
    @Column(name="tag_name")
    private String tagName;
    @Column(name="create_time")
    private Date createTime;
    @Column(name="update_time")
    private Date updateTime;
    @Column(name="create_by")
    private String createBy;
    @Column(name="create_by_name")
    private String createByName;
    @Column(name="tag_group_id")
    private String tagGroupId;
    @Column(name="tag_group_name")
    private String tagGroupName;

    public static Collection<TagGroupParams> convertPOToDto(List<MeetingTag> mts) {
        Collection<Object> dtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(mts)) {
            HashMap map = Maps.newHashMap();
            WeworkTagParams wtp = null;
            TagGroupParams tgp = null;
            for (MeetingTag mt : mts) {
                String tagGroupId = mt.getTagGroupId();
                wtp = new WeworkTagParams(mt.getTagId(), mt.getTagName());
                if (map.containsKey(tagGroupId)) {
                    ((TagGroupParams)map.get(tagGroupId)).getWeworkTags().add(wtp);
                    continue;
                }
                tgp = new TagGroupParams(mt.getTagGroupId(), mt.getTagGroupName(), Lists.newArrayList((Object[])new WeworkTagParams[]{wtp}));
                map.put(tagGroupId, tgp);
            }
            if (MapUtils.isNotEmpty((Map)map)) {
                dtos = map.values();
            }
        }
        return dtos;
    }

    public long getId() {
        return this.id;
    }

    public String getNum() {
        return this.num;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public String getTagId() {
        return this.tagId;
    }

    public int getType() {
        return this.type;
    }

    public long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public String getCreateByName() {
        return this.createByName;
    }

    public String getTagGroupId() {
        return this.tagGroupId;
    }

    public String getTagGroupName() {
        return this.tagGroupName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setBizId(long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setCreateByName(String createByName) {
        this.createByName = createByName;
    }

    public void setTagGroupId(String tagGroupId) {
        this.tagGroupId = tagGroupId;
    }

    public void setTagGroupName(String tagGroupName) {
        this.tagGroupName = tagGroupName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingTag)) {
            return false;
        }
        MeetingTag other = (MeetingTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getBizId() != other.getBizId()) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$meetingId = this.getMeetingId();
        String other$meetingId = other.getMeetingId();
        if (this$meetingId == null ? other$meetingId != null : !this$meetingId.equals(other$meetingId)) {
            return false;
        }
        String this$tagId = this.getTagId();
        String other$tagId = other.getTagId();
        if (this$tagId == null ? other$tagId != null : !this$tagId.equals(other$tagId)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$createBy = this.getCreateBy();
        String other$createBy = other.getCreateBy();
        if (this$createBy == null ? other$createBy != null : !this$createBy.equals(other$createBy)) {
            return false;
        }
        String this$createByName = this.getCreateByName();
        String other$createByName = other.getCreateByName();
        if (this$createByName == null ? other$createByName != null : !this$createByName.equals(other$createByName)) {
            return false;
        }
        String this$tagGroupId = this.getTagGroupId();
        String other$tagGroupId = other.getTagGroupId();
        if (this$tagGroupId == null ? other$tagGroupId != null : !this$tagGroupId.equals(other$tagGroupId)) {
            return false;
        }
        String this$tagGroupName = this.getTagGroupName();
        String other$tagGroupName = other.getTagGroupName();
        return !(this$tagGroupName == null ? other$tagGroupName != null : !this$tagGroupName.equals(other$tagGroupName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getType();
        long $bizId = this.getBizId();
        result = result * 59 + (int)($bizId >>> 32 ^ $bizId);
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $meetingId = this.getMeetingId();
        result = result * 59 + ($meetingId == null ? 43 : $meetingId.hashCode());
        String $tagId = this.getTagId();
        result = result * 59 + ($tagId == null ? 43 : $tagId.hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $createBy = this.getCreateBy();
        result = result * 59 + ($createBy == null ? 43 : $createBy.hashCode());
        String $createByName = this.getCreateByName();
        result = result * 59 + ($createByName == null ? 43 : $createByName.hashCode());
        String $tagGroupId = this.getTagGroupId();
        result = result * 59 + ($tagGroupId == null ? 43 : $tagGroupId.hashCode());
        String $tagGroupName = this.getTagGroupName();
        result = result * 59 + ($tagGroupName == null ? 43 : $tagGroupName.hashCode());
        return result;
    }

    public String toString() {
        return "MeetingTag(id=" + this.getId() + ", num=" + this.getNum() + ", meetingId=" + this.getMeetingId() + ", tagId=" + this.getTagId() + ", type=" + this.getType() + ", bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ", tagName=" + this.getTagName() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", createBy=" + this.getCreateBy() + ", createByName=" + this.getCreateByName() + ", tagGroupId=" + this.getTagGroupId() + ", tagGroupName=" + this.getTagGroupName() + ")";
    }
}

