/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dal.weworktag.dto;

import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import java.util.HashSet;
import java.util.List;

public class TagGroupParams {
    private String groupId;
    private String groupName;
    private List<WeworkTagParams> weworkTags;

    public TagGroupParams() {
    }

    public TagGroupParams(String groupId, String groupName, List<WeworkTagParams> weworkTags) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.weworkTags = weworkTags;
    }

    public void checkParams() {
        HashSet tagNames = Sets.newHashSet();
        int total = 0;
        for (WeworkTagParams params : this.weworkTags) {
            if (params.getId() != null && params.getIsDeleted() != null) continue;
            tagNames.add(params.getName().trim());
            ++total;
        }
        if (tagNames.size() != total) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u540d\u91cd\u590d");
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<WeworkTagParams> getWeworkTags() {
        return this.weworkTags;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setWeworkTags(List<WeworkTagParams> weworkTags) {
        this.weworkTags = weworkTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagGroupParams)) {
            return false;
        }
        TagGroupParams other = (TagGroupParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<WeworkTagParams> this$weworkTags = this.getWeworkTags();
        List<WeworkTagParams> other$weworkTags = other.getWeworkTags();
        return !(this$weworkTags == null ? other$weworkTags != null : !((Object)this$weworkTags).equals(other$weworkTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TagGroupParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<WeworkTagParams> $weworkTags = this.getWeworkTags();
        result = result * 59 + ($weworkTags == null ? 43 : ((Object)$weworkTags).hashCode());
        return result;
    }

    public String toString() {
        return "TagGroupParams(groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", weworkTags=" + this.getWeworkTags() + ")";
    }
}

