/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.vip.entity.VipWeworkFile;
import com.kuaike.scrm.vip.dto.QueryMsgCondition;
import com.kuaike.scrm.vip.dto.file.WeworkFileDto;
import com.kuaike.scrm.vip.dto.message.WeworkMessageIndex;
import com.kuaike.scrm.vip.dto.model.Constants;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import com.kuaike.scrm.vip.service.WeworkCommonMessageService;
import com.kuaike.scrm.vip.service.impl.WeworkMessageCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WeworkCommonMessageServiceImpl
implements WeworkCommonMessageService {
    private static final Logger log = LoggerFactory.getLogger(WeworkCommonMessageServiceImpl.class);
    @Value(value="${scrm.vip.elasticsearch.weworkMessage}")
    private String weworkMessageIndex;
    @Value(value="${scrm.vip.elasticsearch.weworkMessageIds:dev_scrm_vip_wework_message_ids}")
    private String weworkMessageIdsIndex;
    private String defaultType = "doc";
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    @Override
    public boolean existsMsgId(String uniqueId) {
        log.info("existsMsgId key:{}", (Object)uniqueId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)uniqueId), (Object)"\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        GetRequest getRequest = new GetRequest(this.weworkMessageIdsIndex, this.defaultType, uniqueId);
        try {
            return this.restHighLevelClient.exists(getRequest, new Header[0]);
        }
        catch (IOException e) {
            log.info("exists uniqueId:{}", (Object)uniqueId, (Object)e);
            return false;
        }
    }

    @Override
    public void insertMsgId(WeworkMessageIndex messageIndex) {
        log.info("insertMsgId index:{}", (Object)JSON.toJSONString((Object)messageIndex));
        messageIndex.validate();
        IndexRequest indexRequest = new IndexRequest(this.weworkMessageIdsIndex, this.defaultType, messageIndex.getUniqueId());
        try {
            indexRequest.source(JSON.toJSONString((Object)messageIndex), XContentType.JSON);
            IndexResponse response = this.restHighLevelClient.index(indexRequest, new Header[0]);
            log.info("res:{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("message:{}, request:{}", new Object[]{messageIndex, indexRequest, e});
        }
    }

    @Override
    public Set<Long> syncFile2Es(List<VipWeworkFile> weworkFileList) {
        HashSet syncIds = Sets.newHashSet();
        BulkRequest bulkRequest = new BulkRequest();
        int bulkSize = 0;
        for (VipWeworkFile vipWeworkFile : weworkFileList) {
            WeworkFileDto weworkFileDto = new WeworkFileDto();
            weworkFileDto.setUniqueId(vipWeworkFile.getUniqueId());
            weworkFileDto.setFileUrl(vipWeworkFile.getFileUrl());
            weworkFileDto.setFileName(vipWeworkFile.getFileName());
            weworkFileDto.setContentType(vipWeworkFile.getContentType().intValue());
            weworkFileDto.setVideoCover(vipWeworkFile.getVideoCover());
            weworkFileDto.setTranscodeFileUrl(vipWeworkFile.getTranscodeFileUrl());
            weworkFileDto.setStatus(1);
            weworkFileDto.initFileTypeStr();
            List<String> ids = this.searchFile(weworkFileDto);
            if (CollectionUtils.isNotEmpty(ids)) {
                for (String id : ids) {
                    UpdateRequest updateRequest = new UpdateRequest(this.weworkMessageIndex, this.defaultType, id);
                    String jsonString = JSON.toJSONString((Object)weworkFileDto);
                    updateRequest.doc(jsonString, XContentType.JSON);
                    bulkRequest.add(updateRequest);
                    ++bulkSize;
                }
                syncIds.add(vipWeworkFile.getId());
                continue;
            }
            log.warn("syncFile2Es error: no search response,uniqueId={}", (Object)weworkFileDto.getUniqueId());
        }
        try {
            if (bulkSize > 0) {
                this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            }
        }
        catch (IOException e) {
            log.error("syncFile2Es error: bulk fail,syncIds={}", (Object)syncIds);
            syncIds.clear();
        }
        return syncIds;
    }

    private List<String> searchFile(WeworkFileDto weworkFileDto) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"fileUrl"));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)weworkFileDto.getUniqueId()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        ArrayList ids = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            ids.add(searchHit.getId());
        }
        return ids;
    }

    @Override
    public WeworkMessage selectByPrimaryKeyFromES(String uniqueId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)uniqueId), (Object)"\u6d88\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"uniqueId.keyword", (String)uniqueId));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits.length > 0) {
            SearchHit searchHit = searchHits[0];
            String sourceAsString = searchHit.getSourceAsString();
            return (WeworkMessage)JSON.parseObject((String)sourceAsString, WeworkMessage.class);
        }
        return null;
    }

    @Override
    public Optional<WeworkMessage> queryAddFriendBeforeMessage(String weworkId, String talkerId, Date createTime, String uniqueId) {
        log.info("querAddFriendMessage params: weworkId:{}, talkerId:{}, createTime:{}", new Object[]{weworkId, talkerId, createTime});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkId), (Object)"weworkId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)talkerId), (Object)"talkerId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(createTime), (Object)"createTime not null");
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"weworkId.keyword", (Object)weworkId)).must((QueryBuilder)QueryBuilders.matchQuery((String)"conId.keyword", (Object)talkerId));
        queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"sendTime").lte((Object)createTime.getTime()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"contentType", (int)1011));
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"uniqueId.keyword", (String)uniqueId));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        searchSourceBuilder.size(1);
        searchSourceBuilder.from(0);
        List messageList = (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            return Optional.empty();
        }
        return Optional.ofNullable(messageList.get(0));
    }

    private Pair<List<WeworkMessage>, Long> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        ArrayList wechatMessageList = Lists.newArrayList();
        if (Objects.isNull(searchResponse)) {
            return new ImmutablePair((Object)wechatMessageList, (Object)0L);
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            WeworkMessage weworkMessage = (WeworkMessage)JSON.parseObject((String)sourceAsString, WeworkMessage.class);
            wechatMessageList.add(weworkMessage);
        });
        return new ImmutablePair((Object)wechatMessageList, (Object)totalHits);
    }

    @Override
    public List<WeworkMessage> selectVipMsgByCondition(WeworkMessageCondition condition) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)condition.getCorpId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"weworkId.keyword", (String)condition.getWeworkId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"conId.keyword", (String)condition.getConId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"conType", (Collection)Lists.newArrayList((Object[])new Integer[]{0, 1})));
        Integer from = 0;
        Integer size = condition.getCount();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        RangeQueryBuilder sendTimeQuery = QueryBuilders.rangeQuery((String)"sendTime");
        boolean needReverse = false;
        if (condition.getDirection().booleanValue()) {
            if (condition.getSendTime() != null) {
                sendTimeQuery.gt((Object)condition.getSendTime().getTime());
                queryBuilder.must((QueryBuilder)sendTimeQuery);
                searchSourceBuilder.sort("sendTime", SortOrder.ASC);
            } else {
                searchSourceBuilder.sort("sendTime", SortOrder.DESC);
                needReverse = true;
            }
        } else {
            if (condition.getSendTime() != null) {
                sendTimeQuery.lt((Object)condition.getSendTime().getTime());
                queryBuilder.must((QueryBuilder)sendTimeQuery);
            }
            searchSourceBuilder.sort("sendTime", SortOrder.DESC);
            needReverse = true;
        }
        searchSourceBuilder.from(from.intValue());
        searchSourceBuilder.size(size.intValue());
        List messages = (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
        log.info("selectVipMsgByCondition, param{} resultSize:{}", (Object)searchRequest.source().toString(), (Object)CollectionUtils.size((Object)messages));
        if (needReverse) {
            Collections.reverse(messages);
        }
        return messages;
    }

    @Override
    public List<WeworkMessage> queryList(String corpId, String weworkId, String query) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)corpId));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"weworkId.keyword", (String)weworkId));
        queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"content", (Object)query));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"conType", (Collection)Lists.newArrayList((Object[])new Integer[]{0, 1})));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"externalFlag", (int)1));
        queryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"conId.keyword", (Collection)Constants.FILTER_OFFICIAL_WEWORK));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.ASC);
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public List<WeworkMessage> queryList(QueryMsgCondition condition) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)condition.getCorpId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"weworkId.keyword", (String)condition.getWeworkId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"conId.keyword", (String)condition.getConId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"conType", (Collection)Lists.newArrayList((Object[])new Integer[]{0, 1})));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"externalFlag", (int)1));
        if (StringUtils.isNotBlank((CharSequence)condition.getQuery())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"content", (Object)condition.getQuery()));
        }
        if (CollectionUtils.isNotEmpty(condition.getContentTypes())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"contentType", condition.getContentTypes()));
        }
        PageDto pageDto = condition.getPageDto();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.ASC);
        if (pageDto != null) {
            Integer from = pageDto.getOffset();
            Integer size = pageDto.getPageSize();
            searchSourceBuilder.size(from.intValue());
            searchSourceBuilder.from(size.intValue());
        }
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public List<WeworkMessage> queryListBySendTime(QueryMsgCondition condition) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)condition.getCorpId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"weworkId.keyword", (String)condition.getWeworkId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"conId.keyword", (String)condition.getConId()));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"conType", (Collection)Lists.newArrayList((Object[])new Integer[]{0, 1})));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        RangeQueryBuilder sendTimeQuery = QueryBuilders.rangeQuery((String)"sendTime");
        queryBuilder.must((QueryBuilder)sendTimeQuery);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (condition.getSearchDirection() == 1) {
            sendTimeQuery.lt((Object)condition.getSendTime());
            searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        } else if (condition.getSearchDirection() == 2) {
            sendTimeQuery.gt((Object)condition.getSendTime());
            searchSourceBuilder.sort("sendTime", SortOrder.ASC);
        }
        searchSourceBuilder.size(condition.getSearchCount().intValue());
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public List<WeworkMessage> queryListByRequestIds(String corpId, Collection<String> requestIds) {
        log.info("queryListByRequestIds: corpId:{}, requestIds:{}", (Object)corpId, requestIds);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)corpId));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"requestId.keyword", requestIds));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(10000);
        return (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
    }

    @Override
    public void updateRevokeByRequestIds(String corpId, Collection<String> requestIds) {
        log.info("updateRevokeByRequestIds: corpId:{}, requestIds:{}", (Object)corpId, requestIds);
        Set<String> uniqueIds = this.queryUniqueIdsByRequestIds(corpId, Lists.newArrayList(requestIds));
        this.updateRevokeByUniqueIds(corpId, uniqueIds);
    }

    private Set<String> queryUniqueIdsByRequestIds(String corpId, Collection<String> requestIds) {
        log.info("queryUniqueIdsByRequestIds: corpId:{}, requestIds:{}", (Object)corpId, requestIds);
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)corpId));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"requestId.keyword", requestIds));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.weworkMessageIndex});
        searchRequest.types(new String[]{"doc"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.size(10000);
        String[] includeFields = new String[]{"uniqueId"};
        String[] excludeFields = new String[]{};
        searchSourceBuilder.fetchSource(includeFields, excludeFields);
        List messageList = (List)this.executeQueryAndDealResult(searchRequest, searchSourceBuilder).getLeft();
        if (CollectionUtils.isEmpty((Collection)messageList)) {
            log.info("queryUniqueIdsByRequestIds: \u6839\u636erequestId\u67e5\u8be2\u4e0d\u5230\u6d88\u606f, corpId:{}, requestId:{}", (Object)corpId, requestIds);
            return Collections.emptySet();
        }
        return messageList.stream().map(WeworkMessage::getUniqueId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private void updateRevokeByUniqueIds(String corpId, Collection<String> uniqueIds) {
        log.info("updateRevokeByUniqueIds: corpId:{}, uniqueIds:{}", (Object)corpId, uniqueIds);
        if (CollectionUtils.isEmpty(uniqueIds)) {
            log.warn("updateRevokeByUniqueIds: uniqueIds is null, corpId:{}, uniqueIds:{}", (Object)corpId, uniqueIds);
            return;
        }
        HashMap<String, Integer> jsonMap = new HashMap<String, Integer>();
        jsonMap.put("isRevoke", NumberUtils.INTEGER_ONE);
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (String uniqueId : uniqueIds) {
            UpdateRequest updateRequest = new UpdateRequest(this.weworkMessageIndex, "doc", uniqueId).doc(jsonMap);
            bulkRequest.add(updateRequest);
        }
        try {
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
            for (BulkItemResponse itemResponse : bulkResponse) {
                if (!itemResponse.isFailed()) continue;
                log.error("updateRevokeByUniqueIds: to es error:{}", (Object)itemResponse.getId(), (Object)itemResponse.getFailure().getCause());
            }
        }
        catch (Exception e) {
            log.error("updateRevokeByUniqueIds: failed, uniqueIds:{}", uniqueIds, (Object)e);
        }
    }
}

