/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.utils.exec;

import com.google.common.collect.Lists;
import com.kuaike.scrm.utils.exec.ITaskJob;
import com.kuaike.scrm.utils.exec.TaskJobRun;
import com.kuaike.scrm.utils.exec.TaskJobType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTaskJob
implements ITaskJob {
    String wechatId;
    Long taskId;
    TaskJobType taskJobType;
    protected AtomicInteger totalSubJob;
    protected List<TaskJobRun> jobRunnableList;

    public AbstractTaskJob(Long taskId, TaskJobType taskJobType, String wechatId, List<TaskJobRun> jobRunnables) {
        this.taskId = taskId;
        this.taskJobType = taskJobType;
        this.wechatId = wechatId;
        this.totalSubJob = new AtomicInteger(jobRunnables.size());
        this.jobRunnableList = jobRunnables;
    }

    public String getWechatId() {
        return this.wechatId;
    }

    public String getId() {
        return StringUtils.join((Iterable)Lists.newArrayList((Object[])new String[]{this.taskJobType.name(), this.taskId.toString(), this.wechatId}), (String)"##");
    }

    public TaskJobType getJobType() {
        return this.taskJobType;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    @Override
    public List<TaskJobRun> subJobList() {
        return this.jobRunnableList;
    }

    public TaskJobType getTaskJobType() {
        return this.taskJobType;
    }

    public AtomicInteger getTotalSubJob() {
        return this.totalSubJob;
    }

    public List<TaskJobRun> getJobRunnableList() {
        return this.jobRunnableList;
    }

    public void setWechatId(String wechatId) {
        this.wechatId = wechatId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setTaskJobType(TaskJobType taskJobType) {
        this.taskJobType = taskJobType;
    }

    public void setTotalSubJob(AtomicInteger totalSubJob) {
        this.totalSubJob = totalSubJob;
    }

    public void setJobRunnableList(List<TaskJobRun> jobRunnableList) {
        this.jobRunnableList = jobRunnableList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTaskJob)) {
            return false;
        }
        AbstractTaskJob other = (AbstractTaskJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$wechatId = this.getWechatId();
        String other$wechatId = other.getWechatId();
        if (this$wechatId == null ? other$wechatId != null : !this$wechatId.equals(other$wechatId)) {
            return false;
        }
        TaskJobType this$taskJobType = this.getTaskJobType();
        TaskJobType other$taskJobType = other.getTaskJobType();
        if (this$taskJobType == null ? other$taskJobType != null : !((Object)((Object)this$taskJobType)).equals((Object)other$taskJobType)) {
            return false;
        }
        AtomicInteger this$totalSubJob = this.getTotalSubJob();
        AtomicInteger other$totalSubJob = other.getTotalSubJob();
        if (this$totalSubJob == null ? other$totalSubJob != null : !this$totalSubJob.equals(other$totalSubJob)) {
            return false;
        }
        List<TaskJobRun> this$jobRunnableList = this.getJobRunnableList();
        List<TaskJobRun> other$jobRunnableList = other.getJobRunnableList();
        return !(this$jobRunnableList == null ? other$jobRunnableList != null : !((Object)this$jobRunnableList).equals(other$jobRunnableList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractTaskJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $wechatId = this.getWechatId();
        result = result * 59 + ($wechatId == null ? 43 : $wechatId.hashCode());
        TaskJobType $taskJobType = this.getTaskJobType();
        result = result * 59 + ($taskJobType == null ? 43 : ((Object)((Object)$taskJobType)).hashCode());
        AtomicInteger $totalSubJob = this.getTotalSubJob();
        result = result * 59 + ($totalSubJob == null ? 43 : $totalSubJob.hashCode());
        List<TaskJobRun> $jobRunnableList = this.getJobRunnableList();
        result = result * 59 + ($jobRunnableList == null ? 43 : ((Object)$jobRunnableList).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractTaskJob(wechatId=" + this.getWechatId() + ", taskId=" + this.getTaskId() + ", taskJobType=" + (Object)((Object)this.getTaskJobType()) + ", totalSubJob=" + this.getTotalSubJob() + ", jobRunnableList=" + this.getJobRunnableList() + ")";
    }
}

