/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.scrm.common.utils.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadTools {
    private static final Logger log = LoggerFactory.getLogger(ThreadTools.class);
    private static final int MIX_THREAD = 32;
    private static final int MAX_THREAD = 32;
    private static final int KEEP_ALIVE_SECONDS = 30;
    private static final int QUEUE_SIZE = 128;

    private ThreadTools() {
    }

    public static void shutdownThreadPoolGracefully(ExecutorService threadPool) {
        if (threadPool == null || threadPool.isTerminated()) {
            return;
        }
        try {
            threadPool.shutdown();
        }
        catch (NullPointerException | SecurityException e) {
            return;
        }
        try {
            if (!threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
                if (!threadPool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.info("\u7ebf\u7a0b\u6c60\u4efb\u52a1\u672a\u6b63\u5e38\u6267\u884c\u7ed3\u675f");
                }
            }
        }
        catch (InterruptedException e) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!threadPool.isTerminated()) {
            try {
                for (int i = 0; i < 1000 && !threadPool.awaitTermination(10L, TimeUnit.MILLISECONDS); ++i) {
                    threadPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                log.error("interrupted with err", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                log.error(e.getMessage());
            }
        }
    }

    public static ExecutorService getMixTaskThreadPool() {
        return MixedTargetThreadPoolLazyHolder.EXECUTOR;
    }

    public static ExecutorService getIoTaskThreadPool() {
        return IoTargetThreadPoolLazyHolder.EXECUTOR;
    }

    private static class IoTargetThreadPoolLazyHolder {
        private static final int MAX = 32;
        private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(32, 32, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(512), new NamedThreadFactory("ioTargetFactory"));

        private IoTargetThreadPoolLazyHolder() {
        }

        static {
            EXECUTOR.allowCoreThreadTimeOut(true);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ThreadTools.shutdownThreadPoolGracefully(EXECUTOR)));
        }
    }

    private static class MixedTargetThreadPoolLazyHolder {
        private static final int MAX = 32;
        private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(32, 32, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new NamedThreadFactory("mixTargetFactory"));

        private MixedTargetThreadPoolLazyHolder() {
        }

        static {
            EXECUTOR.allowCoreThreadTimeOut(true);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ThreadTools.shutdownThreadPoolGracefully(EXECUTOR)));
        }
    }
}

