/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ThreadPoolMonitorUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"threadPoolMonitorLog");
    @Autowired
    private HikariDataSource hikariDataSource;
    private final ScheduledExecutorService threadPoolMonitor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("ThreadPoolMonitor"));
    private static final CopyOnWriteArrayList<ThreadPoolExecutor> TO_PRINT_THREAD_POOLS = new CopyOnWriteArrayList();

    @PostConstruct
    public void print() {
        TO_PRINT_THREAD_POOLS.add((ScheduledThreadPoolExecutor)this.threadPoolMonitor);
        Runnable printTask = () -> {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("\u7ebf\u7a0b\u6c60\u76d1\u63a7:\n| pool status | pool size | active | queued | completed | ThreadFactory\n");
            for (ThreadPoolExecutor executorService : TO_PRINT_THREAD_POOLS) {
                this.printThreadPoolStatus(executorService, buffer);
            }
            this.dataSourcePoolMonitor(buffer);
            log.info("{}", (Object)buffer.toString());
        };
        this.threadPoolMonitor.scheduleWithFixedDelay(printTask, 30L, 30L, TimeUnit.SECONDS);
    }

    private void dataSourcePoolMonitor(StringBuilder buffer) {
        HikariPoolMXBean hikariPoolMXBean = this.hikariDataSource.getHikariPoolMXBean();
        if (hikariPoolMXBean == null) {
            return;
        }
        int activeConnections = hikariPoolMXBean.getActiveConnections();
        int idleConnections = hikariPoolMXBean.getIdleConnections();
        int totalConnections = hikariPoolMXBean.getTotalConnections();
        int threadsAwaitingConnection = hikariPoolMXBean.getThreadsAwaitingConnection();
        buffer.append("Hikari Pool active:").append(activeConnections).append(", idle:").append(idleConnections).append(", total:").append(totalConnections).append(", awaiting:").append(threadsAwaitingConnection);
    }

    private void printThreadPoolStatus(ThreadPoolExecutor tpe, StringBuilder buffer) {
        String namePrefix;
        ThreadFactory threadFactory = tpe.getThreadFactory();
        if (threadFactory instanceof NamedThreadFactory) {
            NamedThreadFactory namedThreadFactory = (NamedThreadFactory)threadFactory;
            namePrefix = namedThreadFactory.getNamePrefix();
        } else {
            namePrefix = "Unknown-" + threadFactory.getClass().getSimpleName();
        }
        if (StringUtils.isBlank((CharSequence)namePrefix)) {
            return;
        }
        String isTerminated = tpe.isTerminated() ? "Terminated" : "Terminating";
        String status = tpe.isShutdown() ? isTerminated : "Running";
        buffer.append(String.format("| %-11s | %9d | %6d | %6d | %9d | %s\n", status, tpe.getPoolSize(), tpe.getActiveCount(), tpe.getQueue().size(), tpe.getCompletedTaskCount(), namePrefix));
    }

    public static void addToMonitor(ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                TO_PRINT_THREAD_POOLS.add((ThreadPoolExecutor)executorService);
            }
        }
        catch (Exception e) {
            log.error("addToMonitor error", (Throwable)e);
        }
    }

    public void addToMonitor2(ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                TO_PRINT_THREAD_POOLS.add((ThreadPoolExecutor)executorService);
            }
        }
        catch (Exception e) {
            log.error("addToMonitor error", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.threadPoolMonitor.shutdown();
        TO_PRINT_THREAD_POOLS.forEach(ThreadPoolExecutor::shutdown);
        TO_PRINT_THREAD_POOLS.clear();
        log.info("monitor destroy success");
    }
}

