/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeHelper {
    private static final Logger log = LoggerFactory.getLogger(QRCodeHelper.class);
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private QRCodeHelper() {
    }

    public static String createQrCode(String url, String path, String fileName, int width, int height) {
        try {
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            File file = new File(path, fileName);
            if (file.exists() || (file.getParentFile().exists() || file.getParentFile().mkdirs()) && file.createNewFile()) {
                QRCodeHelper.writeToFile(bitMatrix, "jpg", file);
                log.info("\u751f\u6210\u4e8c\u7ef4\u7801\u56fe\u7247\uff1a{}", (Object)file);
                return file.toString();
            }
        }
        catch (Exception e) {
            log.error("generate qrCode with error", (Throwable)e);
        }
        return null;
    }

    static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        BufferedImage image = QRCodeHelper.toBufferedImage(matrix);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }
}

