/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;

    private FileUtils() {
    }

    public static File saveFile(MultipartFile multipartFile) {
        String fileName = multipartFile.getOriginalFilename();
        File file = null;
        try {
            long time = System.currentTimeMillis();
            file = FileUtils.newTmpFile(fileName);
            multipartFile.transferTo(file);
            time = System.currentTimeMillis() - time;
            log.info("\u5199\u6587\u4ef6\u8017\u65f6\uff1a{}ms, path:{}, exist:{}, canRead:{}", new Object[]{time, file.getAbsolutePath(), file.exists(), file.canRead()});
            return file;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25 e:{}", (Object)e.getMessage());
            if (file != null && file.exists() && file.delete()) {
                log.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6, file:{}", (Object)file.getAbsolutePath());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static String format(long fileSize) {
        if (fileSize < 1024L) {
            return String.format("%d Bytes", fileSize);
        }
        if (fileSize < 0x100000L) {
            float val = (float)fileSize / 1024.0f;
            return String.format("%.2f KB", Float.valueOf(val));
        }
        if (fileSize < 0x40000000L) {
            float val = (float)(fileSize >> 10) / 1024.0f;
            return String.format("%.2f MB", Float.valueOf(val));
        }
        if (fileSize < 0x10000000000L) {
            float val = (float)(fileSize >> 20) / 1024.0f;
            return String.format("%.2f GB", Float.valueOf(val));
        }
        if (fileSize < 0x4000000000000L) {
            float val = (float)(fileSize >> 30) / 1024.0f;
            return String.format("%.2f TB", Float.valueOf(val));
        }
        float val = (float)(fileSize >> 40) / 1024.0f;
        return String.format("%.2f PB", Float.valueOf(val));
    }

    private static File newTmpFile(String fileName) throws IOException {
        String name = UUID.randomUUID().toString();
        String suffix = FilenameUtils.getExtension((String)fileName);
        suffix = StringUtils.isNotBlank((CharSequence)suffix) ? "." + suffix : ".tmp";
        return File.createTempFile(name, suffix);
    }
}

