/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GroupTypeEnum;
import com.kuaike.scrm.common.service.CommonGroupService;
import com.kuaike.scrm.common.service.dto.GroupDto;
import com.kuaike.scrm.common.service.dto.MoveGroupDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.group.entity.CommonGroup;
import com.kuaike.scrm.dal.group.entity.CommonGroupRel;
import com.kuaike.scrm.dal.group.mapper.CommonGroupMapper;
import com.kuaike.scrm.dal.group.mapper.CommonGroupRelMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonGroupServiceImpl
implements CommonGroupService {
    private static final Logger log = LoggerFactory.getLogger(CommonGroupServiceImpl.class);
    @Autowired
    private CommonGroupMapper commonGroupMapper;
    @Autowired
    private CommonGroupRelMapper commonGroupRelMapper;
    @Autowired
    private IdGen idGen;

    @Override
    @Transactional
    public void add(GroupDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"\u5206\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getType()), (Object)"\u5206\u7ec4\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getName().length() <= 20 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        GroupTypeEnum groupTypeEnum = GroupTypeEnum.get((String)params.getType());
        if (groupTypeEnum == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e1a\u52a1\u7c7b\u578b\u9519\u8bef");
        }
        String groupName = params.getName();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        int nameCount = this.commonGroupMapper.queryGroupNameCount(userInfo.getBizId(), params.getType(), groupName);
        Preconditions.checkArgument((nameCount <= 0 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        Integer maxOrder = this.commonGroupMapper.queryMaxOrder(userInfo.getBizId(), params.getType());
        maxOrder = maxOrder == null ? Integer.valueOf(0) : Integer.valueOf(maxOrder + 1);
        CommonGroup group = new CommonGroup();
        group.setNum(this.idGen.getNum());
        group.setBizId(userInfo.getBizId());
        group.setCreateBy(userInfo.getId());
        group.setUpdateBy(userInfo.getId());
        group.setCreateTime(new Date());
        group.setUpdateTime(new Date());
        group.setIsDeleted(Integer.valueOf(0));
        group.setPid(Long.valueOf(0L));
        group.setName(groupName);
        group.setType(params.getType());
        group.setSeq(maxOrder);
        this.commonGroupMapper.insertSelective((Object)group);
    }

    @Override
    @Transactional
    public void mod(GroupDto params) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getName()), (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getName().length() <= 20 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57");
        CommonGroup group = new CommonGroup();
        group.setBizId(user.getBizId());
        group.setNum(params.getId());
        group = (CommonGroup)this.commonGroupMapper.selectOne((Object)group);
        if (group == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u5206\u7ec4");
        }
        if (group.getName().equals(params.getName())) {
            return;
        }
        int nameCount = this.commonGroupMapper.queryGroupNameCount(group.getBizId(), group.getType(), params.getName());
        Preconditions.checkArgument((nameCount <= 0 ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        group.setName(params.getName());
        group.setUpdateBy(user.getId());
        group.setUpdateTime(new Date());
        this.commonGroupMapper.updateByPrimaryKeySelective((Object)group);
    }

    @Override
    @Transactional
    public void del(GroupDto params) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        CommonGroup group = new CommonGroup();
        group.setNum(params.getId());
        group.setBizId(userInfo.getBizId());
        group = (CommonGroup)this.commonGroupMapper.selectOne((Object)group);
        if (group == null) {
            log.info("group is null groupNum: {}", (Object)params.getId());
            return;
        }
        int count = this.commonGroupRelMapper.queryGroupRelCount(userInfo.getBizId(), params.getId());
        Preconditions.checkArgument((count <= 0 ? 1 : 0) != 0, (Object)"\u8bf7\u5148\u5220\u9664\u5206\u7ec4\u4e0b\u7684\u6570\u636e\u540e\u518d\u5220\u9664\u5206\u7ec4");
        group.setIsDeleted(Integer.valueOf(1));
        group.setUpdateBy(userInfo.getId());
        group.setUpdateTime(new Date());
        this.commonGroupMapper.updateByPrimaryKeySelective((Object)group);
    }

    @Override
    public List<GroupDto> list(GroupDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getType()), (Object)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList result = Lists.newArrayList();
        Long bizId = LoginUtils.getCurrentUserBizId();
        List list = this.commonGroupMapper.queryList(bizId, params.getType(), params.getName());
        if (StringUtils.isBlank((CharSequence)params.getName()) || "\u9ed8\u8ba4\u5206\u7ec4".contains(params.getName())) {
            GroupDto defaultGroup = new GroupDto();
            defaultGroup.setId("default");
            defaultGroup.setType(params.getType());
            defaultGroup.setName("\u9ed8\u8ba4\u5206\u7ec4");
            result.add(defaultGroup);
        }
        for (CommonGroup group : list) {
            GroupDto groupDto = new GroupDto();
            groupDto.setId(group.getNum());
            groupDto.setType(group.getType());
            groupDto.setName(group.getName());
            result.add(groupDto);
        }
        return result;
    }

    @Override
    @Transactional
    public void move(MoveGroupDto params) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)params.getGroupId()), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getFkIds()), (Object)"\u5206\u7ec4\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        CommonGroup group = new CommonGroup();
        group.setBizId(bizId);
        group.setNum(params.getGroupId());
        group = (CommonGroup)this.commonGroupMapper.selectOne((Object)group);
        if (group == null && !"default".equals(params.getGroupId())) {
            log.info("group is null groupNum: {}", (Object)params.getGroupId());
            return;
        }
        this.commonGroupRelMapper.updateGroup(bizId, params.getGroupId(), userId, params.getFkIds());
        List exists = this.commonGroupRelMapper.queryByFkIds(bizId, params.getFkIds());
        ArrayList insertFkIds = Lists.newArrayList((Iterable)CollectionUtils.subtract(params.getFkIds(), (Iterable)exists));
        ArrayList insertList = Lists.newArrayList();
        Date curTime = new Date();
        for (String fkId : insertFkIds) {
            CommonGroupRel groupRel = new CommonGroupRel();
            groupRel.setBizId(bizId);
            groupRel.setGroupNum(params.getGroupId());
            groupRel.setFkKey(fkId);
            groupRel.setCreateBy(userId);
            groupRel.setUpdateBy(userId);
            groupRel.setCreateTime(curTime);
            groupRel.setUpdateTime(curTime);
            insertList.add(groupRel);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.commonGroupRelMapper.batchInsert((Collection)insertList);
        }
    }

    @Override
    public void relGroup(Long bizId, Long userId, String groupNum, String fkId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fkId), (Object)"\u5206\u7ec4\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)groupNum)) {
            groupNum = "default";
        }
        Date curTime = new Date();
        CommonGroupRel existsGroup = this.commonGroupRelMapper.queryGroupByFk(bizId, fkId);
        if (existsGroup == null) {
            CommonGroupRel groupRel = new CommonGroupRel();
            groupRel.setBizId(bizId);
            groupRel.setGroupNum(groupNum);
            groupRel.setFkKey(fkId);
            groupRel.setCreateBy(userId);
            groupRel.setUpdateBy(userId);
            groupRel.setCreateTime(curTime);
            groupRel.setUpdateTime(curTime);
            this.commonGroupRelMapper.insertSelective((Object)groupRel);
        } else if (!existsGroup.getGroupNum().equals(groupNum)) {
            existsGroup.setGroupNum(groupNum);
            existsGroup.setUpdateTime(curTime);
            existsGroup.setUpdateBy(userId);
            this.commonGroupRelMapper.updateByPrimaryKey((Object)existsGroup);
        }
    }

    @Override
    public GroupDto getRelGroup(Long bizId, String fkId) {
        CommonGroup group = this.commonGroupMapper.queryGroupByFk(bizId, fkId);
        GroupDto groupDto = new GroupDto();
        if (group != null) {
            groupDto.setId(group.getNum());
            groupDto.setName(group.getName());
        }
        return groupDto;
    }

    @Override
    public void delRelGroup(Long bizId, String fkId) {
        this.commonGroupRelMapper.delRelByFk(bizId, fkId);
    }
}

