/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.service.NodeService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractNodeService
implements NodeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeService.class);
    public static final Long NODE_KEY_KEY_PERIOD = 1800L;
    private static final Map<String, Map<Long, Node>> NODE_MAP = new ConcurrentHashMap<String, Map<Long, Node>>();
    private static final ConcurrentHashMap<String, String> FLAG_MAP = new ConcurrentHashMap();
    private final Object lock = new Object();
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${spring.redis.key.allNodes}")
    private String cacheKey;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    private Object getRedisValue(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public void setRedisValue(String key, Object value, long timeout) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    protected abstract List<Node> getAllNodeFromDb(Long var1);

    public Set<Long> getPosterityIds(Collection<Long> nodeIds, Long bizId) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptySet();
        }
        Map<Long, Node> nodeMap = this.getNodeMap(bizId);
        HashSet posterityIds = Sets.newHashSetWithExpectedSize((int)128);
        for (Long nodeId : nodeIds) {
            Set posterityIdsTemp = Node.getPosterityIds((Long)nodeId, nodeMap);
            posterityIds.addAll(posterityIdsTemp);
        }
        return posterityIds;
    }

    public Set<Long> getPosterityIds(Long nodeId, Long bizId) {
        Map<Long, Node> nodeMap = this.getNodeMap(bizId);
        return Node.getPosterityIds((Long)nodeId, nodeMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Node> getNodeMap(Long bizId) {
        Map<Long, Node> nodeMap;
        Object object;
        String key = this.redisKeyPrefix + this.cacheKey + bizId;
        String flag = MapUtils.getString(FLAG_MAP, (Object)key, (String)"");
        Object cacheFlag = this.getRedisValue(key);
        if (cacheFlag == null) {
            object = this.lock;
            synchronized (object) {
                log.info("\u521d\u59cb\u5316\u7f13\u5b58\u6807\u5fd7");
                String newFlag = UUID.randomUUID().toString();
                this.setRedisValue(key, newFlag, NODE_KEY_KEY_PERIOD);
                cacheFlag = newFlag;
            }
        }
        if (!flag.equals(cacheFlag)) {
            object = this.lock;
            synchronized (object) {
                flag = String.valueOf(cacheFlag);
                FLAG_MAP.put(key, flag);
                log.info("\u66f4\u65b0\u7f13\u5b58");
                List<Node> nodes = this.getAllNodeFromDb(bizId);
                HashMap nodeMap2 = Maps.newHashMap();
                nodeMap2.putAll(Node.buildNodeMap(nodes));
                NODE_MAP.put(key, nodeMap2);
            }
        }
        if ((nodeMap = NODE_MAP.get(key)) == null) {
            log.error("nodeMap is null, bizId:{}", (Object)bizId);
            nodeMap = new HashMap<Long, Node>();
        }
        return nodeMap;
    }

    public void clearCache(Long bizId) {
        log.info("\u6e05\u7406\u7ec4\u7ec7\u67b6\u6784\u7f13\u5b58");
        String key = this.redisKeyPrefix + this.cacheKey + bizId;
        String newFlag = UUID.randomUUID().toString();
        this.setRedisValue(key, newFlag, NODE_KEY_KEY_PERIOD);
    }
}

