/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.perm.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.permission.entity.Menu;
import com.kuaike.scrm.dal.permission.entity.RoleMenu;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.MenuMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class UserRoleCommonServiceImpl
implements UserRoleCommonService {
    private static final Logger log = LoggerFactory.getLogger(UserRoleCommonServiceImpl.class);
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private RoleMapper roleMapper;

    public Set<Long> getManageNodeIds() {
        Set posterityNodeIds;
        Set manageNodeIds;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        if (Objects.isNull(currentUserInfo)) {
            return Collections.emptySet();
        }
        if (Objects.isNull(currentUserInfo.getUserNodeId()) && Objects.isNull(currentUserInfo.getCurRole())) {
            return Collections.emptySet();
        }
        HashSet nodeIds = Sets.newHashSet();
        if (Objects.nonNull(currentUserInfo.getCurRole()) && CollectionUtils.isNotEmpty((Collection)(manageNodeIds = this.userRoleMapper.queryAllManageNodeIds(currentUserInfo.getBizId(), currentUserInfo.getCurRole().getRoleId(), currentUserInfo.getId())))) {
            nodeIds.addAll(manageNodeIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(posterityNodeIds = this.nodeService.getPosterityIds((Collection)nodeIds, currentUserInfo.getBizId())))) {
            nodeIds.addAll(posterityNodeIds);
        }
        return nodeIds;
    }

    public Set<Long> getManageUserIds() {
        Set<Long> manageNodeIds = this.getManageNodeIds();
        HashSet result = Sets.newHashSet();
        result.add(LoginUtils.getCurrentUser().getId());
        if (CollectionUtils.isEmpty(manageNodeIds)) {
            return result;
        }
        Set userIds = this.userMapper.queryUserIdsByNodeIds(manageNodeIds, Boolean.valueOf(false));
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            result.addAll(userIds);
        }
        return result;
    }

    public Set<Long> getManageUserIdsByUserId(Long userId) {
        Set posterityNodeIds;
        log.info("getManageUserIdsByUserId, userId:{}", (Object)userId);
        HashSet<Long> result = new HashSet<Long>();
        result.add(userId);
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (user == null) {
            log.warn("getManageUserIdsByUserId, user not found, userId:{}", (Object)userId);
            return result;
        }
        Long bizId = user.getBizId();
        Long lastRoleId = this.userRoleMapper.queryLastRoleId(bizId, userId);
        if (lastRoleId == null) {
            log.warn("getManageUserIdsByUserId, lastRoleId not found, userId:{}", (Object)userId);
            return result;
        }
        HashSet nodeIds = Sets.newHashSet();
        Set manageNodeIds = this.userRoleMapper.queryManageNodeIds(bizId, lastRoleId, userId);
        if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
            nodeIds.addAll(manageNodeIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(posterityNodeIds = this.nodeService.getPosterityIds((Collection)nodeIds, bizId)))) {
            nodeIds.addAll(posterityNodeIds);
        }
        if (CollectionUtils.isEmpty((Collection)nodeIds)) {
            log.warn("getManageUserIdsByUserId, nodeIds not found, userId:{}", (Object)userId);
            return result;
        }
        Set userIds = this.userMapper.queryUserIdsByNodeIds((Collection)nodeIds, Boolean.valueOf(false));
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            result.addAll(userIds);
        }
        return result;
    }

    public List<Long> getMenuRoleUserIds(Long bizId, String rootName, String sideTabName, String menuName) {
        log.info("rootName: {}, sideTableName: {}, menu: {}", new Object[]{rootName, sideTabName, menuName});
        Menu root = new Menu();
        root.setName(rootName);
        root.setIsDeleted(Integer.valueOf(0));
        List rootMenus = this.menuMapper.select((Object)root);
        if (CollectionUtils.isEmpty((Collection)rootMenus)) {
            return Lists.newArrayList();
        }
        root = (Menu)rootMenus.get(0);
        Menu sideMenu = new Menu();
        sideMenu.setName(sideTabName);
        sideMenu.setPCode(root.getCode());
        sideMenu.setIsDeleted(Integer.valueOf(0));
        List sideMenus = this.menuMapper.select((Object)sideMenu);
        if (CollectionUtils.isEmpty((Collection)sideMenus)) {
            return Lists.newArrayList();
        }
        sideMenu = (Menu)sideMenus.get(0);
        Menu menu = this.menuMapper.queryMenusByPreCode(sideMenu.getCode(), menuName);
        RoleMenu roleMenu = new RoleMenu();
        roleMenu.setBizId(bizId);
        roleMenu.setMenuCode(menu.getCode());
        roleMenu.setIsDeleted(Integer.valueOf(0));
        List roleMenus = this.roleMenuMapper.select((Object)roleMenu);
        if (CollectionUtils.isEmpty((Collection)roleMenus)) {
            return Lists.newArrayList();
        }
        Set roleIds = roleMenus.stream().map(it -> it.getRoleId()).collect(Collectors.toSet());
        List filterSysRoleIds = this.roleMapper.getFilterSysRole(roleIds);
        if (CollectionUtils.isEmpty((Collection)filterSysRoleIds)) {
            return Lists.newArrayList();
        }
        return this.userRoleMapper.queryUserByRoleIds(bizId, (Collection)filterSysRoleIds);
    }

    public Set<Long> queryManagerUserIds(Long userId) {
        HashSet<Long> result = new HashSet<Long>();
        result.add(userId);
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (user == null) {
            log.warn("user not found, userId:{}", (Object)userId);
            return result;
        }
        Node node = this.nodeService.getNode(user.getNodeId(), user.getBizId());
        if (node == null) {
            log.warn("node not found, nodeId:{}, bizId:{}", (Object)user.getNodeId(), (Object)user.getBizId());
            return result;
        }
        Set manageUserIds = this.userRoleMapper.queryManagerUserIds(user.getBizId(), (Collection)node.getIds());
        if (CollectionUtils.isNotEmpty((Collection)manageUserIds)) {
            manageUserIds.stream().filter(Objects::nonNull).forEach(result::add);
        }
        return result;
    }

    public Set<Long> getZombieIds() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Set ids = this.userMapper.queryUserIdsByIndentifier(currentUserInfo.getBizId(), currentUserInfo.getIdentifier());
        return ids;
    }
}

