/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.vip.service.impl;

import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAliasInfo;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAliasInfoMapper;
import com.kuaike.scrm.vip.dto.GroupMemberInfo;
import com.kuaike.scrm.vip.dto.ReportCommonDto;
import com.kuaike.scrm.vip.service.AliasInfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliasInfoServiceImpl
implements AliasInfoService {
    private static final Logger log = LoggerFactory.getLogger(AliasInfoServiceImpl.class);
    @Autowired
    private VipWeworkAliasInfoMapper wechatAliasInfoMapper;
    private static final int PARTITION_SIZE = 300;

    @Override
    public void memberSyncInternal(Set<GroupMemberInfo> memberInfoSet) {
        long begin = System.currentTimeMillis();
        if (CollectionUtils.isEmpty(memberInfoSet)) {
            return;
        }
        List partitionList = Lists.partition((List)Lists.newArrayList(memberInfoSet), (int)300);
        for (List list : partitionList) {
            List reportAliasIds = list.stream().map(GroupMemberInfo::getWeworkId).collect(Collectors.toList());
            Map currentAliasInfoMap = this.wechatAliasInfoMapper.queryAlias(reportAliasIds).stream().collect(Collectors.toMap(VipWeworkAliasInfo::getWeworkId, Function.identity(), (u, v) -> v));
            ArrayList adds = Lists.newArrayList();
            ArrayList mods = Lists.newArrayList();
            for (GroupMemberInfo memberInfo : list) {
                String wechatId = memberInfo.getWeworkId();
                VipWeworkAliasInfo wechatAliasInfo = (VipWeworkAliasInfo)currentAliasInfoMap.get(wechatId);
                if (Objects.isNull(wechatAliasInfo)) {
                    adds.add(ReportCommonDto.build(memberInfo, wechatId));
                    continue;
                }
                if (!ReportCommonDto.fromMemberInfo(wechatAliasInfo, memberInfo)) continue;
                mods.add(wechatAliasInfo);
            }
            if (CollectionUtils.isNotEmpty((Collection)adds)) {
                Lists.partition((List)adds, (int)300).forEach(subList -> this.wechatAliasInfoMapper.batchInsert(subList.stream().sorted(Comparator.comparing(VipWeworkAliasInfo::getWeworkId)).collect(Collectors.toList())));
                log.info("insert alias info size:{}", (Object)adds.size());
            }
            if (!CollectionUtils.isNotEmpty((Collection)mods)) continue;
            Lists.partition((List)mods, (int)300).forEach(subList -> this.wechatAliasInfoMapper.batchUpdate(subList.stream().sorted(Comparator.comparing(VipWeworkAliasInfo::getId)).collect(Collectors.toList())));
            log.info("update alias info size:{}", (Object)mods.size());
        }
        log.info("memberSyncInternal time:{}", (Object)(System.currentTimeMillis() - begin));
    }
}

