/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String YYYY_MM_DD_EN = "yyyy-MM-dd";
    public static final String YYYY_MM_EN = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS_EN = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_EN = "yyyy-MM-dd HH:mm";
    public static final String YYYYMMDDHHMMSSSSS_EN = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMMSS_EN = "yyyyMMddHHmmss";
    public static final String HH_MM = "HH:mm";
    private static final Map<String, FastDateFormat> DATE_FORMAT_MAP = new ConcurrentHashMap<String, FastDateFormat>();

    private DateUtil() {
        throw new UnsupportedOperationException();
    }

    public static String dateToDateString(Date date, String formatStr) {
        if (formatStr == null) {
            formatStr = YYYY_MM_DD_HH_MM_SS_EN;
        }
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        return df.format(date);
    }

    public static String dateToDateString(Date date) {
        return DateUtil.dateToDateString(date, YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static String getCurTimeString(long time, String format) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD_HH_MM_SS_EN;
        }
        Date date = new Date(time * 1000L);
        return DateUtil.dateToDateString(date, format);
    }

    public static String getCurTimeString(String format) {
        return DateUtil.dateToDateString(new Date(), format);
    }

    public static Date stringTimeToDate(String time, Date date) {
        if (StringUtils.isEmpty((CharSequence)time) || Objects.isNull(date)) {
            return null;
        }
        String fullTime = DateUtil.dateToDateString(date, YYYY_MM_DD_EN) + " " + time;
        return DateUtil.getDate(fullTime, YYYY_MM_DD_HH_MM_EN);
    }

    public static Integer getCurTimeInt() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static FastDateFormat getDateFormat(String formatStr) {
        FastDateFormat df = DATE_FORMAT_MAP.get(formatStr);
        if (df == null) {
            df = FastDateFormat.getInstance((String)formatStr);
            DATE_FORMAT_MAP.put(formatStr, df);
        }
        return df;
    }

    public static Date getDate() {
        return Calendar.getInstance().getTime();
    }

    public static Date getDate(String dateTimeStr) {
        return DateUtil.getDate(dateTimeStr, YYYY_MM_DD_EN);
    }

    public static Date getDate(String dateTimeStr, String formatStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(formatStr);
            return sdf.parse(dateTimeStr);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String getCurDate() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_EN);
    }

    public static String getCurDate(String formatStr) {
        return DateUtil.dateToDateString(new Date(), formatStr);
    }

    public static String getCurDateTime() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static long compareDateSecond(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_EN);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_EN);
        if (d1 != null && d2 != null) {
            return d2.getTime() - d1.getTime();
        }
        throw new IllegalArgumentException();
    }

    public static long compareDateDay(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_EN);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_EN);
        if (d1 != null && d2 != null) {
            long time = d2.getTime() - d1.getTime();
            return time / 86400000L;
        }
        throw new IllegalArgumentException();
    }

    public static Long getTheDateBegin(Date date) {
        return DateUtil.getTheDateBegin(DateUtil.dateToDateString(date, YYYY_MM_DD_EN));
    }

    public static Long getTheDateBegin(String date) {
        Date datetime = DateUtil.getDate(date = date + " 00:00:00", YYYY_MM_DD_HH_MM_SS_EN);
        if (datetime != null) {
            return datetime.getTime();
        }
        return null;
    }

    public static Date getTheDateBeginFromString(String date) {
        date = date + " 00:00:00";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static Long getTheDateEnd(Date date) {
        return DateUtil.getTheDateEnd(DateUtil.dateToDateString(date, YYYY_MM_DD_EN));
    }

    public static Long getTheDateEnd(String date) {
        Date datetime = DateUtil.getDate(date = date + " 23:59:59", YYYY_MM_DD_HH_MM_SS_EN);
        if (datetime != null) {
            return datetime.getTime();
        }
        return null;
    }

    public static Date getTheDateEndFromString(String date) {
        date = date + " 23:59:59";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS_EN);
    }

    public static boolean isTimeBefor(Date nows, Date date) {
        long hous = nows.getTime() - date.getTime();
        return hous > 0L;
    }

    public static int getYear(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(1);
    }

    public static int getMonth(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(2) + 1;
    }

    public static int getDay(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(5);
    }

    public static int getSecond(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(13);
    }

    public static int getQuotByDays(Date date1, Date date2) {
        return (int)((date2.getTime() - date1.getTime()) / 86400000L);
    }

    public static String getDateAddDay(String date, int days) {
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD_EN);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(date));
            cal.add(5, days);
            date = df.format(cal.getTime());
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
            return null;
        }
        return date;
    }

    public static Date getDateAddDay(Date date, int days) {
        Calendar no = Calendar.getInstance();
        no.setTime(date);
        no.add(5, days);
        return no.getTime();
    }

    public static Date getDateAddMin(Date date, int min) {
        Calendar no = Calendar.getInstance();
        no.setTime(date);
        no.add(12, min);
        return no.getTime();
    }

    public static String getNowTime(String format) {
        FastDateFormat df = DateUtil.getDateFormat(format);
        long times = System.currentTimeMillis();
        Date date = new Date(times);
        return df.format(date);
    }

    public static long getTenTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Long getTodayTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static int getTodayOfWeek() {
        Calendar c = Calendar.getInstance();
        int dayOfWeek = c.get(7) - 1;
        if (dayOfWeek == 0) {
            dayOfWeek = 7;
        }
        return dayOfWeek;
    }

    public static Long getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getStartTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 0);
        todayEnd.set(12, 0);
        todayEnd.set(13, 0);
        todayEnd.set(14, 0);
        return todayEnd.getTime().getTime();
    }

    public static Date getTodayEndTime() {
        return new Date(DateUtil.getEndTime());
    }

    public static Date getTodayStartTime() {
        return new Date(DateUtil.getStartTime());
    }

    public static List<Long> betweenDays(Date startTime, Date endTime) {
        ArrayList<Long> times = new ArrayList<Long>();
        times.add(startTime.getTime());
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(startTime);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endTime);
        while (endTime.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            if (!endTime.after(calBegin.getTime())) continue;
            times.add(calBegin.getTime().getTime());
        }
        return times;
    }

    public static List<String> betweenDayStr(String startTime, String endTime) {
        ArrayList<String> times = new ArrayList<String>();
        times.add(DateUtil.dateToDateString(DateUtil.getDate(endTime, YYYY_MM_DD_HH_MM_SS_EN), YYYY_MM_DD_EN));
        Date date1 = DateUtil.getDate(startTime, YYYY_MM_DD_HH_MM_SS_EN);
        Date date2 = DateUtil.getDate(endTime, YYYY_MM_DD_HH_MM_SS_EN);
        if (date1 == null || date2 == null) {
            return times;
        }
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(date1);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date2);
        while (date1.before(calEnd.getTime())) {
            calEnd.add(5, -1);
            if (!date1.before(calEnd.getTime())) continue;
            times.add(DateUtil.dateToDateString(calEnd.getTime(), YYYY_MM_DD_EN));
        }
        return times;
    }

    public static Date getDateBegin(Date date) {
        return new Date(DateUtil.getTheDateBegin(date));
    }

    public static Date getDateEnd(Date date) {
        return new Date(DateUtil.getTheDateEnd(date));
    }

    public static Date getFirstDayOfThisWeek() {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setFirstDayOfWeek(2);
        c.set(7, 2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getFirstDayOfThisMonth() {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date addMonthsToDate(Integer months) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date addMonthsToDate(Date date, Integer months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Long dateToTimestampLong(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime() / 1000L;
    }
}

