/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.SettingEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.req.SettingReqDto;
import com.kuaike.scrm.common.service.dto.resp.SettingRespDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.Setting;
import com.kuaike.scrm.dal.system.mapper.SettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    @Resource
    private SettingMapper settingMapper;

    public boolean getMobileEncrypt(Long bizId) {
        return this.getBoolean(bizId, SettingEnum.MOBILE_ENCRYPT.getName());
    }

    public void validate(String paramName, String paramValue) {
        Preconditions.checkArgument((boolean)Objects.nonNull(paramName), (Object)"\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(paramValue), (Object)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        SettingEnum settingEnum = SettingEnum.getEnum((String)paramName);
        if (Objects.isNull(settingEnum)) {
            return;
        }
        if (settingEnum == SettingEnum.MOBILE_ENCRYPT) {
            Preconditions.checkArgument((Long.parseLong(paramValue) == 0L || Long.parseLong(paramValue) == 1L ? 1 : 0) != 0, (Object)"\u53c2\u6570\u503c\u4e0d\u5408\u6cd5");
        }
    }

    public SettingRespDto modSetting(SettingReqDto reqDto) {
        CurrentUserInfo info = LoginUtils.getCurrentUser();
        log.info("mod setting  bizId = #{}, and user = #{}", (Object)info.getBizId(), (Object)info.getId());
        if (Objects.isNull(reqDto)) {
            log.error("param is null");
            return null;
        }
        this.validate(reqDto.getParamName(), reqDto.getParamValue());
        SettingEnum settingEnum = SettingEnum.getEnum((String)reqDto.getParamName());
        if (settingEnum.equals((Object)SettingEnum.UNKNOWN)) {
            log.error("paramName is error");
            return null;
        }
        Setting setting = null;
        if (settingEnum.equals((Object)SettingEnum.REFUND_REASON)) {
            setting = this.settingMapper.getSettingByValue(reqDto.getParamName(), info.getBizId(), reqDto.getParamValue());
            if (Objects.nonNull(setting)) {
                if (Objects.isNull(reqDto.getId())) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u9000\u6b3e\u539f\u56e0\u5df2\u5b58\u5728");
                }
                if (!reqDto.getId().equals(setting.getId())) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u9000\u6b3e\u539f\u56e0\u5df2\u5b58\u5728");
                }
            }
        } else if (settingEnum.equals((Object)SettingEnum.REFUND_WAY)) {
            setting = this.settingMapper.getSettingByValue(reqDto.getParamName(), info.getBizId(), reqDto.getParamValue());
            if (Objects.nonNull(setting)) {
                return null;
            }
        } else {
            setting = this.settingMapper.getSetting(reqDto.getParamName(), info.getBizId());
        }
        if (Objects.isNull(setting)) {
            setting = new Setting();
            setting.setParamName(reqDto.getParamName());
            setting.setParamValue(reqDto.getParamValue());
            setting.setType(Long.valueOf(settingEnum.getId()));
            setting.setDescription(settingEnum.getDesc());
            setting.setBizId(info.getBizId());
            setting.setCorpId(info.getCorpId());
            setting.setCreateBy(info.getId());
            setting.setCreateTime(new Date());
            setting.setUpdateTime(new Date());
            this.settingMapper.insertSelective((Object)setting);
        } else {
            Setting update = new Setting();
            update.setId(setting.getId());
            update.setParamName(reqDto.getParamName());
            update.setParamValue(reqDto.getParamValue());
            update.setUpdateBy(info.getId());
            update.setUpdateTime(new Date());
            Integer isDel = YnEnum.YES.getValue().equals(reqDto.getStatus()) ? YnEnum.NO.getValue() : YnEnum.YES.getValue();
            update.setIsDeleted(isDel);
            this.settingMapper.updateByPrimaryKeySelective((Object)update);
        }
        SettingRespDto respDto = new SettingRespDto();
        respDto.setBizId(info.getBizId());
        respDto.setSettingId(setting.getId());
        respDto.setParamName(reqDto.getParamName());
        respDto.setParamValue(reqDto.getParamValue());
        return respDto;
    }

    public List<SettingRespDto> getSettingList(Long bizId, String value, Integer type) {
        Page settings = PageHelper.startPage((int)1, (int)20, (String)"update_time desc").doSelectPage(() -> this.settingMapper.getListByValue(bizId, type, value));
        if (CollectionUtils.isNotEmpty((Collection)settings)) {
            return settings.stream().map(set -> {
                SettingRespDto respDto = new SettingRespDto();
                respDto.setSettingId(set.getId());
                Integer status = set.getIsDeleted() == 0 ? YnEnum.YES.getValue() : YnEnum.NO.getValue();
                respDto.setStatus(status);
                respDto.setParamName(set.getParamName());
                respDto.setParamValue(set.getParamValue());
                return respDto;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public List<SettingRespDto> settingDetails(SettingEnum settingEnum) {
        CurrentUserInfo info = LoginUtils.getCurrentUser();
        log.info("settingDetails  bizId = #{}, and user = #{}", (Object)info.getBizId(), (Object)info.getId());
        List settings = this.settingMapper.getList(info.getBizId(), Integer.valueOf(settingEnum.getId()));
        ArrayList respDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)settings)) {
            for (Setting set : settings) {
                SettingRespDto respDto = new SettingRespDto();
                respDto.setSettingId(set.getId());
                Integer status = set.getIsDeleted() == 0 ? YnEnum.YES.getValue() : YnEnum.NO.getValue();
                respDto.setStatus(status);
                respDto.setParamName(set.getParamName());
                respDto.setParamValue(set.getParamValue());
                respDtos.add(respDto);
            }
        }
        return respDtos;
    }

    public String getSettingDetail(Long bizId, String settingType) {
        Setting setting = this.settingMapper.getSetting(settingType, bizId);
        if (setting == null) {
            return null;
        }
        return setting.getParamValue();
    }

    public String getString(Long bizId, String paramName) {
        return this.getStringOrDefault(bizId, paramName, null);
    }

    public String getStringOrDefault(Long bizId, String paramName, String defaultValue) {
        Setting setting = this.settingMapper.getSetting(paramName, bizId);
        if (setting == null) {
            return defaultValue;
        }
        return setting.getParamValue();
    }

    public Boolean getBoolean(Long bizId, String paramName) {
        return this.getBooleanOrDefault(bizId, paramName, false);
    }

    public Boolean getBooleanOrDefault(Long bizId, String paramName, Boolean defaultValue) {
        String paramValue = this.getString(bizId, paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return defaultValue;
        }
        return "1".equals(paramValue);
    }

    public Long getLong(Long bizId, String paramName) {
        return this.getLongOrDefault(bizId, paramName, 0L);
    }

    public Long getLongOrDefault(Long bizId, String paramName, Long defaultValue) {
        String paramValue = this.getString(bizId, paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return defaultValue;
        }
        return Long.parseLong(paramValue);
    }

    public Integer getInteger(Long bizId, String paramName) {
        return this.getIntegerOrDefault(bizId, paramName, 0);
    }

    public Integer getIntegerOrDefault(Long bizId, String paramName, Integer defaultValue) {
        String paramValue = this.getString(bizId, paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return defaultValue;
        }
        return Integer.parseInt(paramValue);
    }

    public Double getDouble(Long bizId, String paramName) {
        return this.getDoubleOrDefault(bizId, paramName, 0.0);
    }

    public Double getDoubleOrDefault(Long bizId, String paramName, Double defaultValue) {
        String paramValue = this.getString(bizId, paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return defaultValue;
        }
        return Double.parseDouble(paramValue);
    }

    public Float getFloat(Long bizId, String paramName) {
        return this.getFloatOrDefault(bizId, paramName, Float.valueOf(0.0f));
    }

    public Float getFloatOrDefault(Long bizId, String paramName, Float defaultValue) {
        String paramValue = this.getString(bizId, paramName);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(paramValue));
    }
}

