/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.SettingCustomerDetailService;
import com.kuaike.scrm.common.service.dto.req.SettingCustomerConfigDto;
import com.kuaike.scrm.common.service.dto.req.SettingCustomerDetailDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.SettingCustomerDetail;
import com.kuaike.scrm.dal.system.mapper.SettingCustomerDetailMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SettingCustomerDetailServiceImpl
implements SettingCustomerDetailService {
    private static final Logger log = LoggerFactory.getLogger(SettingCustomerDetailServiceImpl.class);
    @Resource
    private SettingCustomerDetailMapper settingCustomerDetailMapper;
    @Resource
    IdGen idGen;
    @Resource
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    @Override
    public List<SettingCustomerDetailDto> getCustomerDetail(SettingCustomerDetailDto dto, Integer fillUserOrDepName) {
        dto.validate();
        SettingCustomerDetail queryParam = this.buildQueryParam(dto);
        List customerDetailList = this.settingCustomerDetailMapper.select((Object)queryParam);
        return this.fillUserOrDepName(customerDetailList, LoginUtils.getCurrentUserCorpId(), fillUserOrDepName);
    }

    @Override
    public void butchModCustomerDetail(SettingCustomerConfigDto configDto) {
        List customerDetailList = this.settingCustomerDetailMapper.queryByBizAndSettingId(configDto.getBizId(), configDto.getSettingId());
        List<SettingCustomerDetailDto> needUpdateDetails = configDto.getDtos();
        List<SettingCustomerDetail> toDel = this.buildToDel(customerDetailList, needUpdateDetails);
        List<SettingCustomerDetailDto> toAdd = this.buildToAdd(customerDetailList, needUpdateDetails);
        this.butchAdd(toAdd);
        this.butchDel(toDel);
    }

    private void butchAdd(List<SettingCustomerDetailDto> toAdd) {
        if (CollectionUtils.isEmpty(toAdd)) {
            return;
        }
        for (SettingCustomerDetailDto detailDto : toAdd) {
            this.addCustomerDetail(detailDto);
        }
    }

    public void butchDel(List<SettingCustomerDetail> toDel) {
        if (CollectionUtils.isEmpty(toDel)) {
            return;
        }
        List toDelIds = toDel.stream().filter(Objects::nonNull).map(SettingCustomerDetail::getId).collect(Collectors.toList());
        this.settingCustomerDetailMapper.batchDel(toDelIds);
    }

    @Override
    public void addCustomerDetail(SettingCustomerDetailDto dto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        SettingCustomerDetail entity = this.buildEntity(dto, currentUser);
        this.settingCustomerDetailMapper.insert((Object)entity);
    }

    private SettingCustomerDetail buildEntity(SettingCustomerDetailDto dto, CurrentUserInfo userInfo) {
        SettingCustomerDetail entity = new SettingCustomerDetail();
        entity.setCreateBy(userInfo.getId());
        entity.setUpdateBy(userInfo.getId());
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        entity.setNum(this.idGen.getNum());
        entity.setSettingId(dto.getSettingId());
        entity.setIsDeleted(YnEnum.NO.getValue());
        entity.setType(Integer.valueOf(dto.getSettingEnum().getId()));
        entity.setWeworkUserNum(dto.getWeworkUserNum());
        entity.setWeworkDepartmentId(dto.getWeworkDepartmentId());
        entity.setBizId(userInfo.getBizId());
        return entity;
    }

    private SettingCustomerDetail buildQueryParam(SettingCustomerDetailDto dto) {
        SettingCustomerDetail queryParam = new SettingCustomerDetail();
        queryParam.setBizId(dto.getBizId());
        if (Objects.nonNull(dto.getSettingId())) {
            queryParam.setSettingId(dto.getSettingId());
        }
        if (Objects.nonNull(dto.getSettingEnum())) {
            queryParam.setType(Integer.valueOf(dto.getSettingEnum().getId()));
        }
        return queryParam;
    }

    private List<SettingCustomerDetailDto> fillUserOrDepName(List<SettingCustomerDetail> entitys, String corpId, Integer fillUserOrDepName) {
        Map depNameMaps = null;
        Map weworkUserNames = null;
        if (YnEnum.YES.getValue().equals(fillUserOrDepName)) {
            List depIds = entitys.stream().filter(item -> Objects.nonNull(item.getWeworkDepartmentId())).map(item -> item.getWeworkDepartmentId().intValue()).collect(Collectors.toList());
            List wewrokUserNums = entitys.stream().map(SettingCustomerDetail::getWeworkUserNum).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(depIds)) {
                List weworkDepartments = this.weworkDepartmentMapper.queryDeptNames(corpId, depIds);
                depNameMaps = weworkDepartments.stream().collect(Collectors.toMap(WeworkDepartment::getDepartmentId, Function.identity()));
            }
            if (CollectionUtils.isNotEmpty(wewrokUserNums)) {
                weworkUserNames = this.weworkUserMapper.queryWeworkUserNameMapByNums(corpId, wewrokUserNums);
            }
        }
        ArrayList result = Lists.newArrayList();
        for (SettingCustomerDetail entity : entitys) {
            SettingCustomerDetailDto dto = new SettingCustomerDetailDto();
            BeanUtils.copyProperties((Object)entity, (Object)((Object)dto));
            if (StringUtils.isNotBlank((CharSequence)entity.getWeworkUserNum())) {
                String userName = MapUtils.isEmpty(weworkUserNames) ? null : (String)weworkUserNames.get(entity.getWeworkUserNum());
                dto.setWeworkUserName(userName);
            }
            if (Objects.nonNull(entity.getWeworkDepartmentId())) {
                WeworkDepartment weworkDepartment = MapUtils.isEmpty(depNameMaps) ? null : (WeworkDepartment)depNameMaps.get(entity.getWeworkDepartmentId().intValue());
                dto.setWeworkDepartmentName(Objects.nonNull(weworkDepartment) ? weworkDepartment.getName() : null);
            }
            result.add(dto);
        }
        return result;
    }

    private List<SettingCustomerDetail> buildToDel(List<SettingCustomerDetail> customerDetailList, List<SettingCustomerDetailDto> needUpdateDetails) {
        if (CollectionUtils.isEmpty(needUpdateDetails)) {
            return customerDetailList;
        }
        Map<Long, List<SettingCustomerDetailDto>> groupByDepId = needUpdateDetails.stream().filter(item -> Objects.nonNull(item.getWeworkDepartmentId())).collect(Collectors.groupingBy(SettingCustomerDetail::getWeworkDepartmentId));
        Map<String, List<SettingCustomerDetailDto>> groupByUserNum = needUpdateDetails.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkUserNum())).collect(Collectors.groupingBy(SettingCustomerDetail::getWeworkUserNum));
        ArrayList toDel = Lists.newArrayList();
        for (SettingCustomerDetail detail : customerDetailList) {
            String weworkUserNum = detail.getWeworkUserNum();
            if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && CollectionUtils.isEmpty((Collection)groupByUserNum.get(weworkUserNum))) {
                toDel.add(detail);
            }
            Long depId = detail.getWeworkDepartmentId();
            if (!Objects.nonNull(detail.getWeworkDepartmentId()) || !CollectionUtils.isEmpty((Collection)groupByDepId.get(depId))) continue;
            toDel.add(detail);
        }
        return toDel;
    }

    public List<SettingCustomerDetailDto> buildToAdd(List<SettingCustomerDetail> customerDetailList, List<SettingCustomerDetailDto> needUpdateDetails) {
        if (CollectionUtils.isEmpty(customerDetailList)) {
            return needUpdateDetails;
        }
        Map<Long, List<SettingCustomerDetail>> groupByExistDepId = customerDetailList.stream().filter(item -> Objects.nonNull(item.getWeworkDepartmentId())).collect(Collectors.groupingBy(SettingCustomerDetail::getWeworkDepartmentId));
        Map<String, List<SettingCustomerDetail>> groupByExistUserNum = customerDetailList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkUserNum())).collect(Collectors.groupingBy(SettingCustomerDetail::getWeworkUserNum));
        ArrayList toAdd = Lists.newArrayList();
        for (SettingCustomerDetailDto needUpdateDetail : needUpdateDetails) {
            String weworkUserNum = needUpdateDetail.getWeworkUserNum();
            Long depId = needUpdateDetail.getWeworkDepartmentId();
            if (StringUtils.isNotBlank((CharSequence)weworkUserNum) && CollectionUtils.isEmpty((Collection)groupByExistUserNum.get(weworkUserNum))) {
                toAdd.add(needUpdateDetail);
            }
            if (!Objects.nonNull(depId) || !CollectionUtils.isEmpty((Collection)groupByExistDepId.get(depId))) continue;
            toAdd.add(needUpdateDetail);
        }
        return toAdd;
    }
}

