/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.service.AbstractNodeService;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class NodeServiceImpl
extends AbstractNodeService {
    private static final Logger log = LoggerFactory.getLogger(NodeServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;

    @Override
    protected List<Node> getAllNodeFromDb(Long bizId) {
        ArrayList result = Lists.newArrayList();
        List orgList = this.organizationMapper.findAll(bizId);
        for (Organization org : orgList) {
            result.add(this.from(org));
        }
        return result;
    }

    private Node from(Organization org) {
        Node node = new Node();
        node.setId(org.getId().longValue());
        node.setNum(org.getNum());
        node.setCode(org.getOrgCode());
        node.setName(org.getName());
        node.setPid(org.getPid());
        node.setIsDel(org.getIsDeleted().intValue());
        return node;
    }

    public Long getIdByNum(Long bizId, String num) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return null;
        }
        if (num == null || num.isEmpty()) {
            log.warn("invalid num:{}", (Object)num);
            return null;
        }
        return this.organizationMapper.getIdByNum(bizId, num);
    }

    public String getNumById(Long bizId, Long id) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return null;
        }
        if (id == null || id < 0L) {
            log.warn("invalid id:{}", (Object)id);
            return null;
        }
        return this.organizationMapper.getNumById(bizId, id);
    }

    public Map<String, Long> getIdByNums(Long bizId, Collection<String> nums) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(nums)) {
            log.warn("node nums is empty");
            return Collections.emptyMap();
        }
        return this.organizationMapper.getIdByNums(bizId, nums);
    }

    public Map<Long, String> getNumByIds(Long bizId, Collection<Long> ids) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("node ids is empty");
            return Collections.emptyMap();
        }
        return this.organizationMapper.getNumByIds(bizId, ids);
    }

    public Map<Long, String> getFullNameByIds(Long bizId, Collection<Long> ids) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("node ids is empty");
            return Collections.emptyMap();
        }
        Map<Long, Node> nodeMap = this.getNodeMap(bizId);
        if (nodeMap == null || nodeMap.isEmpty()) {
            log.warn("node map is empty");
            return Collections.emptyMap();
        }
        HashMap nodeNameMap = Maps.newHashMap();
        for (Long id : ids) {
            Node node = nodeMap.get(id);
            if (node == null) continue;
            nodeNameMap.put(id, node.getFullName());
        }
        return nodeNameMap;
    }

    public Map<Long, String> getNameByIds(Long bizId, Collection<Long> ids) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("node ids is empty");
            return Collections.emptyMap();
        }
        Map<Long, Node> nodeMap = this.getNodeMap(bizId);
        if (nodeMap == null || nodeMap.isEmpty()) {
            log.warn("node map is empty");
            return Collections.emptyMap();
        }
        HashMap nodeNameMap = Maps.newHashMap();
        for (Long id : ids) {
            Node node = nodeMap.get(id);
            if (node == null) continue;
            nodeNameMap.put(id, node.getName());
        }
        return nodeNameMap;
    }

    public Node getNode(Long nodeId, Long bizId) {
        Map<Long, Node> id2NodeMap = this.getNodeMap(bizId);
        if (MapUtils.isNotEmpty(id2NodeMap)) {
            return Node.getNodeWithoutChildren((Long)nodeId, id2NodeMap);
        }
        return null;
    }

    public Map<Long, String> getOrgCodeByIds(Long bizId, Collection<Long> ids) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("node ids is empty");
            return Collections.emptyMap();
        }
        return this.organizationMapper.getOrgCodeByIds(bizId, ids);
    }

    public String getOrgNameById(Long bizId, Long orgId) {
        return this.organizationMapper.getNameByBizIdAndOrgId(bizId, orgId);
    }

    public Long getRootNodeId(Long bizId) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return null;
        }
        Long nodeId = this.organizationMapper.selectRootNodeIdByBizId(bizId);
        if (nodeId == null) {
            log.warn("root nodeId not found, bizId={}", (Object)bizId);
        }
        return nodeId;
    }

    public Node getRootNode(Long bizId) {
        if (bizId == null || bizId < 0L) {
            log.warn("invalid bizId:{}", (Object)bizId);
            return null;
        }
        Long nodeId = this.organizationMapper.selectRootNodeIdByBizId(bizId);
        if (nodeId == null) {
            log.warn("root nodeId not found, bizId={}", (Object)bizId);
            return null;
        }
        return this.getNode(nodeId, bizId);
    }

    public Map<Long, Node> getNodeByIds(Collection<Long> nodeIds, Long bizId) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            return Collections.emptyMap();
        }
        Map<Long, Node> id2NodeMap = this.getNodeMap(bizId);
        if (MapUtils.isEmpty(id2NodeMap)) {
            return Collections.emptyMap();
        }
        HashMap nodeMap = Maps.newHashMap();
        for (Long nodeId : nodeIds) {
            if (!id2NodeMap.containsKey(nodeId) || nodeMap.containsKey(nodeId)) continue;
            nodeMap.put(nodeId, Node.getNodeWithoutChildren((Long)nodeId, id2NodeMap));
        }
        return nodeMap;
    }
}

