/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.service.CustomerDetailSupportService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.ScrmLeadsDto;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerDetailSupportServiceImpl
implements CustomerDetailSupportService {
    private static final Logger log = LoggerFactory.getLogger(CustomerDetailSupportServiceImpl.class);
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;

    /*
     * WARNING - void declaration
     */
    public void setCustomerDetailParams(Long bizId, List<String> mobiles, List<? extends Object> list) {
        void var18_21;
        Map<Object, Object> customerDetailMap;
        log.info("CustomerDetailSupport setCustomerDetailParams, bizId:{}, mobiles:{}", (Object)bizId, mobiles);
        Map<Object, Object> mobileMap = Maps.newHashMap();
        Map<Object, Object> mobile1Map = Maps.newHashMap();
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        if (CollectionUtils.isEmpty(mobiles) || biz.getIsOpenCrm() == 0 || CollectionUtils.isEmpty(list)) {
            return;
        }
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setCorpId(biz.getCorpId());
        req.setMobiles(mobiles);
        List leadsList = this.crmLeadsService.getLeadsList(req);
        Map map = Maps.newHashMap();
        try {
            map = this.ccCustomerNumService.batchGetCustomerNumByMobile(bizId, mobiles);
            List respList = this.ccCustomerDetailService.queryCustomerDetails(bizId, map.values());
            customerDetailMap = respList.stream().collect(Collectors.toMap(CustomerDetailResp::getCustomerNum, Function.identity(), (k, v) -> k));
        }
        catch (Exception e) {
            log.error("queryCustomerDetails error", (Throwable)e);
            customerDetailMap = Maps.newHashMap();
        }
        if (!CollectionUtils.isEmpty((Collection)leadsList)) {
            mobileMap = leadsList.stream().collect(Collectors.toMap(CrmLeadsInfoResp::getMobile, Function.identity(), (k, v) -> k));
            mobile1Map = leadsList.stream().filter(item -> !StringUtils.isEmpty((Object)item.getMobile1())).collect(Collectors.toMap(CrmLeadsInfoResp::getMobile1, Function.identity(), (k, v) -> k));
        }
        Class<?> aClass = list.get(0).getClass();
        Class<?> superclass = aClass.getSuperclass();
        Object[] superclassDeclaredFields = superclass.getDeclaredFields();
        log.info("CustomerDetailSupport setCustomerDetailParams, super declaredFields:{}", superclassDeclaredFields);
        Object[] declaredFields = aClass.getDeclaredFields();
        log.info("CustomerDetailSupport setCustomerDetailParams, declaredFields:{}", declaredFields);
        boolean inSuper = false;
        Object[] objectArray = superclassDeclaredFields;
        int n = objectArray.length;
        boolean bl = false;
        while (var18_21 < n) {
            Object field = objectArray[var18_21];
            if (((Field)field).getName().equals("crmCustomerName")) {
                inSuper = true;
                break;
            }
            ++var18_21;
        }
        Class<?> finalClass = superclass;
        if (!inSuper) {
            finalClass = aClass;
        }
        for (Object object : list) {
            try {
                Field phone = finalClass.getDeclaredField("phone");
                Field crmCustomerName = finalClass.getDeclaredField("crmCustomerName");
                Field customerNum = finalClass.getDeclaredField("customerNum");
                Field leadsNum = finalClass.getDeclaredField("leadsNum");
                Field productLineNum = finalClass.getDeclaredField("productLineNum");
                phone.setAccessible(true);
                crmCustomerName.setAccessible(true);
                customerNum.setAccessible(true);
                leadsNum.setAccessible(true);
                productLineNum.setAccessible(true);
                CrmLeadsInfoResp crmLeadsInfoResp = mobileMap.containsKey(phone.get(object)) ? (CrmLeadsInfoResp)mobileMap.getOrDefault(phone.get(object), new CrmLeadsInfoResp()) : mobile1Map.getOrDefault(phone.get(object), new CrmLeadsInfoResp());
                if (crmLeadsInfoResp == null) {
                    crmLeadsInfoResp = new CrmLeadsInfoResp();
                } else if (StringUtils.isEmpty((Object)crmLeadsInfoResp.getCustomerNum())) {
                    crmLeadsInfoResp.setCustomerNum((String)map.get(phone.get(object)));
                }
                phone.set(object, "");
                if (MapUtils.isEmpty((Map)customerDetailMap)) {
                    crmCustomerName.set(object, crmLeadsInfoResp.getName());
                } else {
                    crmCustomerName.set(object, customerDetailMap.getOrDefault(crmLeadsInfoResp.getCustomerNum(), new CustomerDetailResp()).getName());
                }
                customerNum.set(object, crmLeadsInfoResp.getCustomerNum());
                leadsNum.set(object, crmLeadsInfoResp.getNum());
                productLineNum.set(object, crmLeadsInfoResp.getProductLineNum());
            }
            catch (NoSuchFieldException e) {
                log.error("no such field with error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c7b\u7f3a\u5c11\u7ee7\u627f");
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException with error", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
            }
        }
    }

    public List<ScrmLeadsDto> leadsDtoList(Long bizId, List<String> mobiles) {
        Map<Object, Object> customerDetailMap;
        log.info("CustomerDetailSupport leadsDtoList, bizId:{}, mobiles:{}", (Object)bizId, mobiles);
        HashMap customerMap = Maps.newHashMap();
        BizSimpleDto biz = this.scrmBizService.getById(bizId);
        if (CollectionUtils.isEmpty(mobiles) || biz.getIsOpenCrm() == 0) {
            return Collections.emptyList();
        }
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setMobiles(mobiles);
        req.setCorpId(biz.getCorpId());
        List leadsList = this.crmLeadsService.getLeadsList(req);
        if (CollectionUtils.isEmpty((Collection)leadsList)) {
            return Collections.emptyList();
        }
        Map map = Maps.newHashMap();
        try {
            map = this.ccCustomerNumService.batchGetCustomerNumByMobile(bizId, mobiles);
            List respList = this.ccCustomerDetailService.queryCustomerDetails(bizId, map.values());
            customerDetailMap = respList.stream().collect(Collectors.toMap(CustomerDetailResp::getCustomerNum, Function.identity(), (k, v) -> k));
        }
        catch (Exception e) {
            customerDetailMap = Maps.newHashMap();
            log.error("queryCustomerDetails error", (Throwable)e);
        }
        Map mobile1Map = leadsList.stream().collect(Collectors.toMap(CrmLeadsInfoResp::getMobile1, Function.identity(), (k, v) -> k));
        Map mobileMap = leadsList.stream().collect(Collectors.toMap(CrmLeadsInfoResp::getMobile, Function.identity(), (k, v) -> k));
        customerMap.putAll(mobile1Map);
        customerMap.putAll(mobileMap);
        ArrayList leadsDtoList = Lists.newArrayList();
        for (String mobile : mobiles) {
            CrmLeadsInfoResp crmLeadsInfoResp = customerMap.getOrDefault(mobile, new CrmLeadsInfoResp());
            if (crmLeadsInfoResp == null) {
                crmLeadsInfoResp = new CrmLeadsInfoResp();
            }
            ScrmLeadsDto scrmLeadsDto = new ScrmLeadsDto();
            scrmLeadsDto.setPhone(mobile);
            if (crmLeadsInfoResp != null && StringUtils.isEmpty((Object)crmLeadsInfoResp.getCustomerNum())) {
                crmLeadsInfoResp.setCustomerNum((String)map.get(mobile));
            }
            scrmLeadsDto.setCustomerNum(crmLeadsInfoResp.getCustomerNum());
            scrmLeadsDto.setLeadsNum(crmLeadsInfoResp.getNum());
            scrmLeadsDto.setProductLineNum(crmLeadsInfoResp.getProductLineNum());
            if (MapUtils.isEmpty((Map)customerDetailMap)) {
                scrmLeadsDto.setCrmCustomerName(crmLeadsInfoResp.getName());
            } else {
                scrmLeadsDto.setCrmCustomerName(customerDetailMap.getOrDefault(crmLeadsInfoResp.getCustomerNum(), new CustomerDetailResp()).getName());
            }
            leadsDtoList.add(scrmLeadsDto);
        }
        return leadsDtoList;
    }
}

