/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.component;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class LockServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(LockServiceSupport.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean locked(String msgKey, long sec) {
        String lockKey = this.redisKeyPrefix + msgKey;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", sec, TimeUnit.SECONDS);
            log.info("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msgKey={}", (Object)msgKey, (Object)e);
            return false;
        }
    }

    public boolean lockUntilAcquire(String msgKey, long sec) {
        while (!this.locked(msgKey, sec)) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public void unlock(String msgKey) {
        String lockKey = this.redisKeyPrefix + msgKey;
        try {
            this.redisTemplate.delete((Object)lockKey);
            log.info("unlock key={}", (Object)lockKey);
        }
        catch (Exception e) {
            log.error("Failed unlock msgKey={}", (Object)msgKey, (Object)e);
        }
    }
}

