/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.transaction;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class TransactionAdaptor {
    private static final Logger log = LoggerFactory.getLogger(TransactionAdaptor.class);
    private TaskExecutor taskExecutor;

    public <T> void waitTransactionFinish(final T param, final Consumer<T> consumer, final boolean isAsync) {
        if (consumer == null) {
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    super.afterCommit();
                    TransactionAdaptor.this.execute(param, consumer, isAsync);
                }
            });
        } else {
            this.execute(param, consumer, isAsync);
        }
    }

    private <T> void execute(T param, Consumer<T> consumer, boolean isAsync) {
        try {
            if (isAsync) {
                this.taskExecutor.execute(() -> consumer.accept(param));
            } else {
                consumer.accept(param);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u65b9\u6cd5\uff1a{} \u62a5\u9519\uff1a", (Object)consumer.toString(), (Object)e);
        }
    }
}

