/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);

    private SignUtil() {
    }

    public static String formatUrlMap(Map<String, Object> paramsMap, boolean urlEncode, boolean keyToLower) {
        String buff = "";
        try {
            ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(paramsMap.entrySet());
            infoIds.sort(Map.Entry.comparingByKey());
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
                String key = (String)entry.getKey();
                String value = entry.getValue().toString();
                if (urlEncode) {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                if (keyToLower) {
                    buf.append(key.toLowerCase()).append("=").append(value);
                } else {
                    buf.append(key).append("=").append(value);
                }
                buf.append("&");
            }
            buff = buf.toString();
            if (StringUtils.isNotEmpty((CharSequence)buff)) {
                buff = buff.substring(0, buff.length() - 1);
            }
        }
        catch (Exception e) {
            log.error("formatUrlMap error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        return buff;
    }
}

