/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.util.Objects;

public final class PriceUtils {
    private PriceUtils() {
    }

    public static String priceToStr(Long price, Integer scale) {
        if (Objects.isNull(price) || Objects.isNull(scale)) {
            return String.valueOf(0);
        }
        if (price == 0L || scale == 0) {
            return String.valueOf(price);
        }
        if (price < 0L) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("\u4fdd\u7559\u7684\u4f4d\u6570\u4e0d\u80fd\u4e3a\u4e3a\u8d1f\u6570");
        }
        float divisor = PriceUtils.getDivisor(scale);
        Float realPrice = Float.valueOf((float)price.longValue() / divisor);
        return String.valueOf(realPrice);
    }

    private static float getDivisor(Integer scale) {
        float base;
        float result = base = 10.0f;
        for (int i = 1; i < scale; ++i) {
            result *= base;
        }
        return result;
    }
}

