/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.scrm.common.dto.NodeInfo;
import com.kuaike.scrm.common.enums.OrgTypeEnum;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.GetUserInfoListByPageResp;
import com.kuaike.scrm.common.service.dto.resp.OrgRespDto;
import com.kuaike.scrm.common.service.dto.resp.UserSimpleInfo;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.contactanalyse.mapper.WeworkContactLogMapper;
import com.kuaike.scrm.dal.official.base.dto.UserQueryParam;
import com.kuaike.scrm.dal.permission.dto.UserQueryParams;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="scrmUserService")
public class ScrmUserServiceImpl
implements ScrmUserService {
    private static final Logger log = LoggerFactory.getLogger(ScrmUserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkContactLogMapper weworkContactLogMapper;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;

    public Map<Long, String> getNameByIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("user ids \u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        List users = this.userMapper.getUserInfoByIds(ids);
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.warn("\u6839\u636euser ids:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", ids);
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMap();
        for (User user : users) {
            map.put(user.getId(), user.getName());
        }
        return map;
    }

    public List<Long> getIdsByNums(Long bizId, Collection<String> nums) {
        if (CollectionUtils.isEmpty(nums) || Objects.isNull(bizId)) {
            log.warn("user nums \u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        return this.userMapper.queryUserIdsByNums(bizId, nums);
    }

    public Map<String, Long> getIdByNums(Long bizId, Collection<String> nums) {
        log.info("getIdByNums,bizId:{},nums:{}", (Object)bizId, nums);
        if (CollectionUtils.isEmpty(nums) || bizId == null) {
            return Collections.emptyMap();
        }
        return this.userMapper.selectIdByNums(bizId, nums);
    }

    public Long getIdByNum(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            log.warn("user num is blank");
            return null;
        }
        return this.userMapper.getIdByNum(num);
    }

    public String getNumById(Long id) {
        if (id == null) {
            log.warn("user id is null");
            return null;
        }
        return this.userMapper.getNumById(id);
    }

    public UserSimpleInfo getById(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)id);
        if (user == null) {
            log.warn("user not found, id={}", (Object)id);
            return null;
        }
        return this.newUserSimpleInfo(user);
    }

    public List<UserSimpleInfo> getUserInfoByIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            log.warn("user ids \u4e3a\u7a7a");
            return Collections.emptyList();
        }
        List users = this.userMapper.getUserInfoByIds(ids);
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.warn("\u6839\u636euser ids:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", ids);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (User user : users) {
            result.add(this.newUserSimpleInfo(user));
        }
        return result;
    }

    public List<UserSimpleInfo> getUserInfoAndFullNodeInfoByIds(Long bizId, Collection<Long> ids) {
        log.info("getUserInfoAndFullNodeInfoByIds,bizId:{},ids:{}", (Object)bizId, ids);
        if (bizId == null || CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        UserQueryParam param = new UserQueryParam();
        param.setIds(ids);
        List users = this.userMapper.queryList(param);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Collections.emptyList();
        }
        return this.buildUserInfoListWithFullNodes(bizId, users);
    }

    private void getAllNode(List<NodeInfo> nodes, Map<Long, Node> nodeMap, Long nodeId, Long mainOrgId) {
        if (nodeMap.isEmpty() || !nodeMap.containsKey(nodeId)) {
            return;
        }
        NodeInfo nodeInfo = new NodeInfo();
        nodes.add(nodeInfo);
        Node node = nodeMap.get(nodeId);
        nodeInfo.setId(Long.valueOf(node.getId()));
        nodeInfo.setName(node.getName());
        nodeInfo.setPid(node.getPid());
        nodeInfo.setIsMainNode(Boolean.valueOf(nodeId.equals(mainOrgId)));
        this.getAllNode(nodes, nodeMap, node.getPid(), mainOrgId);
    }

    public List<UserSimpleInfo> getUserInfoByNums(Collection<String> nums) {
        if (CollectionUtils.isEmpty(nums)) {
            log.warn("user nums \u4e3a\u7a7a");
            return Collections.emptyList();
        }
        List users = this.userMapper.getUserInfoByNums(nums);
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.warn("\u6839\u636euser nums:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", nums);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (User user : users) {
            result.add(this.newUserSimpleInfo(user));
        }
        return result;
    }

    public Set<Long> queryIdsByNodeIds(Collection<Long> nodeIds) {
        if (CollectionUtils.isEmpty(nodeIds)) {
            log.warn("node ids \u4e3a\u7a7a");
            return Collections.emptySet();
        }
        return this.userMapper.queryUserIdsByNodeIds(nodeIds, Boolean.valueOf(false));
    }

    public Integer getUserRoleOrgType(Long roleId) {
        return this.roleMapper.selectOrgTypeByRoleId(roleId);
    }

    public Long getIdByIdentifier(Long bizId, String identifier) {
        if (bizId == null || bizId < 1L) {
            log.warn("bizId is null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)identifier)) {
            log.warn("identifier is blank");
            return null;
        }
        return this.userMapper.getIdByIdentifier(bizId, identifier);
    }

    public Map<String, Long> getIdByIdentifiers(Long bizId, Collection<String> identifiers) {
        if (bizId == null || bizId < 1L) {
            log.warn("bizId is null");
            return Collections.emptyMap();
        }
        if (CollectionUtils.isEmpty(identifiers)) {
            log.warn("identifiers is empty");
            return Collections.emptyMap();
        }
        return this.userMapper.getIdByIdentifiers(bizId, identifiers);
    }

    public UserSimpleInfo getUserInfoByIdentifier(Long bizId, String identifier) {
        if (bizId == null || bizId < 1L) {
            log.warn("bizId is null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)identifier)) {
            log.warn("identifier is blank");
            return null;
        }
        User user = this.userMapper.getUserInfoByIdentifier(bizId, identifier);
        if (user == null) {
            log.warn("user not found, bizId={}, identifier={}", (Object)bizId, (Object)identifier);
            return null;
        }
        return this.newUserSimpleInfo(user);
    }

    public List<UserSimpleInfo> getUserInfoByIdentifiers(Long bizId, Collection<String> identifiers) {
        if (bizId == null || bizId < 1L) {
            log.warn("bizId is null");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(identifiers)) {
            log.warn("identifiers is empty");
            return Collections.emptyList();
        }
        List users = this.userMapper.getUserInfoByIdentifiers(bizId, identifiers);
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.warn("\u6839\u636euser identifiers:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", identifiers);
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)users.size());
        for (User user : users) {
            result.add(this.newUserSimpleInfo(user));
        }
        return result;
    }

    private UserSimpleInfo newUserSimpleInfo(User user) {
        if (user == null) {
            return null;
        }
        UserSimpleInfo dto = new UserSimpleInfo();
        dto.setId(user.getId());
        dto.setNum(user.getNum());
        dto.setName(user.getName());
        dto.setNodeId(user.getNodeId());
        dto.setWeworkUserId(user.getWeworkUserId());
        dto.setIdentifier(user.getIdentifier());
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)user.getNodeId());
        if (organization != null) {
            dto.setNodeName(organization.getName());
        }
        return dto;
    }

    public String getWeworkUserIdByUserId(Long userId) {
        if (userId == null) {
            log.warn("userId \u4e3a\u7a7a");
            return null;
        }
        return this.userMapper.getWeworkUserIdByUserId(userId);
    }

    public Map<Long, String> getUserIdWeworkUserIdMap(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            log.warn("userIds \u4e3a\u7a7a");
            return Collections.emptyMap();
        }
        return this.userMapper.queryUserAndWeworkUserMap(userIds);
    }

    public String getWeworkUserNumByUserId(Long userId) {
        if (userId == null) {
            log.warn("userId \u4e3a\u7a7a");
            return null;
        }
        return this.userMapper.getWeworkUserNumByUserId(userId);
    }

    public OrgRespDto getBelongSchoolOrHeadOffice(Long userId) {
        log.info("getBelongSchoolOrHeadOffice,userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (Objects.isNull(user)) {
            log.warn("\u6839\u636euserId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userId);
            return null;
        }
        Long nodeId = user.getNodeId();
        if (Objects.isNull(nodeId)) {
            log.warn("\u7528\u6237userId:{}\u6240\u5c5e\u90e8\u95e8id\u4e3a\u7a7a", (Object)nodeId);
            return null;
        }
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)nodeId);
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636enodeId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)nodeId);
            return null;
        }
        Integer orgType = organization.getOrgType();
        Organization pOrg = null;
        Long pid = organization.getPid();
        while (!Objects.equals(OrgTypeEnum.BRANCH_SCHOOL.getValue(), orgType) && !Objects.isNull(pOrg = this.organizationMapper.selectByCorpIdAndId(organization.getCorpId(), pid))) {
            orgType = pOrg.getOrgType();
            pid = pOrg.getPid();
        }
        if (Objects.nonNull(pOrg)) {
            organization = pOrg;
        }
        OrgRespDto orgRespDto = new OrgRespDto();
        orgRespDto.setId(organization.getId());
        orgRespDto.setName(organization.getName());
        orgRespDto.setOrgType(organization.getOrgType());
        return orgRespDto;
    }

    public Set<String> getWeworkUserIdsByUserIdAndRoleName(String corpId, Long userId, String roleName) {
        Long bizId;
        log.info("getWeworkUserIdsByUserIdAndRoleName,corpId:{}, userId:{}, roleName:{}", new Object[]{corpId, userId, roleName});
        OrgRespDto orgRespDto = this.getBelongSchoolOrHeadOffice(userId);
        log.info("userId:{}, orgRespDto:{}", (Object)userId, (Object)orgRespDto);
        if (Objects.isNull(orgRespDto)) {
            return Collections.emptySet();
        }
        Long orgId = orgRespDto.getId();
        Set posterityNodeIds = this.nodeService.getPosterityIds(orgId, bizId = this.businessCustomerMapper.getBizId(corpId));
        if (CollectionUtils.isEmpty((Collection)posterityNodeIds)) {
            log.warn("\u6839\u636ebizId:{},orgId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)bizId, (Object)orgId);
            return Collections.emptySet();
        }
        Set userIds = this.userMapper.queryUserIdsByNodeIds((Collection)posterityNodeIds, Boolean.valueOf(false));
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Collections.emptySet();
        }
        Long roleId = this.roleMapper.getSystemRoleIdByCorpIdAndRoleName(corpId, roleName);
        if (Objects.isNull(roleId)) {
            log.warn("\u6839\u636ecorpId:{}, roleName:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)roleName);
            return Collections.emptySet();
        }
        Set roleUserIds = this.userRoleMapper.selectUserIdsByRoleIdAndBizId(roleId, bizId);
        if (CollectionUtils.isEmpty((Collection)roleUserIds)) {
            log.warn("\u6839\u636ebizId:{},roleId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)bizId, (Object)roleId);
            return Collections.emptySet();
        }
        userIds.retainAll(roleUserIds);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            log.warn("userIds\u4e0eroleUserIds\u6ca1\u6709\u4ea4\u96c6");
            return Collections.emptySet();
        }
        return this.userMapper.queryWeworkUserIdByCorpIdAndUserIds(corpId, (Collection)userIds);
    }

    public Map<String, List<String>> getWeworkUserIdsByRoleName(String corpId, Set<String> roleNames) {
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(roleNames)) {
            return Maps.newHashMap();
        }
        return this.userRoleMapper.selectWeworkUserIdByRoleNames(corpId, roleNames);
    }

    public Map<String, List<String>> getRoleNameWeworkUserIdsByUserIdAndRoleNames(String corpId, Long userId, Set<String> roleNames) {
        if (StringUtils.isEmpty((CharSequence)corpId) || Objects.isNull(userId) || CollectionUtils.isEmpty(roleNames)) {
            return Maps.newHashMap();
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (Objects.isNull(user)) {
            log.info("\u6839\u636e\u7528\u6237id:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userId);
            return Maps.newHashMap();
        }
        if (Objects.isNull(user.getNodeId())) {
            log.info("\u7528\u6237id:{}\u6240\u5c5e\u90e8\u95e8\u4e3a\u7a7a", (Object)userId);
            return Maps.newHashMap();
        }
        return this.userRoleMapper.selectWeworkUserIdByRoleNamesAndNodeId(corpId, roleNames, user.getNodeId());
    }

    public UserSimpleInfo getUserInfoByWeworkUserNum(Long bizId, String weworkUserNum) {
        if (bizId == null || bizId < 1L) {
            log.warn("bizId is null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserNum)) {
            log.warn("weworkUserNum is blank");
            return null;
        }
        User user = this.userMapper.getUserInfoByWeworkUserNum(bizId, weworkUserNum);
        if (user == null) {
            log.warn("user not found, bizId={}, weworkUserNum={}", (Object)bizId, (Object)weworkUserNum);
            return null;
        }
        return this.newUserSimpleInfo(user);
    }

    public Long getUserIdByWeworkUserId(Long bizId, String weworkUserId) {
        if (bizId == null || bizId < 1L) {
            log.warn("getUserIdByWeworkUserId: bizId is null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)weworkUserId)) {
            log.warn("getUserIdByWeworkUserId:weworkUserId is blank");
            return null;
        }
        return this.userMapper.getUserIdByWeworkUserId(bizId, weworkUserId);
    }

    public Map<Long, List<String>> queryUserQyNewContact(Long bizId, List<Long> userIds, Date addFriendStart, Date addFriendEnd) {
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        Map userIdMap = this.userMapper.queryUserAndWeworkUserMap(userIds);
        ArrayList weworkUserIds = Lists.newArrayList(userIdMap.values());
        Map weworkContactMap = this.weworkContactRelationMapper.queryWeworkUserContactMap(corpId, (Collection)weworkUserIds, addFriendStart, addFriendEnd);
        for (Map.Entry entry : weworkContactMap.entrySet()) {
            List contactIds = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)contactIds)) continue;
            Map contactCountMap = this.weworkContactLogMapper.queryContactLogCountMap(corpId, (Collection)contactIds);
            for (Map.Entry contactEntry : contactCountMap.entrySet()) {
                if (contactEntry.getValue() == null || (Integer)contactEntry.getValue() <= 1) continue;
                contactIds.remove(contactEntry.getKey());
            }
        }
        HashMap result = Maps.newHashMap();
        for (Long userId : userIds) {
            String weworkUserId = (String)userIdMap.get(userId);
            if (!StringUtils.isNotEmpty((CharSequence)weworkUserId)) continue;
            result.put(userId, weworkContactMap.get(weworkUserId));
        }
        return result;
    }

    public Long getUserIdByMobile(Long bizId, String mobile) {
        log.info("getUserIdByMobile bizId:{},mobile:{}", (Object)bizId, (Object)mobile);
        if (bizId == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return null;
        }
        return this.userMapper.queryUserIdByMobile(bizId, mobile);
    }

    public List<String> getContactAddUser(Long bizId, String contactId) {
        Preconditions.checkArgument((bizId != null && StringUtils.isNotBlank((CharSequence)contactId) ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String corpId = this.businessCustomerMapper.getCorpIdById(bizId);
        List list = this.weworkContactRelationMapper.queryValidWeworkUserIds(corpId, contactId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public Map<String, Long> getUserIdByName(Long bizId, List<String> names) {
        if (bizId == null || CollectionUtils.isEmpty(names)) {
            return Collections.emptyMap();
        }
        return this.userMapper.selectIdByNames(bizId, names);
    }

    public GetUserInfoListByPageResp getUserInfoListByPage(long bizId, int pageNum, int pageSize, Collection<Long> notInIds) {
        log.info("getUserInfoListByPage,bizId:{},pageNum:{},pageSize:{},notInIds:{}", new Object[]{bizId, pageNum, pageSize, notInIds});
        GetUserInfoListByPageResp resp = new GetUserInfoListByPageResp();
        resp.setList(Collections.emptyList());
        resp.setTotal(0);
        UserQueryParams params = new UserQueryParams();
        params.setBizId(Long.valueOf(bizId));
        params.setNotInUserIds(notInIds);
        params.setNeedPermissionControl(Boolean.valueOf(false));
        Integer count = this.userMapper.getCountByQueryParams(params);
        if (count == null || NumberUtils.INTEGER_ZERO.equals(count)) {
            return resp;
        }
        resp.setTotal(count.intValue());
        params.setOffset(Integer.valueOf((pageNum - 1) * pageSize));
        params.setPageSize(Integer.valueOf(pageSize));
        List users = this.userMapper.queryUserByQueryParams(params);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return resp;
        }
        resp.setList(this.buildUserInfoListWithFullNodes(bizId, users));
        return resp;
    }

    private List<UserSimpleInfo> buildUserInfoListWithFullNodes(Long bizId, List<User> users) {
        List weworkDepartmentUsers;
        Map nodeMap = this.nodeService.getNodeMap(bizId);
        Set weworkUserIds = users.stream().map(User::getWeworkUserId).collect(Collectors.toSet());
        HashMap<String, Set> weworkUserIdNodeMap = new HashMap<String, Set>();
        Map orgIdAndWeworkUserIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(weworkUserIds) && CollectionUtils.isNotEmpty((Collection)(weworkDepartmentUsers = this.weworkDepartmentUserMapper.selectByBizIdAndWeworkUserIds(bizId, weworkUserIds)))) {
            HashSet<Integer> weworkDeptIds = new HashSet<Integer>();
            for (WeworkDepartmentUser weworkDepartmentUser : weworkDepartmentUsers) {
                String weworkUserId = weworkDepartmentUser.getWeworkUserId();
                Integer departmentId = weworkDepartmentUser.getDepartmentId();
                Set orDefault = weworkUserIdNodeMap.getOrDefault(weworkUserId, new HashSet());
                orDefault.add(departmentId);
                weworkUserIdNodeMap.put(weworkUserId, orDefault);
                weworkDeptIds.add(departmentId);
            }
            if (CollectionUtils.isNotEmpty(weworkDeptIds)) {
                orgIdAndWeworkUserIdMap = this.organizationMapper.queryOrgIdByWeworkDeptIds(bizId, weworkDeptIds);
            }
        }
        ArrayList<UserSimpleInfo> list = new ArrayList<UserSimpleInfo>();
        for (User user : users) {
            Long mainOrgId = user.getNodeId();
            UserSimpleInfo info = new UserSimpleInfo();
            info.setId(user.getId());
            info.setNum(user.getNum());
            info.setName(user.getName());
            info.setNodeId(mainOrgId);
            info.setWeworkUserId(user.getWeworkUserId());
            ArrayList<ArrayList<NodeInfo>> nodeInfos = new ArrayList<ArrayList<NodeInfo>>();
            Set nodeIds = (Set)weworkUserIdNodeMap.get(user.getWeworkUserId());
            if (CollectionUtils.isNotEmpty((Collection)nodeIds)) {
                Integer nodeId;
                Long orgId;
                Iterator iterator = nodeIds.iterator();
                while (iterator.hasNext() && (orgId = (Long)orgIdAndWeworkUserIdMap.get(nodeId = (Integer)iterator.next())) != null) {
                    ArrayList<NodeInfo> nodeInfo = new ArrayList<NodeInfo>();
                    this.getAllNode(nodeInfo, nodeMap, orgId, mainOrgId);
                    if (!CollectionUtils.isNotEmpty(nodeInfo)) continue;
                    nodeInfos.add(nodeInfo);
                }
            } else {
                ArrayList<NodeInfo> nodeInfo = new ArrayList<NodeInfo>();
                this.getAllNode(nodeInfo, nodeMap, mainOrgId, mainOrgId);
                nodeInfos.add(nodeInfo);
            }
            info.setFullNodeInfo(nodeInfos);
            list.add(info);
        }
        return list;
    }
}

