/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.common.enums.ParamEncryTypeEnum;
import com.kuaike.scrm.common.service.ParamEncryService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.OrderDetailParam;
import com.kuaike.scrm.common.service.dto.resp.MeetingEncryRespDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ParamEncryServiceImpl
implements ParamEncryService {
    private static final Logger log = LoggerFactory.getLogger(ParamEncryServiceImpl.class);
    @Autowired
    private ParamEncryMapper paramEncryMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public String encryMeetingParam(MeetingParams params) {
        log.info("encryMeetingParam, params:{}", (Object)params);
        if (params.getMeetingType() == MeetingType.EXTERNAL_MEETING.getValue()) {
            params.validateParams();
        }
        String paramsJsonStr = JsonUtil.toStr((Object)params);
        String num = this.idGen.getNum();
        ParamEncry paramEncry = new ParamEncry();
        paramEncry.setNum(num);
        paramEncry.setParams(paramsJsonStr);
        paramEncry.setType(NumberUtils.INTEGER_ONE);
        paramEncry.setCreateTime(new Date());
        this.paramEncryMapper.insertSelective((Object)paramEncry);
        return "&customstr=" + num;
    }

    @Override
    public List<MeetingEncryRespDto> batchGenerateEncryMeetingParam(List<MeetingParams> paramsList) {
        log.info("batchGenerateEncryMeetingParam, paramsList:{}", paramsList);
        if (CollectionUtils.isEmpty(paramsList)) {
            return Lists.newArrayList();
        }
        paramsList.forEach(a -> {
            if (a.getMeetingType() == MeetingType.EXTERNAL_MEETING.getValue()) {
                a.validateParams();
            }
        });
        ArrayList resultList = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        for (MeetingParams meetingParams : paramsList) {
            String paramsJsonStr = JsonUtil.toStr((Object)meetingParams);
            String num = this.idGen.getNum();
            ParamEncry paramEncry = new ParamEncry();
            paramEncry.setNum(num);
            paramEncry.setParams(paramsJsonStr);
            paramEncry.setType(NumberUtils.INTEGER_ONE);
            paramEncry.setCreateTime(new Date());
            list.add(paramEncry);
            MeetingEncryRespDto item = new MeetingEncryRespDto(meetingParams);
            item.setEncryParam("&customstr=" + num);
            resultList.add(item);
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.paramEncryMapper.batchInsert((Collection)list);
        }
        return resultList;
    }

    @Override
    public MeetingParams getMeetingParamsByNum(String num) {
        log.info("getMeetingParamsByNum,num:{}", (Object)num);
        if (StringUtils.isBlank((CharSequence)num)) {
            return null;
        }
        String params = this.paramEncryMapper.getParamsByTypeAndNum(NumberUtils.INTEGER_ONE, num);
        if (StringUtils.isBlank((CharSequence)params)) {
            log.warn("\u6839\u636e\u53c2\u6570num:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)num);
            return null;
        }
        try {
            return (MeetingParams)JacksonUtil.str2Obj((String)params, MeetingParams.class);
        }
        catch (IOException ex) {
            log.error("params:{}\u8f6c\u6210MeetingParams\u5bf9\u8c61\u5f02\u5e38:", (Object)params, (Object)ex);
            return null;
        }
    }

    @Override
    public void updateMeetingParam(String num, MeetingParams params) {
        if (params.getMeetingType() == MeetingType.EXTERNAL_MEETING.getValue()) {
            params.validateParams();
        }
        String paramsJsonStr = JsonUtil.toStr((Object)params);
        this.paramEncryMapper.updateParamsByNum(num, paramsJsonStr);
    }

    @Override
    public String encryMeetingOrderDetailParam(OrderDetailParam params) {
        log.info("encryMeetingOrderDetailParam params:{}", (Object)params);
        Preconditions.checkArgument((params.getOrderId() != null ? 1 : 0) != 0, (Object)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        String paramsJsonStr = JsonUtil.toStr((Object)params);
        String num = this.idGen.getNum();
        ParamEncry paramEncry = new ParamEncry();
        paramEncry.setNum(num);
        paramEncry.setParams(paramsJsonStr);
        paramEncry.setType(Integer.valueOf(ParamEncryTypeEnum.ORDER_TYPE.getValue()));
        paramEncry.setCreateTime(new Date());
        this.paramEncryMapper.insertSelective((Object)paramEncry);
        return num;
    }

    @Override
    public String encryMeetingParamByPlayback(MeetingParams params) {
        log.info("encryMeetingParamByPayback params:{}", (Object)params);
        String paramsJsonStr = JsonUtil.toStr((Object)params);
        String num = this.idGen.getNum();
        ParamEncry paramEncry = new ParamEncry();
        paramEncry.setNum(num);
        paramEncry.setParams(paramsJsonStr);
        paramEncry.setType(Integer.valueOf(ParamEncryTypeEnum.MEETING_PAYBACK_TYPE.getValue()));
        paramEncry.setCreateTime(new Date());
        this.paramEncryMapper.insertSelective((Object)paramEncry);
        return num;
    }
}

