/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.kuaike.scrm.common.service.FollowRecordMsgService;
import com.kuaike.scrm.common.service.dto.FollowRecordMsg;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FollowRecordMsgServiceImpl
implements FollowRecordMsgService {
    private static final Logger log = LoggerFactory.getLogger(FollowRecordMsgServiceImpl.class);
    @Autowired
    private KafkaClientUtils kafkaClient;
    @Value(value="${kafka.topic.follow_record}")
    private String followRecordTopic;

    @Override
    public void followRecordToKafka(FollowRecordMsg msg) {
        try {
            this.kafkaClient.sendMessage(this.followRecordTopic, JacksonUtils.getInstance().writeValueAsString(msg));
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u8ddf\u8fdb\u8bb0\u5f55topic:{}, \u5931\u8d25,", (Object)this.followRecordTopic, (Object)e);
        }
    }
}

