/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import cn.kinyun.crm.common.enums.RawLeadsAllocRule;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.customer.center.dto.req.AttachTagReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.SetBindingReq;
import cn.kinyun.customer.center.dto.req.SetStageReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventPage;
import cn.kinyun.customer.center.dto.req.event.EventSharer;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.dto.req.follow.AllocateInfoDto;
import cn.kinyun.customer.center.dto.req.follow.BaseInfoDto;
import cn.kinyun.customer.center.dto.req.follow.CsAttachInfoDto;
import cn.kinyun.customer.center.dto.req.follow.CsBaseInfo;
import cn.kinyun.customer.center.dto.req.follow.CsStage;
import cn.kinyun.customer.center.dto.req.follow.CsTag;
import cn.kinyun.customer.center.dto.req.follow.FollowInfoDto;
import cn.kinyun.customer.center.dto.req.follow.FollowReq;
import cn.kinyun.customer.center.dto.req.follow.FormInfoDto;
import cn.kinyun.customer.center.dto.req.follow.JsonContentDto;
import cn.kinyun.customer.center.dto.req.follow.RadarInfoDto;
import cn.kinyun.customer.center.dto.req.follow.StageInfoDto;
import cn.kinyun.customer.center.dto.req.follow.TagInfoDto;
import cn.kinyun.customer.center.enums.CustomerFollowType;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.service.CcCustomerBindService;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerFollowRecordService;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerStageService;
import cn.kinyun.customer.center.service.CcCustomerTagService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.dto.req.FollowRecordParamReqDto;
import com.kuaike.scrm.common.service.dto.req.RadarRecordParamReqDto;
import com.kuaike.scrm.common.service.dto.req.followparam.AllocateInfo;
import com.kuaike.scrm.common.service.dto.req.followparam.CorpTagDto;
import com.kuaike.scrm.common.service.dto.req.followparam.CustomerBaseInfo;
import com.kuaike.scrm.common.service.dto.req.followparam.CustomerStageInfo;
import com.kuaike.scrm.common.service.dto.req.followparam.CustomerTagInfo;
import com.kuaike.scrm.common.service.dto.req.followparam.FollowInfo;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.contactstage.entity.WeworkContactStage;
import com.kuaike.scrm.dal.dynamicform.entity.DynamicFormAccessLog;
import com.kuaike.scrm.dal.dynamicform.mapper.DynamicFormAccessLogMapper;
import com.kuaike.scrm.dal.follow.entity.FollowRecord;
import com.kuaike.scrm.dal.marketing.entity.MarketingChannelReport;
import com.kuaike.scrm.dal.marketing.mapper.MarketingChannelReportMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.radar.entity.MarketingRadarAccessLog;
import com.kuaike.scrm.dal.radar.mapper.MarketingRadarAccessLogMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageReasonMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerCenterServiceImpl
implements CustomerCenterService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCenterServiceImpl.class);
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private OfficialAccountFansMapper accountFansMapper;
    @Resource
    private MarketingChannelReportMapper channelReportMapper;
    @Resource
    private MarketingRadarAccessLogMapper radarAccessLogMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private CcCustomerTagService ccCustomerTagService;
    @Autowired
    private CcCustomerStageService ccCustomerStageService;
    @Autowired
    private CcCustomerBindService ccCustomerBindService;
    @Autowired
    private CcCustomerInfoService ccCustomerInfoService;
    @Autowired
    private CcCustomerFollowRecordService ccCustomerFollowRecordService;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Autowired
    private CustomerStageReasonMapper stageReasonMapper;
    @Resource
    private DynamicFormAccessLogMapper dynamicFormAccessLogMapper;
    @Autowired
    private CcCustomerEventService ccCustomerEventService;
    private static final String SOURCE = "scrm";

    @Override
    public void pushContactCustomer(WeworkContact contact) {
        if (contact == null) {
            log.warn("pushContactCustomer contact is null");
            return;
        }
        log.info("contact customer corpId: {}, contact: {}", (Object)contact.getCorpId(), (Object)contact);
        try {
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(contact.getBizId(), contact.getContactId(), contact.getUnionid());
            contact.setCustomerNum(customerNum);
            this.pushContactDetail(contact);
            this.weworkContactMapper.setCustomerNum(contact.getCorpId(), contact.getContactId(), customerNum);
        }
        catch (Exception e) {
            log.error("contact customer error: ", (Throwable)e);
        }
    }

    @Override
    public void pushMobileCustomer(Long bizId, String mobile, String name, List<String> tagIds, Long userId, Long channelId) {
        try {
            BusinessCustomer businessCustomer;
            boolean openCrm;
            log.info("pushMobileCustomer bizId: {}, mobile: {}, name: {}, userId: {}", new Object[]{bizId, mobile, name, userId});
            if (!MobileUtils.isPhone(mobile)) {
                log.warn("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a \u4e0d\u6dfb\u52a0\u5230\u7ebf\u7d22\uff1a mobile:{}", (Object)mobile);
            }
            if (!(openCrm = this.isOpenCrm(businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId)))) {
                return;
            }
            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
            crmLeadsInfoReq.setMobile(mobile);
            crmLeadsInfoReq.setCorpId(businessCustomer.getCorpId());
            boolean exists = this.crmLeadsService.exists(crmLeadsInfoReq);
            if (exists) {
                log.info("crmLeads exists, mobile: {}", (Object)mobile);
                return;
            }
            CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
            crmLeadsReq.setCorpId(businessCustomer.getCorpId());
            crmLeadsReq.setMobile(mobile);
            crmLeadsReq.setName(name);
            crmLeadsReq.setTagIds(tagIds);
            crmLeadsReq.setCreatorId(userId);
            crmLeadsReq.setAllocRule(Integer.valueOf(RawLeadsAllocRule.INNER_SYSTEM.getValue()));
            if (userId >= 0L) {
                crmLeadsReq.setAllocUserId(userId);
            }
            crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
            crmLeadsReq.setChannelId(channelId);
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.info("mobile customer bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
            log.error("mobile customer error: ", (Throwable)e);
        }
    }

    @Override
    public void pushMobile2Crm(Long bizId, String mobile, String name) {
        try {
            log.info("pushMobile2Crm bizId: {}, mobile: {}, name: {}", new Object[]{bizId, mobile, name});
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
            boolean openCrm = this.isOpenCrm(businessCustomer);
            if (!openCrm) {
                return;
            }
            CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
            crmLeadsReq.setCorpId(businessCustomer.getCorpId());
            crmLeadsReq.setMobile(mobile);
            crmLeadsReq.setName(name);
            crmLeadsReq.setAllocRule(Integer.valueOf(RawLeadsAllocRule.INNER_SYSTEM.getValue()));
            crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        catch (Exception e) {
            log.info("mobile customer bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
            log.error("mobile customer error: ", (Throwable)e);
        }
    }

    @Override
    public void pushAddMobileEvent(Long bizId, String mobile, String moduleType) {
        log.info("pushAddMobileEvent bizId: {}, mobile: {}", (Object)bizId, (Object)mobile);
        boolean isNewMobile = this.ccCustomerNumService.mobileIsExist(bizId, mobile);
        String customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, mobile);
        CustomerEventReq req = new CustomerEventReq();
        req.setBizId(bizId);
        req.setCustomerNum(customerNum);
        req.setEventType(EventType.ADD_MOBILE.getCode());
        EventData eventData = new EventData();
        EventModule eventModule = new EventModule();
        eventModule.setType(moduleType);
        eventData.setMobile(mobile);
        eventData.setNewMobile(isNewMobile);
        eventData.setModule(eventModule);
        req.setEventData(eventData);
        req.setEventTime(new Date());
        this.ccCustomerEventService.add(req);
    }

    private boolean isOpenCrm(BusinessCustomer businessCustomer) {
        log.info("isOpenCrm businessCustomer: {}", (Object)businessCustomer);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pushOfficialFansCustomer(OfficialAccountFans fans) {
        if (fans == null) {
            log.warn("pushOfficialFansCustomer fans is null");
            return;
        }
        log.info("mobile customer bizId: {}, fans: {}", (Object)fans.getBizId(), (Object)fans);
        try {
            String customerNum = this.ccCustomerNumService.getCustomerNumByOfficialFans(fans.getBizId(), fans.getAppId(), fans.getOpenId(), fans.getUnionId());
            fans.setCustomerNum(customerNum);
            this.accountFansMapper.updateByPrimaryKeySelective((Object)fans);
        }
        catch (Exception e) {
            log.error("mobile customer error: ", (Throwable)e);
        }
    }

    @Override
    public void pushChannelReportCustomer(MarketingChannelReport channelReport) {
        if (channelReport == null) {
            log.warn("pushChannelReportCustomer channelReport is null");
            return;
        }
        log.info("channel report bizId: {}, channelReport: {}", (Object)channelReport.getBizId(), (Object)channelReport);
        try {
            String customerNum = null;
            customerNum = StringUtils.isNotEmpty((CharSequence)channelReport.getAppId()) && !channelReport.getAppId().equals(channelReport.getCorpId()) && StringUtils.isNotBlank((CharSequence)channelReport.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByOfficialFans(channelReport.getBizId(), channelReport.getAppId(), channelReport.getOpenId(), channelReport.getUnionId()) : (StringUtils.isNotBlank((CharSequence)channelReport.getContactId()) ? this.ccCustomerNumService.getCustomerNumByWeworkContactId(channelReport.getBizId(), channelReport.getContactId(), null) : (StringUtils.isNotBlank((CharSequence)channelReport.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByWeworkOpenId(channelReport.getBizId(), channelReport.getOpenId()) : this.ccCustomerNumService.getCustomerNumByH5Cookie(channelReport.getBizId(), channelReport.getUniqId())));
            channelReport.setCustomerNum(customerNum);
            this.channelReportMapper.updateByPrimaryKeySelective((Object)channelReport);
        }
        catch (Exception e) {
            log.error("channel report error: ", (Throwable)e);
        }
    }

    @Override
    public void pushRadarAccessLogCustomer(MarketingRadarAccessLog radarAccessLog) {
        if (radarAccessLog == null) {
            log.warn("pushContactRelation radarAccessLog is null");
            return;
        }
        log.info("radar access log bizId: {}, radarAccessLogId: {}", (Object)radarAccessLog.getBizId(), (Object)radarAccessLog.getId());
        try {
            String customerNum = null;
            customerNum = StringUtils.isNotEmpty((CharSequence)radarAccessLog.getContactId()) ? this.ccCustomerNumService.getCustomerNumByWeworkContactId(radarAccessLog.getBizId(), radarAccessLog.getContactId(), null) : (StringUtils.isNotBlank((CharSequence)radarAccessLog.getOpenId()) ? this.ccCustomerNumService.getCustomerNumByWeworkOpenId(radarAccessLog.getBizId(), radarAccessLog.getOpenId()) : this.ccCustomerNumService.getCustomerNumByH5Cookie(radarAccessLog.getBizId(), radarAccessLog.getUniqId()));
            radarAccessLog.setCustomerNum(customerNum);
            this.radarAccessLogMapper.updateByPrimaryKeySelective((Object)radarAccessLog);
        }
        catch (Exception e) {
            log.error("radar access log error: ", (Throwable)e);
        }
    }

    @Override
    public void pushContactRelation(WeworkContactRelation contactRelation) {
        if (contactRelation == null) {
            log.warn("pushContactRelation contactRelation is null");
            return;
        }
        log.info("contact relation bizId: {}, contactRelationId: {}", (Object)contactRelation.getBizId(), (Object)contactRelation.getId());
        try {
            SetBindingReq bindingReq = new SetBindingReq();
            bindingReq.setBizId(contactRelation.getBizId());
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(contactRelation.getBizId(), contactRelation.getContactId(), null);
            bindingReq.setCustomerNum(customerNum);
            bindingReq.setSource(SOURCE);
            bindingReq.setUserId(Long.valueOf(-1L));
            String weworkUserNum = this.weworkUserMapper.getNumByCorpIdAndWeworkUserId(contactRelation.getCorpId(), contactRelation.getWeworkUserId());
            bindingReq.setWeworkUserNum(weworkUserNum);
            bindingReq.setIsDeleted(contactRelation.getIsDeleted());
            if (Objects.nonNull(contactRelation.getIsDeleted()) && contactRelation.getIsDeleted() == 1) {
                bindingReq.setDeleteTime(contactRelation.getDeletedTime());
            }
            bindingReq.validate();
            this.ccCustomerBindService.setBinding(bindingReq);
        }
        catch (Exception e) {
            log.error("contact relation error: ", (Throwable)e);
        }
    }

    @Override
    public void pushTagRelation(Long bizId, String weworkUserNum, String customerNum, List<String> addTagIds, List<String> delTagIds) {
        log.info("pushTagRelation bizId: {}, customerNum: {}, addTagIds: {}, delTagIds: {}", new Object[]{bizId, customerNum, addTagIds, delTagIds});
        if (CollectionUtils.isNotEmpty(addTagIds)) {
            addTagIds = addTagIds.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(delTagIds)) {
            delTagIds = delTagIds.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(addTagIds) && CollectionUtils.isEmpty(delTagIds)) {
            log.warn("pushTagRelation addTagIds is empty && delTagIds is empty");
            return;
        }
        try {
            AttachTagReq tagReq = new AttachTagReq();
            tagReq.setBizId(bizId);
            tagReq.setWeworkUserNum(weworkUserNum);
            tagReq.setCustomerNum(customerNum);
            tagReq.setSource(SOURCE);
            tagReq.setAddTagIds(addTagIds);
            tagReq.setRemoveTagIds(delTagIds);
            this.ccCustomerTagService.attachTag(tagReq);
        }
        catch (Exception e) {
            log.error("push tag relation error: ", (Throwable)e);
        }
    }

    @Override
    public void pushCustomerStage(WeworkContactStage stage) {
        if (stage == null) {
            log.warn("pushCustomerStage stage is null");
            return;
        }
        log.info("customer stage corpId: {}, contactStageId: {}", (Object)stage.getCorpId(), (Object)stage.getId());
        try {
            SetStageReq stageReq = new SetStageReq();
            stageReq.setBizId(stage.getBizId());
            String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(stage.getBizId(), stage.getContactId(), null);
            stageReq.setCustomerNum(customerNum);
            stageReq.setRemark(stage.getRemark());
            stageReq.setSource(SOURCE);
            stageReq.setUserId(Long.valueOf(-1L));
            stageReq.setStageId(stage.getStageId());
            stageReq.setFinalStageId(stage.getFinalStageId());
            stageReq.setStatus(stage.getStatus());
            if (stageReq.getStageId() == null) {
                stageReq.setStageId(stage.getFinalStageId());
            }
            stageReq.setWeworkUserNum(stage.getWeworkUserNum());
            if (Objects.nonNull(stage.getStageReasonId())) {
                String stageReason = this.stageReasonMapper.selectStageReasonById(stage.getStageReasonId());
                stageReq.setStageReason(stageReason);
                stageReq.setStageReasonId(stage.getStageReasonId());
            }
            this.ccCustomerStageService.setStage(stageReq);
        }
        catch (Exception e) {
            log.error("customer stage error: ", (Throwable)e);
        }
    }

    @Override
    public void pushCustomerStage(SetStageReq stage) {
        if (stage == null) {
            log.warn("pushCustomerStage stage is null");
            return;
        }
        log.info("customer stage bizId: {}, param: {}", (Object)JSONObject.toJSONString((Object)stage));
        try {
            SetStageReq stageReq = new SetStageReq();
            stageReq.setBizId(stage.getBizId());
            stageReq.setCustomerNum(stage.getCustomerNum());
            stageReq.setRemark(stage.getRemark());
            stageReq.setSource(stage.getSource());
            stageReq.setUserId(Long.valueOf(-1L));
            stageReq.setStageId(stage.getStageId());
            stageReq.setFinalStageId(stage.getFinalStageId());
            stageReq.setStatus(stage.getStatus());
            if (stageReq.getStageId() == null) {
                stageReq.setStageId(stage.getFinalStageId());
            }
            stageReq.setWeworkUserNum(stage.getWeworkUserNum());
            if (Objects.nonNull(stage.getStageReasonId())) {
                String stageReason = this.stageReasonMapper.selectStageReasonById(stage.getStageReasonId());
                stageReq.setStageReason(stageReason);
                stageReq.setStageReasonId(stage.getStageReasonId());
            }
            this.ccCustomerStageService.setStage(stageReq);
        }
        catch (Exception e) {
            log.error("customer stage error: ", (Throwable)e);
        }
    }

    @Override
    public void bindCustomer(Long bizId, String corpId, String contactId, String mobile, String moduleType) {
        log.info("bind customer bizId: {}, contactId: {}, mobile: {}, moduleType:{}", new Object[]{bizId, contactId, mobile, moduleType});
        try {
            this.ccCustomerNumService.bindWeworkContactAndMobile(bizId, contactId, mobile, moduleType);
        }
        catch (Exception e) {
            log.error("bind customer error: ", (Throwable)e);
        }
    }

    @Override
    public void pushFollowRecord(FollowRecord reqDto, String remark, String operatorName) {
        log.info("customer follow record corpId: {}, reqDto: {}", (Object)reqDto.getCorpId(), (Object)reqDto);
        FollowReq req = new FollowReq();
        req.setBizId(reqDto.getBizId());
        String customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(reqDto.getBizId(), reqDto.getWeworkContactId(), null);
        req.setWeworkUserNum(reqDto.getWeworkUserNum());
        req.setUserId(reqDto.getUserId());
        req.setCustomerNum(customerNum);
        req.setSource(SOURCE);
        req.setFollowType(reqDto.getType());
        req.setFollowContent(remark);
        req.setViewContent(reqDto.getContent());
        req.setFollowTime(reqDto.getCreateTime());
        req.setWeworkUserName(operatorName);
        JsonContentDto contentDto = this.buildJsonContentDto(reqDto);
        req.setJsonContent(contentDto);
        log.info("pushFollowRecord req: {}", (Object)req);
        try {
            this.ccCustomerFollowRecordService.add(req);
        }
        catch (Exception e) {
            log.error("customer stage error: ", (Throwable)e);
        }
    }

    @Override
    public void pushContactDetail(WeworkContact contact) {
        CustomerDetailReq detailReq = this.initCustomerBasicInfo(contact.getBizId(), contact.getCustomerNum(), contact);
        log.info("pushContactDetail: customerNum: {}", (Object)contact.getCustomerNum());
        this.ccCustomerDetailService.add(detailReq);
    }

    @Override
    public void pushFormAccessLog(DynamicFormAccessLog formAccessLog) {
        if (formAccessLog == null) {
            return;
        }
        try {
            log.info("form access log bizId: {}, formAccessLogId: {}", (Object)formAccessLog.getBizId(), (Object)formAccessLog.getId());
            String customerNum = null;
            String contactCustomerNum = null;
            String openIdCustomerNum = null;
            if (StringUtils.isNotBlank((CharSequence)formAccessLog.getOpenId())) {
                openIdCustomerNum = this.ccCustomerNumService.getCustomerNumByWeworkOpenId(formAccessLog.getBizId(), formAccessLog.getOpenId());
                if (StringUtils.isNotEmpty((CharSequence)formAccessLog.getContactId())) {
                    contactCustomerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(formAccessLog.getBizId(), formAccessLog.getContactId(), null);
                }
            }
            String string = customerNum = StringUtils.isNotBlank(contactCustomerNum) ? contactCustomerNum : openIdCustomerNum;
            if (StringUtils.isBlank(customerNum) && StringUtils.isNotBlank((CharSequence)formAccessLog.getCookie())) {
                customerNum = this.ccCustomerNumService.getCustomerNumByH5Cookie(formAccessLog.getBizId(), formAccessLog.getCookie());
            }
            formAccessLog.setCustomerNum(customerNum);
            this.dynamicFormAccessLogMapper.updateByPrimaryKeySelective((Object)formAccessLog);
        }
        catch (Exception e) {
            log.error("form access log error: ", (Throwable)e);
        }
    }

    @Override
    public void saveVisitPage(Long bizId, String customerNum, String accessNum, EventPage eventPage, EventModule module, EventSharer sharer, EventVisitor visitor) {
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.VISIT_PAGE.getCode());
        eventReq.setSource(SOURCE);
        eventReq.setEventTime(new Date());
        eventReq.setBizId(bizId);
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        eventData.setAccessNum(accessNum);
        eventData.setPage(eventPage);
        eventData.setModule(module);
        eventData.setSharer(sharer);
        eventData.setVisitor(visitor);
        log.info("save visit page event: {}", (Object)eventReq);
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("add visit page event data error: ", (Throwable)e);
        }
    }

    @Override
    public void saveAddMobile(Long bizId, String customerNum, String mobile, String type, String num, String name) {
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.ADD_MOBILE.getCode());
        eventReq.setSource(SOURCE);
        eventReq.setEventTime(new Date());
        eventReq.setBizId(bizId);
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventReq.setEventData(eventData);
        eventData.setMobile(mobile);
        EventModule eventModule = new EventModule();
        eventData.setModule(eventModule);
        eventModule.setType(type);
        eventModule.setNum(num);
        eventModule.setName(name);
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("save add mobile event error: ", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonContentDto buildJsonContentDto(FollowRecord reqDto) {
        JsonContentDto dto = new JsonContentDto();
        if (!StringUtils.isNotBlank((CharSequence)reqDto.getParams())) return dto;
        if (reqDto.getType() < 6) {
            log.info("buildJsonContentDto param: {}", (Object)reqDto.getParams());
            FollowRecordParamReqDto paramReqDto = (FollowRecordParamReqDto)JSONObject.parseObject((String)reqDto.getParams(), FollowRecordParamReqDto.class);
            if (paramReqDto == null) return dto;
            switch (reqDto.getType()) {
                case 1: {
                    CustomerBaseInfo baseInfo = paramReqDto.getCustomerBaseInfo();
                    if (baseInfo == null) return dto;
                    BaseInfoDto baseInfoDto = this.buildBaseInfo(baseInfo);
                    dto.setBaseInfo(baseInfoDto);
                    return dto;
                }
                case 2: {
                    CustomerStageInfo stageInfo = paramReqDto.getCustomerStageInfo();
                    if (stageInfo == null) return dto;
                    StageInfoDto stageInfoDto = this.buildStageInfo(stageInfo.getOldStageId(), stageInfo.getNewStageId());
                    dto.setStageInfo(stageInfoDto);
                    return dto;
                }
                case 3: {
                    FollowInfo followInfo = paramReqDto.getFollowInfo();
                    if (followInfo == null) return dto;
                    FollowInfoDto followInfoDto = this.buildFollowInfo(followInfo);
                    StageInfoDto stageInfoDto = this.buildStageInfo(followInfo.getOldStageId(), followInfo.getNewStageId());
                    TagInfoDto tagInfoDto = this.buildTagInfo(followInfo.getOldTags(), followInfo.getNewTags());
                    dto.setStageInfo(stageInfoDto);
                    dto.setTagInfo(tagInfoDto);
                    dto.setFollowInfo(followInfoDto);
                    return dto;
                }
                case 4: {
                    CustomerTagInfo tagInfo = paramReqDto.getCustomerTagInfo();
                    if (tagInfo == null) return dto;
                    TagInfoDto tagInfoDto = this.buildTagInfo(tagInfo.getOldTags(), tagInfo.getNewTags());
                    dto.setTagInfo(tagInfoDto);
                    return dto;
                }
                case 5: {
                    if (paramReqDto.getAllocateInfo() == null) return dto;
                    AllocateInfo allocateInfo = paramReqDto.getAllocateInfo();
                    if (allocateInfo == null) return dto;
                    AllocateInfoDto allocateInfoDto = this.buildAllocateInfo(allocateInfo);
                    dto.setAllocateInfo(allocateInfoDto);
                    return dto;
                }
            }
            return dto;
        } else if (reqDto.getType().intValue() == CustomerFollowType.RADAR.getValue()) {
            RadarRecordParamReqDto paramReqDto = (RadarRecordParamReqDto)JSONObject.parseObject((String)reqDto.getParams(), RadarRecordParamReqDto.class);
            if (paramReqDto == null) return dto;
            RadarInfoDto radarInfoDto = new RadarInfoDto();
            radarInfoDto.setViewTime(paramReqDto.getViewTime());
            radarInfoDto.setProgress(paramReqDto.getProgress());
            radarInfoDto.setDuration(paramReqDto.getDuration());
            radarInfoDto.setFileUrl(paramReqDto.getFileUrl());
            radarInfoDto.setTitle(paramReqDto.getTitle());
            dto.setRadarInfo(radarInfoDto);
            return dto;
        } else {
            FormInfoDto formInfoDto;
            if (reqDto.getType().intValue() != CustomerFollowType.FORM_CUSTOMER_FOLLOW.getValue() || (formInfoDto = (FormInfoDto)JSONObject.parseObject((String)reqDto.getParams(), FormInfoDto.class)) == null) return dto;
            dto.setFormInfoDto(formInfoDto);
        }
        return dto;
    }

    private BaseInfoDto buildBaseInfo(CustomerBaseInfo baseInfo) {
        CsBaseInfo oldInfo = new CsBaseInfo();
        oldInfo.setDescription(baseInfo.getOldDescription());
        oldInfo.setRemarkMobile(baseInfo.getOldRemarkMobiles());
        oldInfo.setRemarkName(baseInfo.getOldRemarkName());
        oldInfo.setRegion(baseInfo.getOldRegion());
        CsBaseInfo newInfo = new CsBaseInfo();
        newInfo.setDescription(baseInfo.getNewDescription());
        newInfo.setRemarkMobile(baseInfo.getNewRemarkMobiles());
        newInfo.setRemarkName(baseInfo.getNewRemarkName());
        newInfo.setRegion(baseInfo.getNewRegion());
        BaseInfoDto infoDto = new BaseInfoDto();
        infoDto.setOldBasicInfo(oldInfo);
        infoDto.setNewBasicInfo(newInfo);
        return infoDto;
    }

    private StageInfoDto buildStageInfo(Long oldStageId, Long newStageId) {
        CsStage oldStage = new CsStage();
        if (oldStageId != null) {
            CustomerStage oldCustomerStage = this.customerStageMapper.queryStageByPrimaryKey(oldStageId);
            oldStage.setStageId(oldStageId);
            if (Objects.nonNull(oldCustomerStage)) {
                oldStage.setStageName(oldCustomerStage.getStageName());
                oldStage.setType(oldCustomerStage.getType());
                oldStage.setStageValue(oldCustomerStage.getStageValue());
            }
        }
        CsStage newStage = new CsStage();
        if (newStageId != null) {
            CustomerStage newCustomerStage = this.customerStageMapper.queryStageByPrimaryKey(newStageId);
            newStage.setStageId(newStageId);
            if (Objects.nonNull(newCustomerStage)) {
                newStage.setStageName(newCustomerStage.getStageName());
                newStage.setType(newCustomerStage.getType());
                newStage.setStageValue(newCustomerStage.getStageValue());
            }
        }
        StageInfoDto infoDto = new StageInfoDto();
        infoDto.setOldStage(oldStage);
        infoDto.setNewStage(newStage);
        return infoDto;
    }

    private FollowInfoDto buildFollowInfo(FollowInfo followInfo) {
        FollowInfoDto infoDto = new FollowInfoDto();
        ArrayList attachInfoDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(followInfo.getAttachments())) {
            followInfo.getAttachments().forEach(a -> {
                CsAttachInfoDto attachInfoDto = new CsAttachInfoDto();
                attachInfoDto.setName(a.getName());
                attachInfoDto.setUrl(a.getUrl());
                attachInfoDtos.add(attachInfoDto);
            });
        }
        infoDto.setAttachments((List)attachInfoDtos);
        infoDto.setRemark(followInfo.getRemark());
        infoDto.setCallRecordId(followInfo.getCallRecordNum());
        return infoDto;
    }

    private TagInfoDto buildTagInfo(List<CorpTagDto> oldTags, List<CorpTagDto> newTags) {
        ArrayList csOldTags = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(oldTags)) {
            oldTags.forEach(a -> {
                CsTag oldTag = new CsTag();
                oldTag.setTagId(a.getTagId());
                oldTag.setTagName(a.getTagName());
                csOldTags.add(oldTag);
            });
        }
        ArrayList csNewTags = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(newTags)) {
            newTags.forEach(a -> {
                CsTag newTag = new CsTag();
                newTag.setTagId(a.getTagId());
                newTag.setTagName(a.getTagName());
                csNewTags.add(newTag);
            });
        }
        TagInfoDto tagInfoDto = new TagInfoDto();
        tagInfoDto.setOldTag((List)csOldTags);
        tagInfoDto.setNewTag((List)csNewTags);
        return tagInfoDto;
    }

    private AllocateInfoDto buildAllocateInfo(AllocateInfo allocateInfo) {
        AllocateInfoDto infoDto = new AllocateInfoDto();
        infoDto.setAllocateType(allocateInfo.getAllocateType());
        infoDto.setContactId(allocateInfo.getContactId());
        infoDto.setHandoverUserId(allocateInfo.getHandoverUserId());
        infoDto.setTakeoverUserId(allocateInfo.getTakeoverUserId());
        return infoDto;
    }

    private CustomerDetailReq initCustomerBasicInfo(Long bizId, String customerNum, WeworkContact contact) {
        CustomerDetailReq detailReq = new CustomerDetailReq();
        detailReq.setBizId(bizId);
        detailReq.setCustomerNum(customerNum);
        detailReq.setName(contact.getName());
        detailReq.setAvatar(contact.getAvatar());
        detailReq.setCorpName(contact.getCorpName());
        detailReq.setCorpFullName(contact.getCorpFullName());
        detailReq.setType(contact.getType());
        detailReq.setGender(contact.getGender());
        detailReq.setSource(SOURCE);
        detailReq.setChannelId(contact.getChannelNum());
        return detailReq;
    }
}

