/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.BizStatus;
import com.kuaike.scrm.common.service.CommonService;
import com.kuaike.scrm.common.service.dto.UrlInfoDto;
import com.kuaike.scrm.common.service.dto.UrlParams;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    private static final String[] ua = new String[]{"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.87 Safari/537.36 OPR/37.0.2178.32", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586", "Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.1; WOW64; Trident/4.0)", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 BIDUBrowser/8.3 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.80 Safari/537.36 Core/1.47.277.400 QQBrowser/9.4.7658.400", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 UBrowser/5.6.12150.8 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/38.0.2125.122 Safari/537.36 SE 2.X MetaSr 1.0", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/48.0.2564.116 Safari/537.36 TheWorld 7", "Mozilla/5.0 (Windows NT 6.1; W\u2026) Gecko/20100101 Firefox/60.0"};
    private static Random r = new Random();

    @Override
    public UrlInfoDto getUrlInfo(UrlParams params) {
        Elements imgs;
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String url = params.getUrl();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is null");
        UrlInfoDto basicInfo = new UrlInfoDto();
        basicInfo.setUrl(url);
        Document document = CommonServiceImpl.getDocumentByUrl(url);
        if (Objects.isNull(document)) {
            return basicInfo;
        }
        String html = document.html();
        basicInfo.setHtml(html);
        String title = document.title();
        if (StringUtils.isBlank((CharSequence)title)) {
            Elements description = document.head().getElementsByAttributeValueMatching("property", "og:title");
            title = description.attr("content");
        }
        basicInfo.setTitle(title);
        Element head = document.head();
        Elements description = head.getElementsByAttributeValueMatching("name", "description");
        if (Objects.nonNull(description)) {
            basicInfo.setDesc(description.attr("content"));
        }
        if (Objects.nonNull(imgs = document.getElementsByTag("img")) && Objects.nonNull(imgs.first())) {
            Element img = imgs.first();
            String src = img.attr("src");
            if (StringUtils.isBlank((CharSequence)src)) {
                Elements attribute = document.body().getElementsByAttribute("data-src");
                if (Objects.nonNull(attribute)) {
                    src = attribute.attr("data-src");
                }
            } else {
                src = img.attr("abs:src");
            }
            if (StringUtils.isNotBlank((CharSequence)src)) {
                String extension = FilenameUtils.getExtension((String)src);
                if (!Sets.newHashSet((Object[])new String[]{"jpg", "jpeg", "png"}).contains(extension)) {
                    src = null;
                }
            }
            basicInfo.setImg(src);
        }
        return basicInfo;
    }

    private static Document getDocumentByUrl(String url) {
        int i = r.nextInt(14);
        Document document = null;
        try {
            document = Jsoup.connect((String)url).timeout(5000).userAgent(ua[i]).get();
        }
        catch (Exception e) {
            log.error("get url exception ;url:{} ", (Object)url, (Object)e);
        }
        return document;
    }

    @Override
    public boolean queryAvailable(String corpId) {
        if (StringUtils.isBlank((CharSequence)corpId)) {
            log.error("corpId \u672a\u627e\u5230");
            return false;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        if (Objects.isNull(biz)) {
            log.warn("\u627e\u4e0d\u5230\u4f01\u4e1a\u5bf9\u5e94\u7684\u5546\u6237id, corpId={}", (Object)corpId);
            return false;
        }
        if (BizStatus.INVALID.getValue() == biz.getStatus().intValue()) {
            log.warn("\u5f53\u524d\u5546\u6237\u5df2\u8fc7\u671f\uff1acorpId:{},expireTime:{}", (Object)corpId, (Object)JSON.toJSONString((Object)biz.getExpireDate()));
            return false;
        }
        return true;
    }
}

