/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.dto;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.MeetingType;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MeetingParams {
    private Long meetingId;
    private String groupSendNum;
    private String weworkUserNum;
    private Long userId;
    private String targetId;
    private Integer type;
    private long channelId = NumberUtils.LONG_ZERO;
    private int meetingType = MeetingType.EXTERNAL_MEETING.getValue();
    private String appId;
    private String openId;
    private String unionId;
    private Long userNumber;
    private String userName;

    public MeetingParams(Long meetingId, String groupSendNum, String weworkUserNum, String targetId, Integer type, Long channelId) {
        this.meetingId = meetingId;
        this.groupSendNum = groupSendNum;
        this.weworkUserNum = weworkUserNum;
        this.targetId = targetId;
        this.type = type;
        this.channelId = channelId;
    }

    public MeetingParams() {
    }

    public void validateParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.meetingId), (Object)"\u4f1a\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.groupSendNum), (Object)"\u7fa4\u53d1\u4efb\u52a1num\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserNum), (Object)"\u4f01\u5fae\u6210\u5458num\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.type), (Object)"\u53d1\u9001\u5bf9\u8c61\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Long getMeetingId() {
        return this.meetingId;
    }

    public String getGroupSendNum() {
        return this.groupSendNum;
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Integer getType() {
        return this.type;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public int getMeetingType() {
        return this.meetingType;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getUnionId() {
        return this.unionId;
    }

    public Long getUserNumber() {
        return this.userNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setMeetingId(Long meetingId) {
        this.meetingId = meetingId;
    }

    public void setGroupSendNum(String groupSendNum) {
        this.groupSendNum = groupSendNum;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public void setMeetingType(int meetingType) {
        this.meetingType = meetingType;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public void setUserNumber(Long userNumber) {
        this.userNumber = userNumber;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingParams)) {
            return false;
        }
        MeetingParams other = (MeetingParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChannelId() != other.getChannelId()) {
            return false;
        }
        if (this.getMeetingType() != other.getMeetingType()) {
            return false;
        }
        Long this$meetingId = this.getMeetingId();
        Long other$meetingId = other.getMeetingId();
        if (this$meetingId == null ? other$meetingId != null : !((Object)this$meetingId).equals(other$meetingId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Long this$userNumber = this.getUserNumber();
        Long other$userNumber = other.getUserNumber();
        if (this$userNumber == null ? other$userNumber != null : !((Object)this$userNumber).equals(other$userNumber)) {
            return false;
        }
        String this$groupSendNum = this.getGroupSendNum();
        String other$groupSendNum = other.getGroupSendNum();
        if (this$groupSendNum == null ? other$groupSendNum != null : !this$groupSendNum.equals(other$groupSendNum)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        if (this$openId == null ? other$openId != null : !this$openId.equals(other$openId)) {
            return false;
        }
        String this$unionId = this.getUnionId();
        String other$unionId = other.getUnionId();
        if (this$unionId == null ? other$unionId != null : !this$unionId.equals(other$unionId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $channelId = this.getChannelId();
        result = result * 59 + (int)($channelId >>> 32 ^ $channelId);
        result = result * 59 + this.getMeetingType();
        Long $meetingId = this.getMeetingId();
        result = result * 59 + ($meetingId == null ? 43 : ((Object)$meetingId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Long $userNumber = this.getUserNumber();
        result = result * 59 + ($userNumber == null ? 43 : ((Object)$userNumber).hashCode());
        String $groupSendNum = this.getGroupSendNum();
        result = result * 59 + ($groupSendNum == null ? 43 : $groupSendNum.hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        String $unionId = this.getUnionId();
        result = result * 59 + ($unionId == null ? 43 : $unionId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    public String toString() {
        return "MeetingParams(meetingId=" + this.getMeetingId() + ", groupSendNum=" + this.getGroupSendNum() + ", weworkUserNum=" + this.getWeworkUserNum() + ", userId=" + this.getUserId() + ", targetId=" + this.getTargetId() + ", type=" + this.getType() + ", channelId=" + this.getChannelId() + ", meetingType=" + this.getMeetingType() + ", appId=" + this.getAppId() + ", openId=" + this.getOpenId() + ", unionId=" + this.getUnionId() + ", userNumber=" + this.getUserNumber() + ", userName=" + this.getUserName() + ")";
    }
}

