/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.service.dto;

import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import com.kuaike.scrm.common.enums.FollowRecordMsgType;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.call.entity.CallRecord;
import com.kuaike.scrm.dal.sms.entity.SmsTaskDetail;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;

public class FollowRecordMsg
implements Serializable {
    private String corpId;
    private String action;
    private String from;
    private List<String> tolist;
    private Long updateTime;
    private Integer talkerType;
    private Boolean external;
    private String customerPhone;
    private Integer userType;
    private Long userId;
    private Integer callType;
    private Integer callStatus;
    private Date createTime;
    private Integer smsStatus;
    private Long bizId;
    private Integer followRecordMsgType;
    private String createDate;
    private String msgId;
    private Integer isFormCustomer;
    private Long msgTime;

    public static FollowRecordMsg fromChatMsg(ChatMsg chatMsg) {
        FollowRecordMsg msg = new FollowRecordMsg();
        BeanUtils.copyProperties((Object)chatMsg, (Object)msg);
        msg.setExternal(chatMsg.getExternalContact());
        msg.setMsgId(chatMsg.getMsgId());
        String createDate = chatMsg.getUpdateTime() == null ? null : DateUtil.dateToDateString(new Date(chatMsg.getUpdateTime()), "yyyy-MM-dd");
        msg.setCreateDate(createDate);
        msg.setFollowRecordMsgType(FollowRecordMsgType.WEWORK_CHAT.getValue());
        return msg;
    }

    public static FollowRecordMsg fromCallRecord(CallRecord callRecord) {
        FollowRecordMsg msg = new FollowRecordMsg();
        msg.setBizId(callRecord.getBizId());
        msg.setUserId(callRecord.getUserId());
        msg.setCustomerPhone(callRecord.getCustomerPhone());
        msg.setUserType(callRecord.getUserType());
        msg.setCallType(callRecord.getType());
        msg.setCallStatus(callRecord.getStatus());
        msg.setCreateTime(callRecord.getCreateTime());
        msg.setCreateDate(DateUtil.dateToDateString(callRecord.getCreateTime(), "yyyy-MM-dd"));
        msg.setFollowRecordMsgType(FollowRecordMsgType.CALL.getValue());
        msg.setMsgId("");
        return msg;
    }

    public static FollowRecordMsg fromSmsRecord(SmsTaskDetail detail) {
        FollowRecordMsg msg = new FollowRecordMsg();
        msg.setBizId(detail.getBizId());
        msg.setUserId(detail.getCreateBy());
        msg.setCustomerPhone(detail.getPhone());
        msg.setCreateTime(detail.getCreateTime());
        msg.setSmsStatus(detail.getStatus());
        msg.setCreateDate(DateUtil.dateToDateString(detail.getCreateTime(), "yyyy-MM-dd"));
        msg.setFollowRecordMsgType(FollowRecordMsgType.SMS.getValue());
        msg.setMsgId("");
        return msg;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public String getAction() {
        return this.action;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getTolist() {
        return this.tolist;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Integer getTalkerType() {
        return this.talkerType;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public Long getUserId() {
        return this.userId;
    }

    public Integer getCallType() {
        return this.callType;
    }

    public Integer getCallStatus() {
        return this.callStatus;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Integer getSmsStatus() {
        return this.smsStatus;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public Integer getFollowRecordMsgType() {
        return this.followRecordMsgType;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public Integer getIsFormCustomer() {
        return this.isFormCustomer;
    }

    public Long getMsgTime() {
        return this.msgTime;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTolist(List<String> tolist) {
        this.tolist = tolist;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public void setTalkerType(Integer talkerType) {
        this.talkerType = talkerType;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setCallType(Integer callType) {
        this.callType = callType;
    }

    public void setCallStatus(Integer callStatus) {
        this.callStatus = callStatus;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setSmsStatus(Integer smsStatus) {
        this.smsStatus = smsStatus;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setFollowRecordMsgType(Integer followRecordMsgType) {
        this.followRecordMsgType = followRecordMsgType;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setIsFormCustomer(Integer isFormCustomer) {
        this.isFormCustomer = isFormCustomer;
    }

    public void setMsgTime(Long msgTime) {
        this.msgTime = msgTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FollowRecordMsg)) {
            return false;
        }
        FollowRecordMsg other = (FollowRecordMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$updateTime = this.getUpdateTime();
        Long other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Integer this$talkerType = this.getTalkerType();
        Integer other$talkerType = other.getTalkerType();
        if (this$talkerType == null ? other$talkerType != null : !((Object)this$talkerType).equals(other$talkerType)) {
            return false;
        }
        Boolean this$external = this.getExternal();
        Boolean other$external = other.getExternal();
        if (this$external == null ? other$external != null : !((Object)this$external).equals(other$external)) {
            return false;
        }
        Integer this$userType = this.getUserType();
        Integer other$userType = other.getUserType();
        if (this$userType == null ? other$userType != null : !((Object)this$userType).equals(other$userType)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$callType = this.getCallType();
        Integer other$callType = other.getCallType();
        if (this$callType == null ? other$callType != null : !((Object)this$callType).equals(other$callType)) {
            return false;
        }
        Integer this$callStatus = this.getCallStatus();
        Integer other$callStatus = other.getCallStatus();
        if (this$callStatus == null ? other$callStatus != null : !((Object)this$callStatus).equals(other$callStatus)) {
            return false;
        }
        Integer this$smsStatus = this.getSmsStatus();
        Integer other$smsStatus = other.getSmsStatus();
        if (this$smsStatus == null ? other$smsStatus != null : !((Object)this$smsStatus).equals(other$smsStatus)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        Integer this$followRecordMsgType = this.getFollowRecordMsgType();
        Integer other$followRecordMsgType = other.getFollowRecordMsgType();
        if (this$followRecordMsgType == null ? other$followRecordMsgType != null : !((Object)this$followRecordMsgType).equals(other$followRecordMsgType)) {
            return false;
        }
        Integer this$isFormCustomer = this.getIsFormCustomer();
        Integer other$isFormCustomer = other.getIsFormCustomer();
        if (this$isFormCustomer == null ? other$isFormCustomer != null : !((Object)this$isFormCustomer).equals(other$isFormCustomer)) {
            return false;
        }
        Long this$msgTime = this.getMsgTime();
        Long other$msgTime = other.getMsgTime();
        if (this$msgTime == null ? other$msgTime != null : !((Object)this$msgTime).equals(other$msgTime)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        if (this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        List<String> this$tolist = this.getTolist();
        List<String> other$tolist = other.getTolist();
        if (this$tolist == null ? other$tolist != null : !((Object)this$tolist).equals(other$tolist)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$createDate = this.getCreateDate();
        String other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !this$createDate.equals(other$createDate)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        return !(this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FollowRecordMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Integer $talkerType = this.getTalkerType();
        result = result * 59 + ($talkerType == null ? 43 : ((Object)$talkerType).hashCode());
        Boolean $external = this.getExternal();
        result = result * 59 + ($external == null ? 43 : ((Object)$external).hashCode());
        Integer $userType = this.getUserType();
        result = result * 59 + ($userType == null ? 43 : ((Object)$userType).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $callType = this.getCallType();
        result = result * 59 + ($callType == null ? 43 : ((Object)$callType).hashCode());
        Integer $callStatus = this.getCallStatus();
        result = result * 59 + ($callStatus == null ? 43 : ((Object)$callStatus).hashCode());
        Integer $smsStatus = this.getSmsStatus();
        result = result * 59 + ($smsStatus == null ? 43 : ((Object)$smsStatus).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        Integer $followRecordMsgType = this.getFollowRecordMsgType();
        result = result * 59 + ($followRecordMsgType == null ? 43 : ((Object)$followRecordMsgType).hashCode());
        Integer $isFormCustomer = this.getIsFormCustomer();
        result = result * 59 + ($isFormCustomer == null ? 43 : ((Object)$isFormCustomer).hashCode());
        Long $msgTime = this.getMsgTime();
        result = result * 59 + ($msgTime == null ? 43 : ((Object)$msgTime).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        List<String> $tolist = this.getTolist();
        result = result * 59 + ($tolist == null ? 43 : ((Object)$tolist).hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : $createDate.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        return result;
    }

    public String toString() {
        return "FollowRecordMsg(corpId=" + this.getCorpId() + ", action=" + this.getAction() + ", from=" + this.getFrom() + ", tolist=" + this.getTolist() + ", updateTime=" + this.getUpdateTime() + ", talkerType=" + this.getTalkerType() + ", external=" + this.getExternal() + ", customerPhone=" + this.getCustomerPhone() + ", userType=" + this.getUserType() + ", userId=" + this.getUserId() + ", callType=" + this.getCallType() + ", callStatus=" + this.getCallStatus() + ", createTime=" + this.getCreateTime() + ", smsStatus=" + this.getSmsStatus() + ", bizId=" + this.getBizId() + ", followRecordMsgType=" + this.getFollowRecordMsgType() + ", createDate=" + this.getCreateDate() + ", msgId=" + this.getMsgId() + ", isFormCustomer=" + this.getIsFormCustomer() + ", msgTime=" + this.getMsgTime() + ")";
    }
}

