/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.dto.jsmsg;

import cn.kinyun.link.common_dto.dto.BaseRequest;
import cn.kinyun.link.service.conversation.request.ConversationBaseDto;
import cn.kinyun.link.service.conversation.request.PublishNoticeReq;
import cn.kinyun.link.service.push.request.BaseSendReq;
import cn.kinyun.link.service.push.request.SendFileReq;
import cn.kinyun.link.service.push.request.SendImgReq;
import cn.kinyun.link.service.push.request.SendLinkCardReq;
import cn.kinyun.link.service.push.request.SendTextReq;
import cn.kinyun.link.service.push.request.SendVideoReq;
import cn.kinyun.link.service.push.request.SendVoiceReq;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.jsmsg.FileDto;
import com.kuaike.scrm.common.dto.jsmsg.JsNewsDto;
import com.kuaike.scrm.common.dto.jsmsg.MiniProgramDto;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.ReceiveType;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class UniformMsgDto {
    private String msgType;
    private String content;
    private FileDto file;
    private JsNewsDto news;
    private MiniProgramDto miniprogram;
    private Date expireTime;
    private String mediaId;
    private String quoteMsgRequestId;

    public UniformMsgDto() {
    }

    public UniformMsgDto(UniformMsgDto dto) {
        BeanUtils.copyProperties((Object)dto, (Object)this);
    }

    public void validate() {
        JsMsgType jsMsgType = JsMsgType.get((String)this.msgType);
        Preconditions.checkArgument((this.msgType != null && jsMsgType != null ? 1 : 0) != 0, (Object)("unknown msgType:" + this.msgType));
        switch (jsMsgType) {
            case TEXT: 
            case MEETING: 
            case NOTICE: 
            case FRIEND_FISSION_WORDS: {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"content can not be null or empty");
                Preconditions.checkArgument((this.content.getBytes().length <= 4000 ? 1 : 0) != 0, (Object)"\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u5927\u4e8e4000\u5b57\u8282");
                break;
            }
            case FILE: 
            case IMAGE: 
            case VIDEO: {
                Preconditions.checkArgument((this.file != null ? 1 : 0) != 0, (Object)"file can not be null");
                this.file.validate();
                break;
            }
            case VOICE: {
                Preconditions.checkArgument((this.file != null ? 1 : 0) != 0, (Object)"file can not be null");
                this.file.voiceValidate();
                break;
            }
            case NEWS: {
                Preconditions.checkArgument((this.news != null ? 1 : 0) != 0, (Object)"news can not be null");
                this.news.validate();
                break;
            }
            case MINI_PROGRAM: {
                Preconditions.checkArgument((this.miniprogram != null ? 1 : 0) != 0, (Object)"miniprogram can not be null");
                this.miniprogram.validate();
                break;
            }
        }
    }

    public BaseRequest convert2BaseRequest(String msgType, Integer receiveType, String targetId) {
        this.validate();
        SendTextReq req = null;
        JsMsgType messageType = JsMsgType.get((String)msgType);
        switch (messageType) {
            case TEXT: 
            case MEETING: 
            case FRIEND_FISSION_WORDS: {
                SendTextReq temText = new SendTextReq();
                temText.setTextContent(this.content);
                req = temText;
                break;
            }
            case IMAGE: {
                SendImgReq temImg = new SendImgReq();
                temImg.setImgUrl(this.file.getFileUrl());
                req = temImg;
                break;
            }
            case NEWS: {
                SendLinkCardReq temLink = new SendLinkCardReq();
                temLink.setIconUrl(this.news.getImgUrl());
                temLink.setUrl(this.news.getLink());
                temLink.setTitle(this.news.getTitle());
                temLink.setDesc(this.news.getDesc());
                req = temLink;
                break;
            }
            case VOICE: {
                SendVoiceReq temVoice = new SendVoiceReq();
                temVoice.setVoiceTime(this.file.getVoiceTime().intValue());
                temVoice.setVoiceUrl(this.file.getExtraUrl());
                req = temVoice;
                break;
            }
            case VIDEO: {
                SendVideoReq temVideo = new SendVideoReq();
                temVideo.setVideoUrl(this.file.getFileUrl());
                req = temVideo;
                break;
            }
            case FILE: {
                SendFileReq temFile = new SendFileReq();
                temFile.setFileUrl(this.file.getFileUrl());
                temFile.setTitle(this.file.getFileName());
                req = temFile;
                break;
            }
            case MINI_PROGRAM: {
                break;
            }
            case NOTICE: {
                PublishNoticeReq noticeReq = new PublishNoticeReq();
                noticeReq.setRoomNotice(this.content);
                req = noticeReq;
                break;
            }
        }
        if (req instanceof BaseSendReq) {
            BaseSendReq sendReq = (BaseSendReq)req;
            if (ReceiveType.CONTACT.getType() == receiveType.intValue()) {
                sendReq.setType(0);
            } else {
                sendReq.setType(1);
            }
            sendReq.setTargetId(targetId);
        } else if (req instanceof ConversationBaseDto && ReceiveType.CHATROOM.getType() == receiveType.intValue()) {
            ConversationBaseDto conversationBaseDto = (ConversationBaseDto)req;
            conversationBaseDto.setChatRoomId(targetId);
        }
        return req;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public FileDto getFile() {
        return this.file;
    }

    public JsNewsDto getNews() {
        return this.news;
    }

    public MiniProgramDto getMiniprogram() {
        return this.miniprogram;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getQuoteMsgRequestId() {
        return this.quoteMsgRequestId;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFile(FileDto file) {
        this.file = file;
    }

    public void setNews(JsNewsDto news) {
        this.news = news;
    }

    public void setMiniprogram(MiniProgramDto miniprogram) {
        this.miniprogram = miniprogram;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setQuoteMsgRequestId(String quoteMsgRequestId) {
        this.quoteMsgRequestId = quoteMsgRequestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniformMsgDto)) {
            return false;
        }
        UniformMsgDto other = (UniformMsgDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        FileDto this$file = this.getFile();
        FileDto other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        JsNewsDto this$news = this.getNews();
        JsNewsDto other$news = other.getNews();
        if (this$news == null ? other$news != null : !((Object)this$news).equals(other$news)) {
            return false;
        }
        MiniProgramDto this$miniprogram = this.getMiniprogram();
        MiniProgramDto other$miniprogram = other.getMiniprogram();
        if (this$miniprogram == null ? other$miniprogram != null : !((Object)this$miniprogram).equals(other$miniprogram)) {
            return false;
        }
        Date this$expireTime = this.getExpireTime();
        Date other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$quoteMsgRequestId = this.getQuoteMsgRequestId();
        String other$quoteMsgRequestId = other.getQuoteMsgRequestId();
        return !(this$quoteMsgRequestId == null ? other$quoteMsgRequestId != null : !this$quoteMsgRequestId.equals(other$quoteMsgRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniformMsgDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        FileDto $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        JsNewsDto $news = this.getNews();
        result = result * 59 + ($news == null ? 43 : ((Object)$news).hashCode());
        MiniProgramDto $miniprogram = this.getMiniprogram();
        result = result * 59 + ($miniprogram == null ? 43 : ((Object)$miniprogram).hashCode());
        Date $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $quoteMsgRequestId = this.getQuoteMsgRequestId();
        result = result * 59 + ($quoteMsgRequestId == null ? 43 : $quoteMsgRequestId.hashCode());
        return result;
    }

    public String toString() {
        return "UniformMsgDto(msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", file=" + this.getFile() + ", news=" + this.getNews() + ", miniprogram=" + this.getMiniprogram() + ", expireTime=" + this.getExpireTime() + ", mediaId=" + this.getMediaId() + ", quoteMsgRequestId=" + this.getQuoteMsgRequestId() + ")";
    }
}

