/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.utils;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class TraceIdUtils {
    private static final Logger log = LoggerFactory.getLogger(TraceIdUtils.class);
    public static final String TRACE_ID = "traceId";
    public static final String B_REQUEST_ID = "B-Request-ID";

    private TraceIdUtils() {
    }

    public static void setTraceId(String traceId) {
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            MDC.put((String)TRACE_ID, (String)traceId);
        }
    }

    public static String getTraceId() {
        return MDC.get((String)TRACE_ID);
    }

    public static String generateTraceId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String genAndSetTraceId() {
        String traceId = TraceIdUtils.generateTraceId();
        TraceIdUtils.setTraceId(traceId);
        return traceId;
    }

    public static void removeTraceId() {
        MDC.remove((String)TRACE_ID);
    }

    public static Map<String, String> getMDCContactMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> contextMap) {
        if (MapUtils.isNotEmpty(contextMap)) {
            MDC.setContextMap(contextMap);
        } else {
            MDC.clear();
        }
    }

    public static void generateTraceIdToRequest(HttpServletRequest request) {
        try {
            String traceId = request.getHeader(B_REQUEST_ID);
            if (Objects.nonNull(traceId)) {
                TraceIdUtils.setTraceId(traceId);
            } else {
                traceId = TraceIdUtils.genAndSetTraceId();
                request.setAttribute(B_REQUEST_ID, (Object)traceId);
            }
        }
        catch (Exception e) {
            String requestURI = request.getRequestURI();
            log.error("\u751f\u6210traceId\u5f02\u5e38:urI:{}", (Object)requestURI, (Object)e);
        }
    }

    public static void generateTraceIdToConsumerRecord(ConsumerRecord<?, ?> consumerRecord) {
        Headers headers = consumerRecord.headers();
        Header header = headers.lastHeader(B_REQUEST_ID);
        if (header != null) {
            TraceIdUtils.setTraceId(new String(header.value()));
        } else {
            TraceIdUtils.genAndSetTraceId();
        }
    }
}

