package com.kuaike.scrm.common.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Objects;

public final class ServletUtil {

	private ServletUtil() {}

	public static URI getReferer(HttpServletRequest request) {
		if (StringUtils.isNotBlank(request.getHeader("referer"))) {
			return URI.create(request.getHeader("referer"));
		}
		return null;
	}

	public static URI getUrl(HttpServletRequest request) {
		return URI.create(request.getRequestURL().toString());
	}

	public static String getBasePath(HttpServletRequest request) {
		URI uri = getReferer(request);
		if (Objects.isNull(uri)) {
			uri = getUrl(request);
		}
		return uri.getScheme() + "://" + uri.getAuthority();
	}

}
