/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.perm.service;

import com.kuaike.common.annotation.LoginNeedless;
import com.kuaike.common.annotation.MethodPermission;
import com.kuaike.common.annotation.ModulePremission;
import com.kuaike.scrm.common.perm.dto.PermissionDto;
import com.kuaike.scrm.common.perm.utils.PermUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class PermScanner
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PermScanner.class);
    @Value(value="${permission.prefix:}")
    private String prefix;
    @Value(value="${permission.token:}")
    private String token;
    private RequestMappingHandlerMapping handlerMapping;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.handlerMapping = (RequestMappingHandlerMapping)applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
    }

    public List<PermissionDto> scanAllPerms() {
        return this.scanAllPerms(this.token);
    }

    public List<PermissionDto> scanAllPerms(String token) {
        log.info("scan all permissions");
        if (!Objects.equals(token, this.token)) {
            log.warn("invalid token:{}", (Object)token);
            throw new IllegalArgumentException("Invalid token");
        }
        ArrayList<PermissionDto> result = new ArrayList<PermissionDto>(512);
        Map handlerMethods = this.handlerMapping.getHandlerMethods();
        for (Map.Entry e : handlerMethods.entrySet()) {
            RequestMappingInfo info = (RequestMappingInfo)e.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)e.getValue();
            Class beanType = handlerMethod.getBeanType();
            if (beanType.getAnnotation(LoginNeedless.class) != null || handlerMethod.getMethodAnnotation(LoginNeedless.class) != null || beanType.getAnnotation(ModulePremission.class) == null || handlerMethod.getMethodAnnotation(MethodPermission.class) == null) continue;
            ModulePremission modulePremission = beanType.getAnnotation(ModulePremission.class);
            assert (modulePremission != null);
            MethodPermission methodPermission = (MethodPermission)handlerMethod.getMethodAnnotation(MethodPermission.class);
            assert (methodPermission != null);
            PermissionDto perm = new PermissionDto();
            perm.setModuleId(modulePremission.module());
            perm.setModuleName(modulePremission.desc());
            perm.setMethodId(methodPermission.permission());
            perm.setName(methodPermission.desc());
            String code = PermUtils.getCodeWithPrefix(this.prefix, perm.getModuleId(), perm.getMethodId());
            perm.setCode(code);
            PatternsRequestCondition condition = info.getPatternsCondition();
            for (String uri : condition.getPatterns()) {
                perm.setPath(PermUtils.getPathWithPrefix(this.prefix, uri));
            }
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            for (RequestMethod method : methodsCondition.getMethods()) {
                perm.setRequestMethod(method.name());
            }
            result.add(perm);
        }
        result.sort(Comparator.comparingLong(it -> (0xFFFFL & (long)it.getModuleId()) << 32 | it.getMethodId()));
        return result;
    }

    public String getToken() {
        return this.token;
    }
}

