/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceIdUtils {
    private static final Logger log = LoggerFactory.getLogger(TraceIdUtils.class);
    public static final String TRACE_ID = "traceId";

    private TraceIdUtils() {
    }

    public static void setTraceId(String traceId) {
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            MDC.put((String)TRACE_ID, (String)traceId);
        }
    }

    public static String getTraceId() {
        return MDC.get((String)TRACE_ID);
    }

    public static String generateTraceId(TraceType traceType) {
        String type = Objects.isNull((Object)traceType) ? "" : traceType.toString();
        String originTraceId = UUID.randomUUID().toString().replace("-", "");
        String traceId = null;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            traceId = type + "-";
        }
        traceId = traceId + originTraceId.substring(0, 20);
        return traceId;
    }

    public static String genAndSetTraceId(TraceType traceType) {
        String traceId = TraceIdUtils.generateTraceId(traceType);
        TraceIdUtils.setTraceId(traceId);
        return traceId;
    }

    public static void removeTraceId() {
        MDC.remove((String)TRACE_ID);
    }

    public static Map<String, String> getMDCContactMap() {
        return MDC.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> contextMap) {
        if (MapUtils.isNotEmpty(contextMap)) {
            MDC.setContextMap(contextMap);
        }
    }

    public static void generateTraceIdToRequest(HttpServletRequest request, TraceType traceType) {
        try {
            String traceId;
            if (Objects.nonNull(request.getAttribute(TRACE_ID))) {
                traceId = request.getAttribute(TRACE_ID).toString();
                TraceIdUtils.setTraceId(traceId);
            } else {
                traceId = TraceIdUtils.genAndSetTraceId(traceType);
            }
            request.setAttribute(TRACE_ID, (Object)traceId);
        }
        catch (Exception e) {
            String requestURI = request.getRequestURI();
            log.error("\u751f\u6210traceId\u5f02\u5e38:urI:{}", (Object)requestURI, (Object)e);
        }
    }

    public static void generateTraceIdToRequest(HttpServletRequest request) {
        TraceIdUtils.generateTraceIdToRequest(request, TraceType.SCRM);
    }

    public static enum TraceType {
        KAFKA,
        SCRM,
        JOB,
        CRM,
        TRADE,
        AD,
        CUSTOMER,
        PAY,
        ORDER;

    }
}

