/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.TraceIdUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class ProviderTraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ProviderTraceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        this.initSession(invocation);
        this.getTraceFromContext();
        Result result2 = result = invoker.invoke(invocation);
        return result2;
    }

    protected void initSession(Invocation invocation) {
        String sessionId = invocation.getAttachment("sessionId");
        String userIdStr = invocation.getAttachment("userId");
        if (sessionId == null || userIdStr == null) {
            return;
        }
        Long userId = Long.parseLong(userIdStr);
        log.debug("initialize rpc sessionId:{}, userId:{}", (Object)sessionId, (Object)userId);
        if (LoginUtils.REDIS_TEMPLATE != null) {
            LoginUtils.initRpcCurrentUser(sessionId, userId);
            log.debug("current user bizId:{}", (Object)LoginUtils.getCurrentUserBizId());
        } else {
            log.warn("redisTemplate is null");
        }
    }

    protected void getTraceFromContext() {
        String traceId = RpcContext.getContext().getAttachment("traceId");
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            TraceIdUtils.setTraceId(traceId);
        }
    }
}

