/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.trace.dubbo;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.kuaike.trace.utils.TraceIdUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class ConsumerTraceIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ConsumerTraceIdFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            this.setTraceToContext();
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (RpcException e) {
            log.error("rpc invoke failed", (Throwable)e);
            return null;
        }
    }

    public void setTraceToContext() {
        String traceId = TraceIdUtils.getTraceId();
        log.debug("consumer setTraceId:{}", (Object)traceId);
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            RpcContext.getContext().setAttachment("traceId", traceId);
        }
    }
}

