/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.kuaike.scrm.common.utils.LoginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class ProviderTraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ProviderTraceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            this.initSession(invocation);
            return invoker.invoke(invocation);
        }
        catch (RpcException e) {
            log.error("\u8c03\u7528dubbo \u63a5\u53e3\u5f02\u5e38\uff0cerrorMsg:{}", (Object)e.getMessage());
            throw e;
        }
    }

    protected void initSession(Invocation invocation) {
        String sessionId = invocation.getAttachment("sessionId");
        String userIdStr = invocation.getAttachment("userId");
        if (sessionId == null || userIdStr == null) {
            return;
        }
        Long userId = Long.parseLong(userIdStr);
        log.debug("initialize rpc sessionId:{}, userId:{}", (Object)sessionId, (Object)userId);
        if (LoginUtils.REDIS_TEMPLATE == null) {
            log.warn("redisTemplate is null");
        } else {
            LoginUtils.initRpcCurrentUser(sessionId, userId);
            log.debug("current user bizId:{}", (Object)LoginUtils.getCurrentUserBizId());
        }
    }
}

