/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.perm.interceptor;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ErrorCodeUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.WebCommonUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.ServletUtil;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class LoginInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(LoginInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        boolean exist = LoginUtils.hasLoginNeedless(handler);
        if (exist) {
            return true;
        }
        LoginUtils.clear();
        LoginUtils.setSession(request.getSession());
        Long loginAccountId = LoginUtils.getLoginAccountId();
        log.debug("LoginInterceptor, LOGIN_ACCOUNT_ID:{}", (Object)loginAccountId);
        if (Objects.nonNull(loginAccountId)) {
            return true;
        }
        this.returnAjaxRepeatloginResponse(request, response);
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        LoginUtils.clear();
    }

    private void returnAjaxRepeatloginResponse(HttpServletRequest request, HttpServletResponse response) {
        WebCommonUtil.returnMessage((HttpServletResponse)response, (String)JacksonUtil.obj2Str((Object)new ApiResult(ErrorCodeUtil.getUniverseErrorCode((UniverseErrorCode)CommonErrorCode.NO_LOGIN), "\u7528\u6237\u672a\u767b\u5f55", Collections.singletonMap("redirectUrl", ServletUtil.getBasePath(request) + "/login?service="))));
    }
}

