/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class ServletUtil {
    private ServletUtil() {
    }

    public static URI getReferer(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("referer"))) {
            return URI.create(request.getHeader("referer"));
        }
        return null;
    }

    public static URI getUrl(HttpServletRequest request) {
        return URI.create(request.getRequestURL().toString());
    }

    public static String getBasePath(HttpServletRequest request) {
        URI uri = ServletUtil.getReferer(request);
        if (Objects.isNull(uri)) {
            uri = ServletUtil.getUrl(request);
        }
        return uri.getScheme() + "://" + uri.getAuthority();
    }
}

