/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.utils;

import com.kuaike.common.annotation.LoginNeedless;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

@Component
public class LoginUtils {
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    public static RedisTemplate<String, Object> REDIS_TEMPLATE;
    public static String REDIS_KEY_PREFIX;
    private static final String LOGIN_MOBILE = "LOGIN_MOBILE";
    private static final String LOGIN_ACCOUNT_ID = "LOGIN_ACCOUNT_ID";
    private static final String LOGIN_KEY = "SCRM_LOGIN_KEY_%s";
    private static final ThreadLocal<CurrentUserInfo> currentUser;
    private static final ThreadLocal<String> SESSION_ID;

    @PostConstruct
    public void init() {
        log.info("Initialize LoginUtils: {}, {}", (Object)this.redisKeyPrefix, this.redisTemplate);
        REDIS_TEMPLATE = this.redisTemplate;
        REDIS_KEY_PREFIX = this.redisKeyPrefix;
    }

    public static void setCurrentUser(CurrentUserInfo user) {
        currentUser.set(user);
    }

    public static CurrentUserInfo getCurrentUser() {
        return currentUser.get();
    }

    public static Long getCurrentUserId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getId();
        }
        return null;
    }

    public static String getCurrentUserCorpId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getCorpId();
        }
        return null;
    }

    public static Long getCurrentUserBizId() {
        CurrentUserInfo loginUser = currentUser.get();
        if (loginUser != null) {
            return loginUser.getBizId();
        }
        return null;
    }

    public static void clear() {
        currentUser.remove();
        SESSION_ID.remove();
    }

    public static String getUserInfoKey(String redisKeyPrefix, Long userId) {
        return redisKeyPrefix + LoginUtils.getSessionId() + String.format(LOGIN_KEY, userId);
    }

    public static void initCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        Object cache = redisTemplate.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
    }

    public static void initRpcCurrentUser(String sessionId, Long userId) {
        String key = LoginUtils.getUserInfoKey(REDIS_KEY_PREFIX, sessionId, userId);
        Object cache = REDIS_TEMPLATE.opsForValue().get((Object)key);
        if (cache != null) {
            if (cache instanceof CurrentUserInfo) {
                LoginUtils.setCurrentUser((CurrentUserInfo)cache);
            } else {
                log.error("The user is not front system.");
            }
        }
    }

    private static String getUserInfoKey(String redisKeyPrefix, String sessionId, Long userId) {
        return redisKeyPrefix + sessionId + String.format(LOGIN_KEY, userId);
    }

    public static void deleteCurrentUser(RedisTemplate<String, Object> redisTemplate, String redisKeyPrefix) {
        String key = LoginUtils.getUserInfoKey(redisKeyPrefix, LoginUtils.getLoginAccountId());
        redisTemplate.delete((Object)key);
    }

    public static boolean hasLoginNeedless(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class type = handlerMethod.getBeanType();
        LoginNeedless loginNeedless = type.getAnnotation(LoginNeedless.class);
        if (loginNeedless == null) {
            loginNeedless = type.getSuperclass().getAnnotation(LoginNeedless.class);
        }
        if (loginNeedless == null) {
            loginNeedless = (LoginNeedless)handlerMethod.getMethodAnnotation(LoginNeedless.class);
        }
        return loginNeedless != null;
    }

    public static HttpSession getSession() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.getRequest().getSession();
    }

    public static void initSessionId(HttpSession httpSession) {
        if (httpSession != null) {
            SESSION_ID.set(httpSession.getId());
        } else {
            SESSION_ID.set(null);
        }
    }

    public static void initSessionId(String sessionId) {
        SESSION_ID.set(sessionId);
    }

    public static String getSessionId() {
        String sessionId = SESSION_ID.get();
        if (sessionId != null) {
            return sessionId;
        }
        HttpSession httpSession = LoginUtils.getSession();
        if (httpSession != null) {
            sessionId = httpSession.getId();
            SESSION_ID.set(sessionId);
        }
        return sessionId;
    }

    public static Long getLoginAccountId() {
        Long userId = null;
        HttpSession httpSession = LoginUtils.getSession();
        if (Objects.nonNull(httpSession)) {
            userId = (Long)httpSession.getAttribute(LOGIN_ACCOUNT_ID);
        }
        return userId;
    }

    public static void setLoginAccountId(Long userId) {
        HttpSession httpSession = LoginUtils.getSession();
        if (Objects.nonNull(httpSession)) {
            httpSession.setAttribute(LOGIN_ACCOUNT_ID, (Object)userId);
        }
    }

    public static void removeLoginAccountId() {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.removeAttribute(LOGIN_ACCOUNT_ID);
            session.removeAttribute(LOGIN_MOBILE);
        }
    }

    public static void setLoginMobile(String mobile) {
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            session.setAttribute(LOGIN_MOBILE, (Object)mobile);
        }
    }

    public static String getLoginMobile() {
        String mobile = null;
        HttpSession session = LoginUtils.getSession();
        if (session != null) {
            mobile = (String)session.getAttribute(LOGIN_MOBILE);
        }
        return mobile;
    }

    static {
        currentUser = new InheritableThreadLocal<CurrentUserInfo>();
        SESSION_ID = new InheritableThreadLocal<String>();
    }
}

