package com.kuaike.scrm.common.dto;

import com.kuaike.common.dto.resp.Node;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.Data;


/**
 * @author sunwen
 */
@Data
public class CurrentUserInfo implements Serializable {

    private static final long serialVersionUID = 1872319669183541525L;

    /**
     * 用户id
     */
    private Long id;
    /**
     * 商户名称
     */
    private String bizName;
    /**
     * 登录名
     */
    private String mobile;
    /**
     * 用户名称
     */
    private String name;
    /**
     * 头像
     */
    private String avatar;

    /**
     * 用户角色
     */
    private List<UserRoleRespDto> roles;

    /**
     * 当前角色
     */
    private UserRoleRespDto curRole;

    /**
     * 用户所在部门的node_id
     */
    private Long userNodeId;

    /**
     * 用户所管理部门及其子部门的node_id
     */
    private List<Long> nodeIds;

    /**
     * 用户所管理部门
     */
    private List<Node> nodes;

    /**
     * sessionId, 前端统计使用
     */
    private String sessionId;

    /**
     * 商户id
     */
    private Long bizId;

    /**
     * 企业id
     */
    private String corpId;

    /**
     * 当前角色对应的菜单编码集合
     */
    private Set<String> menuCodes;

    /**
     * 商户过期时间,时间戳
     */
    private Long expireDate;

    /**
     * 商户状态
     * 1:正常 2:禁用 3:过期
     */
    private Integer bizStatus;

    /**
     * 用户账号是否启用
     * 0:否 1:是
     */
    private Integer enabled;

    private String weworkUserId;

    private String weworkUserNum;
}
